<?php

namespace App\Models\Upload;

use CodeIgniter\Model;

class KelasModel extends Model
{
    protected $table            = 'tb_kelas';
    protected $primaryKey       = 'id_kelas';
    protected $allowedFields    = ['id_kelas', 'kelas', 'id_jurusan'];
    protected $useAutoIncrement = false; // karena ID bisa diedit manual
    protected $returnType       = 'array';


    /*
    |--------------------------------------------------------------------------
    | GET ALL DATA + JOIN JURUSAN
    |--------------------------------------------------------------------------
    */
    public function getAllKelas()
    {
        return $this->select('tb_kelas.*, tb_jurusan.jurusan')
                    ->join('tb_jurusan', 'tb_kelas.id_jurusan = tb_jurusan.id', 'left')
                    ->orderBy('tb_kelas.id_kelas', 'ASC')
                    ->findAll();
    }


    /*
    |--------------------------------------------------------------------------
    | GET BY ID
    |--------------------------------------------------------------------------
    */
    public function getKelas($id)
    {
        return $this->select('tb_kelas.*, tb_jurusan.jurusan')
                    ->join('tb_jurusan', 'tb_kelas.id_jurusan = tb_jurusan.id', 'left')
                    ->where('tb_kelas.id_kelas', $id)
                    ->first();
    }


    /*
    |--------------------------------------------------------------------------
    | GENERATE NEXT ID
    |--------------------------------------------------------------------------
    */
    public function getNextIdKelas()
    {
        $row = $this->selectMax('id_kelas')->first();

        return isset($row['id_kelas'])
            ? ((int) $row['id_kelas'] + 1)
            : 1;
    }


    //TAMBAAHN
    public function getDataKelas()
{
    return $this->select('tb_kelas.*, tb_jurusan.jurusan')
                ->join('tb_jurusan', 'tb_kelas.id_jurusan = tb_jurusan.id', 'left')
                ->orderBy('tb_kelas.id_kelas', 'ASC')
                ->findAll();
}



}
