<?php

namespace App\Models\Upload;

use CodeIgniter\Model;

class SiswaModel extends Model
{
    protected $table      = 'tb_siswa';
    protected $primaryKey = 'id_siswa';

    protected $allowedFields = [
        'nis',
        'nama_siswa',
        'id_kelas',
        'jenis_kelamin',
        'no_hp',
        'unique_code'
    ];

    protected $useTimestamps = false;

    // ===============================
    // METHOD DEFAULT (TIDAK DIUBAH)
    // ===============================

    /**
     * Simpan data siswa
     */
    public function createSiswa($nis, $nama, $idKelas, $jenisKelamin, $noHp)
    {
        return $this->insert([
            'nis'           => $nis,
            'nama_siswa'    => $nama,
            'id_kelas'      => $idKelas,
            'jenis_kelamin' => $jenisKelamin,
            'no_hp'         => $noHp,
        ]);
    }

    /**
     * Update unique_code setelah insert
     */
    public function updateUniqueCode($idSiswa, $uniqueCode)
    {
        return $this->update($idSiswa, [
            'unique_code' => $uniqueCode
        ]);
    }

    // ===============================
    // 🔥 TAMBAHAN BARU
    // ===============================

    /**
     * Ambil semua siswa + nama kelas
     */
    // public function getSiswaWithKelas()
    // {
    //     return $this->select('tb_siswa.*, tb_kelas.kelas')
    //                 ->join('tb_kelas', 'tb_kelas.id_kelas = tb_siswa.id_kelas')
    //                 ->orderBy('tb_siswa.id_siswa', 'DESC')
    //                 ->findAll();
    // }



    /**
 * Ambil semua siswa + nama kelas, urut berdasarkan nama dan kelas
 */
public function getSiswaWithKelas()
{
    return $this->select('tb_siswa.*, tb_kelas.kelas')
                ->join('tb_kelas', 'tb_kelas.id_kelas = tb_siswa.id_kelas')
                ->orderBy('tb_siswa.nama_siswa', 'ASC') // urut nama A-Z
                ->orderBy('tb_kelas.kelas', 'ASC')      // jika nama sama, urut kelas
                ->findAll();
}




    /**
     * Ambil satu siswa + nama kelas
     */
    public function getDetailSiswa($id)
    {
        return $this->select('tb_siswa.*, tb_kelas.kelas')
                    ->join('tb_kelas', 'tb_kelas.id_kelas = tb_siswa.id_kelas')
                    ->where('tb_siswa.id_siswa', $id)
                    ->first();
    }

    // ===============================
// CEK NIS SUDAH ADA ATAU BELUM
// ===============================
public function isNisExists($nis)
{
    return $this->where('nis', $nis)->first() !== null;
}

}
