<?php

namespace App\Models\UserLoginAktif;

use CodeIgniter\Model;

class ModelUserLoginAktif extends Model
{
    protected $table = 'users';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'password_hash'
    ];

    /**
     * Ambil data user login aktif
     */
    public function getUserAktif($id)
    {
        return $this->where('id', $id)->first();
    }

    /**
     * Update password user login aktif
     */
    public function updatePassword($id, $passwordHash)
    {
        return $this->update($id, [
            'password_hash' => $passwordHash
        ]);
    }
}
