<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ================= HEADER CARD ================= */
.header-card{
    border-radius:16px;
    background:linear-gradient(135deg,#0d6efd,#6610f2);
    color:#fff;
    box-shadow:0 8px 18px rgba(0,0,0,.15);
}

/* ================= CARD FILTER ================= */
.card-filter{
    border-radius:14px;
    box-shadow:0 6px 14px rgba(0,0,0,.08);
}

/* GRID TOMBOL KELAS (8 KOLOM) */
.kelas-grid{
    display:grid;
    grid-template-columns: repeat(8, 1fr);
    gap:10px;
}

/* WARNA KELAS */
.btn-purple{ background:#6f42c1; color:#fff; }
.btn-purple:hover{ background:#5a34a1; }
.btn-rose{ background:#e83e8c; color:#fff; }
.btn-rose:hover{ background:#d63384; }

/* RESPONSIVE */
@media (max-width: 992px){
    .kelas-grid{ grid-template-columns: repeat(4, 1fr); }
}
@media (max-width: 576px){
    .kelas-grid{ grid-template-columns: repeat(2, 1fr); }
}
</style>

<div class="content">
<div class="container-fluid">

<!-- ================= HEADER UTAMA (TENGAH) ================= -->
<div class="row mb-3">
    <div class="col-12">
        <div class="card header-card">
            <div class="card-body py-4 text-center">
                <i class="material-icons mb-2" style="font-size:40px;">groups</i>
                <h5 class="fw-bold mb-1">Manajemen Absensi Siswa</h5>
                <small>Pilih kelas dan tanggal untuk menampilkan data kehadiran</small>
            </div>
        </div>
    </div>
</div>

<!-- ================= CARD DAFTAR KELAS ================= -->
<div class="row">
<div class="col-lg-12">

<div class="card card-filter mb-4">
<div class="card-body">

    <!-- JUDUL (RATA KIRI) -->
    <div class="mb-3">
        <h5 class="fw-bold mb-0">
            <i class="material-icons align-middle">school</i>
            Daftar Kelas
        </h5>
        <small class="text-muted">Silakan pilih kelas</small>
    </div>

    <!-- TOMBOL KELAS -->
    <div class="kelas-grid mb-4">
        <?php 
        $i=1;
        foreach ($kelas as $value):
            $idKelas   = $value['id_kelas'];
            $namaKelas = $value['kelas'].' '.$value['jurusan'];

            if ($i <= 12)      $btnClass = 'btn-primary';
            elseif ($i <= 24)  $btnClass = 'btn-purple';
            else               $btnClass = 'btn-rose';
        ?>
            <button
                id="kelas-<?= $idKelas ?>"
                onclick="getSiswa(<?= $idKelas ?>,'<?= $namaKelas ?>')"
                class="btn <?= $btnClass ?> w-100">
                <?= $namaKelas ?>
            </button>
        <?php $i++; endforeach; ?>
    </div>

    <!-- PILIHAN TANGGAL -->
    <div class="row">
        <div class="col-md-4 col-12">
            <label class="fw-semibold mb-1">
                <i class="material-icons align-middle">calendar_today</i>
                Tanggal
            </label>
            <input
                class="form-control"
                type="date"
                id="tanggal"
                value="<?= date('Y-m-d'); ?>"
                onchange="onDateChange()">
        </div>
    </div>

</div>
</div>

</div>
</div>

<!-- ================= CARD KE 2 (TIDAK DIUBAH) ================= -->
     <div class="card" id="dataSiswa">
         <div class="card-body">
            <div class="row justify-content-between">
               <div class="col-auto me-auto">
                  <div class="pt-3 pl-3">
                     <h4><b>Absen Siswa</b></h4>
                     <p>Daftar siswa muncul disini</p>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   <!-- Modal ubah kehadiran -->
   <div class="modal fade" id="ubahModal" tabindex="-1" aria-labelledby="modalUbahKehadiran" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
         <div class="modal-content">
            <div class="modal-header">
               <h5 class="modal-title" id="modalUbahKehadiran">Ubah kehadiran</h5>
               <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
               </button>
            </div>
            <div id="modalFormUbahSiswa"></div>
         </div>
      </div>
   </div>
</div>
<script>
   var lastIdKelas;
   var lastKelas;

   function onDateChange() {
      if (lastIdKelas != null && lastKelas != null) getSiswa(lastIdKelas, lastKelas);
   }

   function getSiswa(idKelas, kelas) {
      var tanggal = $('#tanggal').val();

      updateBtn(idKelas);

      jQuery.ajax({
         url: "<?= base_url('/admin/absen-siswa'); ?>",
         type: 'post',
         data: {
            'kelas': kelas,
            'id_kelas': idKelas,
            'tanggal': tanggal
         },
         success: function(response, status, xhr) {
            // console.log(status);
            $('#dataSiswa').html(response);

            $('html, body').animate({
               scrollTop: $("#dataSiswa").offset().top
            }, 500);
         },
         error: function(xhr, status, thrown) {
            console.log(thrown);
            $('#dataSiswa').html(thrown);
         }
      });

      lastIdKelas = idKelas;
      lastKelas = kelas;
   }

   function updateBtn(id_btn) {
      for (let index = 1; index <= <?= count($kelas); ?>; index++) {
         if (index != id_btn) {
            $('#kelas-' + index).removeClass('btn-success');
            $('#kelas-' + index).addClass('btn-primary');
         } else {
            $('#kelas-' + index).removeClass('btn-primary');
            $('#kelas-' + index).addClass('btn-success');
         }
      }
   }

   function getDataKehadiran(idPresensi, idSiswa) {
      jQuery.ajax({
         url: "<?= base_url('/admin/absen-siswa/kehadiran'); ?>",
         type: 'post',
         data: {
            'id_presensi': idPresensi,
            'id_siswa': idSiswa
         },
         success: function(response, status, xhr) {
            // console.log(status);
            $('#modalFormUbahSiswa').html(response);
         },
         error: function(xhr, status, thrown) {
            console.log(thrown);
            $('#modalFormUbahSiswa').html(thrown);
         }
      });
   }

   function ubahKehadiran() {
      var tanggal = $('#tanggal').val();

      var form = $('#formUbah').serializeArray();

      form.push({
         name: 'tanggal',
         value: tanggal
      });

      console.log(form);

      jQuery.ajax({
         url: "<?= base_url('/admin/absen-siswa/edit'); ?>",
         type: 'post',
         data: form,
         success: function(response, status, xhr) {
            // console.log(status);

            if (response['status']) {
               getSiswa(lastIdKelas, lastKelas);
               alert('Berhasil ubah kehadiran : ' + response['nama_siswa']);
            } else {
               alert('Gagal ubah kehadiran : ' + response['nama_siswa']);
            }
         },
         error: function(xhr, status, thrown) {
            console.log(thrown);
            alert('Gagal ubah kehadiran\n' + thrown);
         }
      });
   }
</script>
<?= $this->endSection() ?>