<style>
/* ================= MOBILE CARD ================= */
@media (max-width: 991px) {

    table.absen-table-desktop {
        display: none;
    }

    .absen-mobile-card {
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 8px 20px rgba(0,0,0,.12);
        margin-bottom: 16px;
        overflow: hidden;
    }

    .absen-mobile-header {
        background: linear-gradient(135deg, #1e88e5, #42a5f5);
        color: #fff;
        padding: 12px 16px;
        font-weight: bold;
        font-size: 16px;
    }

    .absen-mobile-body {
        padding: 14px 16px;
    }

    .absen-row {
        display: grid;
        grid-template-columns: auto 10px 1fr;
        margin-bottom: 6px;
        font-size: 14px;
    }

    .absen-label {
        font-weight: 600;
    }

    .absen-sep {
        text-align: center;
    }

    .absen-action {
        display: flex;
        gap: 10px;
        margin-top: 12px;
    }

    .absen-action .btn {
        flex: 1;
        border-radius: 10px;
    }
}

/* ================= DESKTOP ONLY ================= */
@media (min-width: 992px) {
    .absen-mobile-card {
        display: none;
    }
}
</style>

<!-- ================= HEADER ================= -->
<div class="absen-desktop-card">
<div class="card-body">
    <div class="row align-items-center">
        <div class="col-auto me-auto">
            <div class="pt-3 pl-3">
                <h4><b>Absen Siswa</b></h4>
                <p class="mb-0">Daftar siswa muncul disini</p>
            </div>
        </div>

        <div class="col">
            <a href="#" class="btn btn-primary pl-3 mr-3 mt-3"
               onclick="kelas = onDateChange()" data-toggle="tab">
                <i class="material-icons mr-2">refresh</i> Refresh
            </a>
        </div>

        <div class="col-auto">
            <div class="px-4">
                <h3 class="text-end mb-0">
                    <b class="text-primary"><?= $kelas; ?></b>
                </h3>
            </div>
        </div>
    </div>
</div>
</div>

<!-- ================= DATA ================= -->
<div id="dataSiswa" class="card-body table-responsive pb-5">

<?php if (!empty($data)) : ?>

<!-- ============ DESKTOP TABLE ============ -->
<table class="table table-hover absen-table-desktop">
<thead class="text-primary">
    <th><b>No.</b></th>
    <th><b>NIS</b></th>
    <th><b>Nama Siswa</b></th>
    <th><b>Kehadiran</b></th>
    <th><b>Jam Masuk</b></th>
    <th><b>Jam Duhur</b></th>
    <th><b>Jam Pulang</b></th>
    <th><b>Keterangan</b></th>
    <th><b>Aksi</b></th>
</thead>
<tbody>
<?php $no = 1; foreach ($data as $value) : ?>
<?php
    $idKehadiran = intval($value['id_kehadiran'] ?? ($lewat ? 5 : 4));
    $kehadiran = kehadiran($idKehadiran);
?>
<tr>
    <td><?= $no; ?></td>
    <td><?= $value['nis']; ?></td>
    <td><b><?= $value['nama_siswa']; ?></b></td>
    <td>
        <p class="p-2 w-100 btn btn-<?= $kehadiran['color']; ?> text-center">
            <b><?= $kehadiran['text']; ?></b>
        </p>
    </td>
    <td><b><?= $value['jam_masuk'] ?? '-'; ?></b></td>
    <td><b><?= $value['jam_sholat'] ?? '-'; ?></b></td>
    <td><b><?= $value['jam_keluar'] ?? '-'; ?></b></td>
    <td><?= $value['keterangan'] ?? '-'; ?></td>
    <td>
        <?php if (!$lewat) : ?>
            <button
                data-toggle="modal"
                data-target="#ubahModal"
                onclick="getDataKehadiran(<?= $value['id_presensi'] ?? '-1'; ?>, <?= $value['id_siswa']; ?>)"
                class="btn btn-info p-2">
                <i class="material-icons">edit</i> Edit
            </button>
        <?php else : ?>
            <button class="btn btn-disabled p-2">No Action</button>
        <?php endif; ?>
    </td>
</tr>
<?php $no++; endforeach ?>
</tbody>
</table>

<!-- ============ MOBILE CARD ============ -->
<?php $no = 1; foreach ($data as $value) : ?>
<?php
    $idKehadiran = intval($value['id_kehadiran'] ?? ($lewat ? 5 : 4));
    $kehadiran = kehadiran($idKehadiran);
?>
<div class="absen-mobile-card">
    <div class="absen-mobile-header">
        <?= $no; ?>. <?= $value['nama_siswa']; ?>
    </div>

    <div class="absen-mobile-body">
        <div class="absen-row">
            <div class="absen-label">NIS</div>
            <div class="absen-sep">:</div>
            <div><?= $value['nis']; ?></div>
        </div>

        <div class="absen-row">
            <div class="absen-label">Kehadiran</div>
            <div class="absen-sep">:</div>
            <div><b class="text-<?= $kehadiran['color']; ?>"><?= $kehadiran['text']; ?></b></div>
        </div>

        <div class="absen-row">
            <div class="absen-label">Masuk</div>
            <div class="absen-sep">:</div>
            <div><?= $value['jam_masuk'] ?? '-'; ?></div>
        </div>

        <div class="absen-row">
            <div class="absen-label">Duhur</div>
            <div class="absen-sep">:</div>
            <div><?= $value['jam_sholat'] ?? '-'; ?></div>
        </div>

        <div class="absen-row">
            <div class="absen-label">Pulang</div>
            <div class="absen-sep">:</div>
            <div><?= $value['jam_keluar'] ?? '-'; ?></div>
        </div>

        <div class="absen-action">
            <?php if (!$lewat) : ?>
                <button class="btn btn-info"
                    data-toggle="modal"
                    data-target="#ubahModal"
                    onclick="getDataKehadiran(<?= $value['id_presensi'] ?? '-1'; ?>, <?= $value['id_siswa']; ?>)">
                    <i class="material-icons">edit</i> Edit
                </button>
            <?php else : ?>
                <button class="btn btn-secondary">No Action</button>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $no++; endforeach; ?>

<?php else : ?>
<div class="row">
    <div class="col">
        <h4 class="text-center text-danger">Data tidak ditemukan</h4>
    </div>
</div>
<?php endif; ?>

</div>

<?php
function kehadiran($kehadiran): array
{
    switch ($kehadiran) {
        case 1: return ['color' => 'success', 'text' => 'Hadir'];
        case 2: return ['color' => 'warning', 'text' => 'Sakit'];
        case 3: return ['color' => 'info',    'text' => 'Izin'];
        case 4: return ['color' => 'danger',  'text' => 'Tanpa keterangan'];
        default:return ['color' => 'disabled','text' => 'Belum tersedia'];
    }
}
?>
