<style>
/* ================= MOBILE CARD ================= */
@media (max-width: 991px) {

    table.absen-table-desktop {
        display: none;
    }

    .absen-mobile-card {
        border-radius: 16px;
        box-shadow: 0 8px 20px rgba(0,0,0,.12);
        margin-bottom: 16px;
        overflow: hidden;
        color:#333;
    }

    /* HEADER WARNA BERDASARKAN STATUS */
    .card-hadir   { background:#e8f5e9; border-left:6px solid #2e7d32; }
    .card-sakit   { background:#fffde7; border-left:6px solid #ff8000; }
    .card-izin    { background:#e3f2fd; border-left:6px solid #1565c0; }
    .card-alpa    { background:#ffebee; border-left:6px solid #ff0404; }
    .card-default { background:#f5f5f5; border-left:6px solid #4e75f4; }



    .absen-mobile-header {
        padding: 12px 16px;
        font-weight: bold;
        font-size: 16px;
        background: rgba(54, 48, 238, 0.79);
        color: #ffffff;          /* ⬅️ WARNA TEKS */
    }


    .absen-mobile-body {
        background: rgba(255, 255, 255, 0.92);
        padding: 14px 16px;
    }

    /* GRID 3 KOLOM */
    .absen-row {
        display: grid;
        grid-template-columns: 120px 10px 1fr;
        align-items: start;
        margin-bottom: 6px;
        font-size: 14px;
    }

    .absen-label {
        font-weight: 600;
        text-align: left;
    }

    .absen-sep {
        text-align: center;
        font-weight: 600;
    }

    .absen-value {
        text-align: left;
    }

    .absen-action {
        display: flex;
        gap: 10px;
        margin-top: 14px;
    }

    .absen-action .btn {
        flex: 1;
        border-radius: 10px;
    }
}

/* ================= DESKTOP ONLY ================= */
@media (min-width: 992px) {
    .absen-mobile-card {
        display: none;
    }
}
</style>

<!-- ================= HEADER ================= -->
<div class="absen-desktop-card">
<div class="card-body">
    <div class="row align-items-center">
        <div class="col-auto me-auto">
            <div class="pt-3 pl-3">
                <h4><b>Absen Siswa</b></h4>
                <p class="mb-0">Daftar siswa muncul disini</p>
            </div>
        </div>

        <div class="col">
            <a href="#" class="btn btn-primary pl-3 mr-3 mt-3"
               onclick="kelas = onDateChange()" data-toggle="tab">
                <i class="material-icons mr-2">refresh</i> Refresh
            </a>
        </div>

        <div class="col-auto">
            <div class="px-4">
                <h3 class="text-end mb-0">
                    <b class="text-primary"><?= $kelas; ?></b>
                </h3>
            </div>
        </div>
    </div>
</div>
</div>

<div id="dataSiswa" class="card-body table-responsive pb-5">

<?php if (!empty($data)) : ?>

<!-- ================= DESKTOP TABLE ================= -->
<table class="table table-hover absen-table-desktop">
<thead class="text-primary">
    <th>No.</th>
    <th>NIS</th>
    <th>Nama Siswa</th>
    <th>Kehadiran</th>
    <th>Jam Masuk</th>
    <th>Jam Duhur</th>
    <th>Jam Pulang</th>
    <th>Keterangan</th>
    <th>Aksi</th>
</thead>
<tbody>
<?php $no=1; foreach($data as $value): ?>
<?php
    $idKehadiran = intval($value['id_kehadiran'] ?? ($lewat ? 5 : 4));
    $kehadiran = kehadiran($idKehadiran);
?>
<tr>
    <td><?= $no ?></td>
    <td><?= $value['nis'] ?></td>
    <td><b><?= $value['nama_siswa'] ?></b></td>
    <td>
        <span class="btn btn-<?= $kehadiran['color'] ?> btn-sm">
            <?= $kehadiran['text'] ?>
        </span>
    </td>
    <td><?= $value['jam_masuk'] ?? '-' ?></td>
    <td><?= $value['jam_sholat'] ?? '-' ?></td>
    <td><?= $value['jam_keluar'] ?? '-' ?></td>
    <td><?= $value['keterangan'] ?? '-' ?></td>
    <td>
        <?php if(!$lewat): ?>
        <button class="btn btn-info btn-sm"
            data-toggle="modal"
            data-target="#ubahModal"
            onclick="getDataKehadiran(<?= $value['id_presensi'] ?? -1 ?>, <?= $value['id_siswa'] ?>)">
            <i class="material-icons">edit</i>
        </button>
        <?php else: ?>
        <button class="btn btn-secondary btn-sm">No Action</button>
        <?php endif ?>
    </td>
</tr>
<?php $no++; endforeach ?>
</tbody>
</table>

<!-- ================= MOBILE CARD ================= -->
<?php $no=1; foreach($data as $value): ?>
<?php
$idKehadiran = intval($value['id_kehadiran'] ?? ($lewat ? 5 : 4));
$kehadiran = kehadiran($idKehadiran);

$cardClass = match($kehadiran['text']) {
    'Hadir' => 'card-hadir',
    'Sakit' => 'card-sakit',
    'Izin'  => 'card-izin',
    default => 'card-alpa'
};

$iconKehadiran = match($kehadiran['text']) {
    'Hadir' => 'check_circle',
    'Sakit' => 'healing',
    'Izin'  => 'event_note',
    'Tanpa keterangan' => 'cancel',
    default => 'help_outline',
};
?>
<div class="absen-mobile-card <?= $cardClass ?>">
    <div class="absen-mobile-header">
        <?= $no ?>. <?= $value['nama_siswa'] ?>
    </div>

    <div class="absen-mobile-body">
        <div class="absen-row">
            <div class="absen-label">🎫 NIS</div>
            <div class="absen-sep">:</div>
            <div class="absen-value"><?= $value['nis'] ?></div>
        </div>

        <div class="absen-row">
            <div class="absen-label">
                <i class="material-icons"
                   style="font-size:16px;vertical-align:middle;margin-right:4px">
                    <?= $iconKehadiran ?>
                </i>
                Kehadiran
            </div>
            <div class="absen-sep">:</div>
            <div class="absen-value"><b><?= $kehadiran['text'] ?></b></div>
        </div>

        <div class="absen-row">
            <div class="absen-label">⏰ Masuk</div>
            <div class="absen-sep">:</div>
            <div class="absen-value"><?= $value['jam_masuk'] ?? '-' ?></div>
        </div>

        <div class="absen-row">
            <div class="absen-label">🕌 Duhur</div>
            <div class="absen-sep">:</div>
            <div class="absen-value"><?= $value['jam_sholat'] ?? '-' ?></div>
        </div>

        <div class="absen-row">
            <div class="absen-label">🏁 Pulang</div>
            <div class="absen-sep">:</div>
            <div class="absen-value"><?= $value['jam_keluar'] ?? '-' ?></div>
        </div>

        <div class="absen-action">
            <?php if(!$lewat): ?>
            <button class="btn btn-info"
                data-toggle="modal"
                data-target="#ubahModal"
                onclick="getDataKehadiran(<?= $value['id_presensi'] ?? -1 ?>, <?= $value['id_siswa'] ?>)">
                <i class="material-icons">edit</i> Edit
            </button>
            <?php else: ?>
            <button class="btn btn-secondary">No Action</button>
            <?php endif ?>
        </div>
    </div>
</div>
<?php $no++; endforeach ?>

<?php else: ?>
<h4 class="text-center text-danger">Data tidak ditemukan</h4>
<?php endif ?>
</div>

<?php
function kehadiran($kehadiran): array
{
    return match($kehadiran) {
        1 => ['color'=>'success','text'=>'Hadir'],
        2 => ['color'=>'warning','text'=>'Sakit'],
        3 => ['color'=>'info','text'=>'Izin'],
        4 => ['color'=>'danger','text'=>'Tanpa keterangan'],
        default => ['color'=>'secondary','text'=>'Belum tersedia'],
    };
}
?>
