<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

    <!-- FLASH MESSAGE -->
    <?php if(session()->getFlashdata('success')): ?>
        <div class="px-3 pb-2">
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert">
                    <i class="material-icons">close</i>
                </button>
                <?= session()->getFlashdata('success') ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- CARD -->
    <div class="card">

        <!-- HEADER -->
        <div class="card-header card-header-primary">
            <h4 class="card-title">
                <i class="material-icons">event_available</i>
                <b>Absensi Otomatis</b>
            </h4>
            <p class="card-category">
                Pengisian absensi otomatis berdasarkan waktu
            </p>
        </div>

        <!-- BODY -->
        <div class="card-body">
            <form method="post" action="<?= base_url('admin/absenotomatis/simpan') ?>">
                <?= csrf_field() ?>

                <div class="row">

                    <!-- PILIH KELAS -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Pilih Kelas</label>
                            <select name="id_kelas" class="form-control">
                                <option value="all">Semua Kelas</option>
                                <?php foreach($kelas as $k): ?>
                                    <option value="<?= $k['id_kelas'] ?>">
                                        <?= $k['kelas'] ?> - <?= $k['jurusan'] ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- JENIS ABSEN -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Jenis Absen</label>
                            <select name="jenis_absen" class="form-control" required>
                                <option value="masuk">Masuk</option>
                                <option value="sholat">Sholat</option>
                                <option value="pulang">Pulang</option>
                            </select>
                        </div>
                    </div>

                    <!-- JAM -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Jam</label>
                            <input type="time" name="jam" class="form-control" required>
                        </div>
                    </div>

                    <!-- TANGGAL -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Tanggal</label>
                            <input type="date" name="tanggal" class="form-control"
                                   value="<?= date('Y-m-d') ?>" required>
                        </div>
                    </div>

                </div>

                <!-- BUTTON -->
                <div class="text-end mt-3">
                    <button type="submit" class="btn btn-primary">
                        <i class="material-icons">save</i>
                        Simpan Absensi
                    </button>
                </div>

            <div class="mt-3 text-end">
                <a href="<?= base_url('admin/menuseting') ?>" 
                   class="btn btn-primary w-100" 
                   style="background-color: #9844ff; border-color: #b144ff; color: #fff;">
                    <i class="material-icons">arrow_back</i> Kembali
                </a>
            </div>



            </form>
        </div>

    </div>
</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
