<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content py-4">
    <div class="container">

        <h2 class="mb-4"><?= esc($title) ?></h2>
        <p>Klik tombol di bawah untuk backup database. File akan otomatis di-download.</p>

        <!-- Tombol Kembali -->
        <a href="<?= base_url('admin/menuseting') ?>" class="btn btn-outline-secondary mb-3 d-flex align-items-center">
            <i class="material-icons me-2">arrow_back</i> Kembali
        </a>

        <!-- Backup Button -->
        <a href="<?= base_url('admin/backup/run') ?>" id="backupBtn" class="btn btn-gradient-primary btn-lg d-flex align-items-center">
            <i class="material-icons me-2">backup</i> Backup Database
            <span id="spinner" class="spinner-border spinner-border-sm ms-2" role="status" aria-hidden="true" style="display:none;"></span>
        </a>

    </div>
</div>

<script>
document.getElementById('backupBtn').addEventListener('click', function(e) {
    const btn = this;
    const spinner = document.getElementById('spinner');

    // Tampilkan spinner
    spinner.style.display = 'inline-block';

    // Disable tombol supaya tidak diklik berkali-kali
    btn.classList.add('disabled');
    
    // Tambahkan delay kecil supaya spinner terlihat
    setTimeout(() => {
        // Lanjutkan download dengan navigasi biasa
        window.location.href = btn.href;

        // Sembunyikan spinner setelah 2 detik
        setTimeout(() => {
            spinner.style.display = 'none';
            btn.classList.remove('disabled');
        }, 2000);
    }, 200);
    
    // Cegah default href supaya delay spinner muncul
    e.preventDefault();
});
</script>

<style>
/* Material Dashboard style gradient button */
.btn-gradient-primary {
    background: linear-gradient(90deg, #6a11cb, #2575fc);
    color: #fff;
    font-weight: 500;
    transition: all 0.3s ease;
}
.btn-gradient-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(37, 117, 252, 0.5);
}

/* Tombol Kembali */
.btn-outline-secondary {
    display: inline-flex;
    align-items: center;
    font-weight: 500;
}

/* Spinner posisi */
.spinner-border {
    width: 1rem;
    height: 1rem;
    border-width: 2px;
}
</style>

<?= $this->endSection() ?>
