<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
.dev-wrapper{
    min-height: calc(100vh - 80px);
    padding: clamp(24px,4vw,60px);
    background: linear-gradient(180deg,#f8fafc,#e2e8f0);
}

.dev-panel{
    max-width: 1300px;
    margin: auto;
    background: #fff;
    border-radius: 30px;
    box-shadow: 0 40px 90px rgba(0,0,0,.12);
    overflow: hidden;
}

.dev-header{
    background: linear-gradient(135deg,#020617,#1e293b);
    color: #e5e7eb;
    padding: clamp(30px,4vw,52px);
}

.dev-header h2{
    font-weight: 900;
    font-size: clamp(1.9rem,3vw,2.6rem);
    margin: 0;
}

.dev-header p{
    margin-top: 8px;
    opacity: .85;
}

.dev-body{
    padding: clamp(26px,3vw,50px);
}

.progress-grid{
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px,1fr));
    gap: 26px;
}

.progress-card{
    border-radius: 22px;
    padding: 24px 26px 26px;
    box-shadow: 0 20px 40px rgba(0,0,0,.08);
    background: #f9fafb;
    transition: transform .3s ease, box-shadow .3s ease;
}

.progress-card:hover{
    transform: translateY(-6px);
    box-shadow: 0 28px 60px rgba(0,0,0,.14);
}

.progress-title{
    font-weight: 800;
    font-size: 1.05rem;
    margin-bottom: 4px;
}

.progress-desc{
    font-size: .9rem;
    opacity: .75;
    margin-bottom: 14px;
}

.progress{
    height: 14px;
    border-radius: 999px;
    background: rgba(0,0,0,.08);
    overflow: hidden;
}

.progress-bar{
    border-radius: 999px;
    font-size: .75rem;
    font-weight: 700;
    text-align: right;
    padding-right: 10px;
    line-height: 14px;
}

/* ===== WARNA ===== */
.bg-blue{background: linear-gradient(90deg,#2563eb,#3b82f6);}
.bg-green{background: linear-gradient(90deg,#16a34a,#22c55e);}
.bg-purple{background: linear-gradient(90deg,#7c3aed,#a855f7);}
.bg-orange{background: linear-gradient(90deg,#ea580c,#fb923c);}
.bg-pink{background: linear-gradient(90deg,#db2777,#f472b6);}
.bg-teal{background: linear-gradient(90deg,#0d9488,#2dd4bf);}

.dev-footer{
    padding: 26px 40px;
    background: #f8fafc;
    display: flex;
    justify-content: space-between;
    flex-wrap: wrap;
    gap: 12px;
}
</style>

<div class="content">
<div class="container-fluid dev-wrapper">

    <div class="dev-panel">

        <!-- HEADER -->
        <div class="dev-header">
            <h2>Progress Pengembangan Sistem</h2>
            <p>Ringkasan status fitur utama aplikasi</p>
        </div>

        <!-- BODY -->
        <div class="dev-body">
            <div class="progress-grid">

                <!-- 1 -->
                <div class="progress-card">
                    <div class="progress-title">Manajemen Siswa</div>
                    <div class="progress-desc">CRUD, relasi kelas, dan validasi</div>
                    <div class="progress">
                        <div class="progress-bar bg-blue" style="width:100%">100%</div>
                    </div>
                </div>

                <!-- 2 -->
                <div class="progress-card">
                    <div class="progress-title">Import Data CSV</div>
                    <div class="progress-desc">Upload massal & validasi kolom</div>
                    <div class="progress">
                        <div class="progress-bar bg-green" style="width:80%">80%</div>
                    </div>
                </div>

                <!-- 3 -->
                <div class="progress-card">
                    <div class="progress-title">Manajemen Kelas</div>
                    <div class="progress-desc">Integrasi ID otomatis</div>
                    <div class="progress">
                        <div class="progress-bar bg-purple" style="width:90%">90%</div>
                    </div>
                </div>

                <!-- 4 -->
                <div class="progress-card">
                    <div class="progress-title">Absensi Otomatis</div>
                    <div class="progress-desc">Generate & sinkron data</div>
                    <div class="progress">
                        <div class="progress-bar bg-orange" style="width:60%">60%</div>
                    </div>
                </div>

                <!-- 5 -->
                <div class="progress-card">
                    <div class="progress-title">Laporan & Rekap</div>
                    <div class="progress-desc">Export & filter data</div>
                    <div class="progress">
                        <div class="progress-bar bg-pink" style="width:45%">45%</div>
                    </div>
                </div>

                <!-- 6 -->
                <div class="progress-card">
                    <div class="progress-title">Hak Akses User</div>
                    <div class="progress-desc">Role admin, guru, operator</div>
                    <div class="progress">
                        <div class="progress-bar bg-teal" style="width:70%">70%</div>
                    </div>
                </div>

            </div>
        </div>

        <!-- FOOTER -->
        <div class="dev-footer">
            <small class="text-muted">
                Last update: <?= date('d M Y H:i'); ?>
            </small>
            <a href="<?= base_url('admin'); ?>"
               class="btn btn-dark rounded-pill px-5">
                <i class="material-icons me-1">dashboard</i>
                Dashboard
            </a>
        </div>

    </div>

</div>
</div>

<?= $this->endSection() ?>
