<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content py-4" style="min-height:100vh; background-color:#f8f9fa;">
    <div class="container-fluid">

        <div class="card shadow-sm mb-4">
            <div class="card-header text-white" style="background: linear-gradient(135deg,#0dcaf0,#0d6efd);">
                <h4 class="mb-0"><?= esc($title) ?></h4>
            </div>
            <div class="card-body">

                <!-- Form Filter + Export -->
                <form method="get" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label for="kelas" class="form-label fw-bold">Kelas</label>
                        <select name="kelas" id="kelas" class="form-select" required>
                            <option value="">-- Pilih Kelas --</option>
                            <?php foreach($kelasList as $kelas): ?>
                                <option value="<?= $kelas['id_kelas'] ?>" <?= $selectedKelas == $kelas['id_kelas'] ? 'selected' : '' ?>>
                                    <?= $kelas['kelas'] ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="bulan" class="form-label fw-bold">Bulan</label>
                        <input type="month" name="bulan" id="bulan" class="form-control" value="<?= $bulan ?>" required>
                    </div>
                    <div class="col-md-6 d-flex align-items-end gap-2">
                        <button type="submit" class="btn btn-primary flex-grow-1">Filter</button>
                        <a href="<?= base_url('admin/duhur/rekapdetail') ?>" class="btn btn-secondary flex-grow-1">Reset</a>

                        <?php if(!empty($selectedKelas)): ?>
                            <a href="<?= site_url('admin/duhur/rekapdetail/exportCSV') . '?kelas=' . $selectedKelas . '&bulan=' . $bulan ?>" class="btn btn-success flex-grow-1">Export CSV</a>
                        <?php endif; ?>
                    </div>
                </form>

                <!-- Tabel Rekap -->
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered align-middle">
                        <thead class="table-light text-center">
                            <tr>
                                <th>No</th>
                                <th>Nama Siswa</th>
                                <th>Kelas</th>
                                <th>Jumlah Hadir</th>
                                <th>Total Hari</th>
                                <th>Persentase (%)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(!empty($rekap)): ?>
                                <?php $no=1; foreach($rekap as $row): ?>
                                    <tr>
                                        <td class="text-center"><?= $no++ ?></td>
                                        <td>
                                            <a href="<?= site_url('admin/duhur/rekapdetail/detail/'.$row['id_siswa'].'?bulan='.$bulan.'&kelas='.$selectedKelas) ?>">
                                                <?= esc($row['nama_siswa']) ?>
                                            </a>
                                        </td>
                                        <td class="text-center"><?= esc($row['nama_kelas']) ?></td>
                                        <td class="text-center"><?= $row['hadir'] ?></td>
                                        <td class="text-center"><?= $row['total_hari'] ?></td>
                                        <td class="text-center"><?= $row['total_hari'] > 0 ? round(($row['hadir']/$row['total_hari'])*100,2) : 0 ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" class="text-center text-muted">Data tidak tersedia</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

    </div>
</div>

<?= $this->endSection() ?>
