<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content py-4" style="min-height:100vh; background-color:#f8f9fa;">
    <div class="container-fluid">

        <div class="card shadow-sm mb-4">
            <!-- Header Card -->
            <div class="card-header text-white" style="background: linear-gradient(135deg,#0dcaf0,#0d6efd);">
                <h4 class="mb-0"><?= esc($title) ?></h4>
            </div>

            <div class="card-body">

                <!-- Nama Siswa -->
                <?php if (!empty($namaSiswa)) : ?>
                    <h5 class="fw-bold mb-3">Nama Siswa: <?= esc($namaSiswa) ?></h5>
                <?php endif; ?>

                <!-- Tombol Kembali & Export CSV -->
                <div class="mb-3 d-flex gap-2">
                    <a href="<?= site_url('admin/duhur/rekapdetail') . '?kelas=' . ($selectedKelas ?? '') . '&bulan=' . $bulan ?>" 
                       class="btn btn-secondary">
                        Kembali
                    </a>

                    <a href="<?= site_url('admin/duhur/bulananDuhur/exportCSVDetail') 
                        . '?idSiswa=' . ($idSiswa ?? '') 
                        . '&bulan=' . $bulan ?>" 
                       class="btn btn-success">
                        Export CSV
                    </a>
                </div>

                <!-- Tabel Detail Harian -->
                <div class="table-responsive">
                    <table class="table table-bordered table-striped text-center">
                        <thead class="table-light">
                            <tr>
                                <th>No</th>
                                <th>Tanggal</th>
                                <th>Jam Sholat</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($detail)) : ?>
                                <?php $no = 1; ?>
                                <?php foreach ($detail as $row) : ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= esc($row['tanggal']) ?></td>
                                        <td><?= esc($row['jam_sholat'] ?? '-') ?></td>
                                        <td>
                                            <?php if (!empty($row['jam_sholat'])) : ?>
                                                <span class="badge bg-success">Hadir</span>
                                            <?php else : ?>
                                                <span class="badge bg-danger">Alpa</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <tr>
                                    <td colspan="4">Data tidak tersedia</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

    </div>
</div>

<?= $this->endSection() ?>
