<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ===================== CARD UMUM ===================== */
.card {
    border-radius: 1rem;
    transition: all 0.4s ease;
    box-shadow: 0 6px 10px rgb(0, 0, 0);
    overflow: hidden;
    cursor: pointer;
}

.card:hover {
    transform: translateY(-1px) scale(1.009);
    box-shadow: 0 10px 10px rgba(0,0,0,0.3);
}

.card-icon i {
    font-size: 3rem;
    transition: transform 0.4s ease;
}
.card:hover .card-icon i {
    transform: scale(1.5) rotate(10deg);
}

/* CARD STATUS KEHADIRAN */
.card-status { margin-bottom: 15px; }

/* CARD GRADIENT / GLASS */
.card-gradient {
    background: linear-gradient(135deg, #32355a, #32355a);
    color: #ffffff;
    animation: gradientBG 8s ease infinite;
}
.card-glass {
    background: linear-gradient(135deg, #162f38, #472761);
    color: #fff;
    border-radius: 1rem;
    border: none;
    transition: all 0.4s ease;
}
.card-glass:hover {
    transform: translateY(-4px) scale(1.02);
    box-shadow: 0 8px 15px rgba(0,0,0,0.2);
}

@keyframes gradientBG {
    0% { background-position: 0% 50%; }
    50% { background-position: 100% 50%; }
    100% { background-position: 0% 50%; }
}

.card-category { font-weight: 300; font-size: 0.85rem; color: rgba(255,255,255,0.95); text-transform: uppercase; }
.card-title { font-weight: bold; margin-top: 0.2rem; }
.card-subtitle { font-size: 0.85rem; color: rgba(255,255,255,0.85); }

/* Header Solid */
.card-header-solid { background-color: #0d6efd; color: #fff; font-weight: 600; font-size: 1.2rem; }

/* Header Tabel Desktop */
.table thead.custom-header { background-color: #0d6efd; color: #fff; text-align: center; }

/* Header Mobile */
.mobile-table-header { background-color: #0d6efd; color: #fff; font-weight: 600; padding: 0.5rem; margin-bottom: 0.5rem; }
</style>

<div class="content py-4" style="min-height: 100vh; background-color: #f8f9fa;">
    <div class="container-fluid">

        <div class="card shadow-sm mb-4">
            <div class="card-header card-header-solid">
                <h4 class="mb-0"><?= esc($title ?? '-') ?></h4>
            </div>
            <div class="card-body">

                <!-- Form Filter + Export -->
                <form method="get" class="row g-3 mb-4">
                    <div class="col-12 col-md-3">
                        <label for="kelas" class="form-label fw-bold">Kelas</label>
                        <select name="kelas" id="kelas" class="form-select" required>
                            <option value="">-- Pilih Kelas --</option>
                            <?php foreach($kelasList ?? [] as $kelas): ?>
                                <option value="<?= $kelas['id_kelas'] ?? '' ?>" <?= ($selectedKelas ?? '') == ($kelas['id_kelas'] ?? '') ? 'selected' : '' ?>>
                                    <?= $kelas['kelas'] ?? '-' ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-12 col-md-3">
                        <label for="tanggal" class="form-label fw-bold">Tanggal</label>
                        <input type="date" name="tanggal" id="tanggal" class="form-control" value="<?= $tanggal ?? '' ?>" required>
                    </div>
                    <div class="col-12 col-md-6 d-flex flex-column flex-md-row align-items-stretch gap-2">
                        <button type="submit" class="btn btn-primary flex-grow-1">Filter</button>
                        <a href="<?= base_url('admin/duhur/sholatduhur') ?>" class="btn btn-secondary flex-grow-1">Reset</a>
                        <?php if(!empty($selectedKelas) && !empty($tanggal)): ?>
                            <a href="<?= base_url('admin/duhur/harianduhur/exportXLSX') . '?kelas=' . $selectedKelas . '&tanggal=' . $tanggal ?>" class="btn btn-primary flex-grow-1">Export XLSX</a>
                            <a href="<?= base_url('admin/duhur/sholatduhur/exportCSV') . '?kelas=' . $selectedKelas . '&tanggal=' . $tanggal ?>" class="btn btn-success flex-grow-1">Export CSV</a>
                        <?php endif; ?>
                    </div>
                </form>

                <!-- Ringkasan Kehadiran Interaktif -->
                <?php 
                    $hadir = $sakit = $izin = $alpa = $ikutSholat = 0;
                    foreach($laporan ?? [] as $row) {
                        switch($row['id_kehadiran'] ?? '') {
                            case '1': $hadir++; break;
                            case '2': $sakit++; break;
                            case '3': $izin++; break;
                            default: $alpa++;
                        }
                        if(!empty($row['jam_sholat'])) $ikutSholat++;
                    }
                    $barisCards = [
                        ['color'=>'success','icon'=>'how_to_reg','title'=>'Hadir','value'=>$hadir,'link'=>''],
                        ['color'=>'warning','icon'=>'medical_services','title'=>'Sakit','value'=>$sakit,'link'=>''],
                        ['color'=>'info','icon'=>'assignment_turned_in','title'=>'Izin','value'=>$izin,'link'=>''],
                        ['color'=>'danger','icon'=>'qr_code_scanner','title'=>'Alpa','value'=>$alpa,'link'=>''],
                        ['color'=>'primary','icon'=>'event_available','title'=>'Ikut Sholat Duhur','value'=>$ikutSholat,'link'=>''],
                        ['color'=>'secondary','icon'=>'group','title'=>'Total Siswa','value'=>count($laporan ?? []),'link'=>'']
                    ];
                ?>
                <div class="row mb-4">
                    <?php foreach($barisCards as $c): ?>
                        <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                            <div class="card card-glass text-center text-white">
                                <div class="card-body">
                                    <div class="card-icon mb-1"><i class="material-icons"><?= $c['icon'] ?? '' ?></i></div>
                                    <h6><?= $c['title'] ?? '-' ?></h6>
                                    <h4><?= $c['value'] ?? 0 ?></h4>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
 <div class="container-fluid">
                <!-- Tabel Desktop -->
                <div class="table-responsive d-none d-sm-block">
                    <table class="table table-striped table-hover table-bordered align-middle">
                        <thead class="custom-header">
                            <tr>
                                <th>No</th>
                                <th>Nama Siswa</th>
                                <th>JK</th>
                                <th>Kelas</th>
                                <th>Jam Masuk</th>
                                <th>Jam Sholat</th>
                                <th>Jam Keluar</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(!empty($laporan)): ?>
                                <?php $no = 1; foreach($laporan as $row): ?>
                                    <?php 
                                        $statusText = match($row['id_kehadiran'] ?? '') {
                                            '1' => 'Hadir',
                                            '2' => 'Sakit',
                                            '3' => 'Izin',
                                            default => 'Alpa',
                                        };
                                        $badgeClass = match($row['id_kehadiran'] ?? '') {
                                            '1' => 'bg-success',
                                            '2' => 'bg-warning text-dark',
                                            '3' => 'bg-info text-dark',
                                            default => 'bg-danger',
                                        };
                                    ?>
                                    <tr>
                                        <td class="text-center"><?= $no++ ?></td>
                                        <td>
                                            <a href="<?= site_url('admin/duhur/bulananDuhur/detail/' . $row['id_siswa'] . '?kelas=' . ($selectedKelas ?? '') . '&tanggal=' . $tanggal) ?>" class="text-decoration-none">
                                                <?= esc($row['nama_siswa'] ?? '-') ?>
                                            </a>
                                        </td>
                                        <td class="text-center"><?= esc($row['jk'] ?? '-') ?></td>
                                        <td class="text-center"><?= esc($row['kelas'] ?? $row['nama_kelas'] ?? '-') ?></td>
                                        <td class="text-center">
                                            <?php 
                                                if(!empty($row['jam_masuk'])) {
                                                    echo ($row['jam_masuk'] > '07:00:00') ? esc($row['jam_masuk']).' <span class="text-danger fw-bold">Terlambat</span>' : esc($row['jam_masuk']);
                                                } else { echo '-'; }
                                            ?>
                                        </td>
                                        <td class="text-center">
                                            <?= !empty($row['jam_sholat']) ? esc($row['jam_sholat']) : (($row['id_kehadiran']=='1') ? '<span class="text-danger fw-bold">Tidak Solat</span>' : '-') ?>
                                        </td>
                                        <td class="text-center">
                                            <?= !empty($row['jam_keluar']) ? esc($row['jam_keluar']) : (($row['id_kehadiran']=='1') ? '<span class="text-danger fw-bold">TAP</span>' : '-') ?>
                                        </td>
                                        <td class="text-center"><span class="badge <?= $badgeClass ?>"><?= $statusText ?></span></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr><td colspan="8" class="text-center text-muted">Data tidak tersedia</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Mobile Card -->
                <div class="d-block d-sm-none">
                    <?php if(!empty($laporan)): ?>
                        <?php $no = 1; foreach($laporan as $row): ?>
                            <?php 
                                $statusText = match($row['id_kehadiran'] ?? '') { '1'=>'Hadir','2'=>'Sakit','3'=>'Izin',default=>'Alpa' };
                                $statusColor = match($row['id_kehadiran'] ?? '') { '1'=>'#28a745','2'=>'#fbff00','3'=>'#17a2b8',default=>'#ff0000' };
                                $foto = !empty($row['photo']) ? base_url('uploads/siswa/'.$row['photo']) : base_url('uploads/default.png');
                                $jamSholatDisplay = !empty($row['jam_sholat']) ? esc($row['jam_sholat']) : (($row['id_kehadiran']=='1') ? '<span class="badge text-bg-danger">Tidak</span>' : '-');
                                $jamMasukDisplay = !empty($row['jam_masuk']) ? (($row['jam_masuk'] > '07:00:00') ? esc($row['jam_masuk']).' <span class="text-danger fw-bold">Terlambat</span>' : esc($row['jam_masuk'])) : '-';
                                $jamKeluarDisplay = !empty($row['jam_keluar']) ? esc($row['jam_keluar']) : (($row['id_kehadiran']=='1') ? '<span class="text-danger fw-bold">TAP</span>' : '-');
                            ?>
                            <div class="card mb-3 shadow-sm mobile-card">
                                <div class="card-header">
                                    <a href="<?= site_url('admin/duhur/bulananDuhur/detail/' . $row['id_siswa'] . '?kelas=' . ($selectedKelas ?? '') . '&tanggal=' . $tanggal) ?>" class="text-decoration-none text-white">
                                        <?= esc($row['nama_siswa'] ?? '-') ?> • <?= esc($row['kelas'] ?? $row['nama_kelas'] ?? '-') ?>
                                    </a>
                                </div>
                                <div class="card-body d-flex gap-3 align-items-center">
                                    <div class="avatar"><img src="<?= $foto ?>" alt="Foto Siswa"></div>
                                    <div class="info flex-grow-1">
                                        <h6 class="mb-1">
                                            <a href="<?= site_url('admin/duhur/bulananDuhur/detail/' . $row['id_siswa'] . '?kelas=' . ($selectedKelas ?? '') . '&tanggal=' . $tanggal) ?>" class="text-decoration-none text-dark">
                                                <?= esc($row['nama_siswa'] ?? '-') ?>
                                            </a>
                                        </h6>
                                        <p class="mb-2 text-muted"><?= esc($row['nis'] ?? '-') ?> | <?= esc($row['jk'] ?? '-') ?></p>
                                        <div class="d-flex justify-content-between text-center mb-1">
                                            <div><small>Jam Masuk</small><div><?= $jamMasukDisplay ?></div></div>
                                            <div><small>Jam Sholat</small><div><?= $jamSholatDisplay ?></div></div>
                                            <div><small>Jam Pulang</small><div><?= $jamKeluarDisplay ?></div></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="status-bar mt-2" style="background-color: <?= $statusColor ?>;"><?= $statusText ?></div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="text-center text-muted">Data tidak tersedia</div>
                    <?php endif; ?>
                </div>

<style>
/* Mobile Card Styling */
.mobile-card { border-radius: 12px; overflow: hidden; border: none; }
.mobile-card .card-header { background-color: #0d6efd; color: #fff; font-weight: 600; font-size: 0.9rem; }
.mobile-card .avatar img { width: 50px; height: 50px; border-radius: 50%; object-fit: cover; border: 2px solid #fff; }
.mobile-card .info small { font-size: 0.75rem; color: #6c757d; }
.mobile-card .status-bar { text-align: center; color: #fff; font-weight: 600; padding: 6px 0; border-radius: 4px; }
.mobile-card .badge.text-bg-danger { font-size: 0.75rem; padding: 2px 6px; }
</style>

            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
