<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content py-3">
<div class="container-fluid">

<!-- ================= HEADER ================= -->
<div class="card shadow-sm mb-3">
    <div class="card-body d-flex align-items-center">
        <h6 class="fw-bold mb-0"><i class="material-icons fs-6">event_busy</i> Daftar Hari Libur</h6>
    </div>
</div>

<!-- ================= TABLE ================= -->
<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="table-primary text-center">
                    <tr>
                        <th>No</th>
                        <th>Hari</th>
                        <th>Tanggal</th>
                        <th>Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Array nama hari dalam bahasa Indonesia
                    $hariIndonesia = [
                        'Monday' => 'Senin',
                        'Tuesday' => 'Selasa',
                        'Wednesday' => 'Rabu',
                        'Thursday' => 'Kamis',
                        'Friday' => 'Jumat',
                        'Saturday' => 'Sabtu',
                        'Sunday' => 'Minggu'
                    ];
                    ?>
                    <?php if(!empty($harilibur)): ?>
                        <?php 
                        // Urutkan berdasarkan tanggal terkecil
                        usort($harilibur, function($a,$b){
                            return strtotime($a['tanggal']) - strtotime($b['tanggal']);
                        });
                        ?>
                        <?php foreach($harilibur as $i => $h): 
                            $hari = $hariIndonesia[date('l', strtotime($h['tanggal']))] ?? '';
                        ?>
                            <tr class="<?= ($hari=='Sabtu'||$hari=='Minggu')?'table-warning':'' ?>">
                                <td class="text-center"><?= $i+1 ?></td>
                                <td class="text-center"><?= $hari ?></td>
                                <td class="text-center"><?= $h['tanggal'] ?></td>
                                <td><?= esc($h['keterangan']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center">Tidak ada hari libur</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

</div>
</div>

<?= $this->endSection() ?>
