<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ===== CARD HEADER ===== */
.card-header-info{
    background: linear-gradient(135deg, #0dcaf0, #0d6efd);
    color:#fff;
}

/* ===== FORM CONTROL ===== */
.form-control,
.form-select{
    border-radius:12px;
    padding:10px 14px;
}

.form-control:focus,
.form-select:focus{
    box-shadow:0 0 0 .2rem rgba(13,110,253,.15);
    border-color:#0d6efd;
}

/* ===== FORM CARD ===== */
.form-card{
    border-radius:18px;
}

/* ===== BUTTON ===== */
.btn{
    border-radius:12px;
}

/* ===== SECTION TITLE ===== */
.section-title{
    font-weight:600;
    margin-bottom:8px;
}
</style>

<div class="content" style="background:#f8f9fa; min-height:100vh;">
<div class="container-fluid px-2 px-md-4">

<div class="card form-card shadow border-0 rounded-4">
    <!-- HEADER -->
    <div class="card-header card-header-info py-3 rounded-top-4">
        <div class="d-flex justify-content-between align-items-center">
            <h4 class="mb-0 fw-semibold">⏰ Tambah Jam Presensi</h4>
        </div>
    </div>

    <div class="card-body p-3 p-md-4">

        <form method="post" action="<?= base_url('admin/jam-presensi/store') ?>">

            <!-- JENIS -->
            <div class="mb-4">
                <label class="form-label section-title">
                    Jenis Presensi
                </label>
                <select name="jenis" class="form-select" required>
                    <option value="">-- Pilih Jenis Presensi --</option>
                    <option value="masuk">Masuk</option>
                    <option value="duhur">Duhur</option>
                    <option value="pulang">Pulang</option>
                </select>
            </div>

            <!-- JAM -->
            <div class="row g-3 mb-4">
                <div class="col-md-6">
                    <label class="form-label section-title">
                        Jam Mulai
                    </label>
                    <input type="time"
                           name="jam_mulai"
                           class="form-control"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label section-title">
                        Jam Selesai
                    </label>
                    <input type="time"
                           name="jam_selesai"
                           class="form-control"
                           required>
                </div>
            </div>

            <!-- ACTION -->
            <div class="d-flex gap-2 mt-4">
                <button type="submit"
                        class="btn btn-success px-4 fw-semibold shadow-sm">
                    💾 Simpan
                </button>

                <a href="<?= base_url('admin/jam-presensi') ?>"
                   class="btn btn-outline-secondary px-4 fw-semibold">
                    ← Kembali
                </a>
            </div>

        </form>

    </div>
</div>

</div>
</div>

<?= $this->endSection() ?>
