<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ===== HEADER ===== */
.card-header-info{
    background: linear-gradient(135deg, #0dcaf0, #0d6efd);
    color:#fff;
}

/* ===== FORM ===== */
.form-control, .form-select{
    border-radius:12px;
}
.form-control:focus,
.form-select:focus{
    box-shadow:0 0 0 .2rem rgba(13,110,253,.15);
    border-color:#0d6efd;
}

/* ===== CARD ===== */
.form-card{
    border-radius:18px;
}

/* ===== BUTTON LOADING ===== */
.btn-loading{
    pointer-events:none;
    opacity:.8;
}
</style>

<div class="content" style="background:#f8f9fa; min-height:100vh;">
<div class="container-fluid px-2 px-md-4">

<div class="card form-card shadow border-0">
    <!-- HEADER -->
    <div class="card-header card-header-info py-3 rounded-top-4">
        <h4 class="mb-0 fw-semibold">
            ✏️ Edit Jam Presensi
        </h4>
    </div>

    <div class="card-body p-3 p-md-4">

        <form method="post"
              action="<?= base_url('admin/jam-presensi/update/'.$row['id']) ?>">

            <!-- JENIS -->
            <div class="mb-3">
                <label class="form-label fw-semibold">Jenis Presensi</label>
                <select name="jenis" class="form-select" required>
                    <option value="masuk" <?= $row['jenis']=='masuk'?'selected':'' ?>>Masuk</option>
                    <option value="duhur" <?= $row['jenis']=='duhur'?'selected':'' ?>>Duhur</option>
                    <option value="pulang" <?= $row['jenis']=='pulang'?'selected':'' ?>>Pulang</option>
                </select>
            </div>

            <!-- JAM -->
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label fw-semibold">Jam Mulai</label>
                    <input type="time"
                           name="jam_mulai"
                           class="form-control"
                           value="<?= substr($row['jam_mulai'],0,5) ?>"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Jam Selesai</label>
                    <input type="time"
                           name="jam_selesai"
                           class="form-control"
                           value="<?= substr($row['jam_selesai'],0,5) ?>"
                           required>
                </div>
            </div>

            <!-- STATUS -->
            <div class="mt-3 mb-4">
                <label class="form-label fw-semibold">Status</label>
                <select name="aktif" class="form-select">
                    <option value="1" <?= $row['aktif']==1?'selected':'' ?>>Aktif</option>
                    <option value="0" <?= $row['aktif']==0?'selected':'' ?>>Nonaktif</option>
                </select>
            </div>

            <!-- ACTION -->
            <div class="d-flex gap-2">
                <button type="submit"
                        id="btnSubmit"
                        class="btn btn-success px-4 fw-semibold">
                    <span class="btn-text">💾 Simpan Perubahan</span>
                    <span class="spinner-border spinner-border-sm ms-2 d-none"
                          role="status"></span>
                </button>

                <a href="<?= base_url('admin/jam-presensi') ?>"
                   class="btn btn-outline-secondary px-4 fw-semibold">
                    ← Kembali
                </a>
            </div>

        </form>

    </div>
</div>

</div>
</div>

<script>
document.querySelector('form').addEventListener('submit', function () {
    const btn = document.getElementById('btnSubmit');
    btn.disabled = true;
    btn.classList.add('btn-loading');
    btn.querySelector('.btn-text').textContent = 'Menyimpan...';
    btn.querySelector('.spinner-border').classList.remove('d-none');
});
</script>

<?= $this->endSection() ?>
