<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ===== CARD HEADER ===== */
.card-header-info{
    background: linear-gradient(135deg, #0dcaf0, #0d6efd);
    color:#fff;
    border-bottom: 1px solid rgba(0,0,0,0.1);
}

/* ===== BADGE JAM ===== */
.badge-jam{
    background: linear-gradient(135deg, #6c5ce7, #00b894);
    color: #fff;
    border-radius:20px;
    font-weight:600;
    padding:6px 16px;
    font-size:0.95rem;
    transition: 0.2s;
    display: inline-block;
}
.badge-jam:hover {
    transform: scale(1.05);
}

/* ===== ACTION BUTTON ===== */
.btn-action{
    border-radius:12px;
    padding:6px 12px;
    font-weight:500;
    transition:0.2s;
}
.btn-action:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}

/* ===== BUTTON WARNA SEGAR ===== */
.btn-primary{
    background: #0d6efd;
    border: none;
    transition: 0.2s;
}
.btn-primary:hover{
    background: #0b5ed7;
}
.btn-warning{
    background: #0730ff;
    border: none;
    transition: 0.2s;
}
.btn-warning:hover{
    background: #ff15ad;
}
.btn-danger{
    background: #dc3545;
    border: none;
    transition: 0.2s;
}
.btn-danger:hover{
    background: #ff0019;
}
.btn-outline-secondary{
    color:#6c757d;
    border-color:#6c757d;
}
.btn-outline-secondary:hover{
    background:#6c757d;
    color:#fff;
}

/* ===== MOBILE CARD ===== */
.jam-card{
    border-radius:20px;
    transition:.3s ease;
    background: #569cf1;
}
.jam-card:hover{
    transform:translateY(-3px);
    box-shadow:0 12px 25px rgba(0,0,0,.08);
}

/* Badge status lebih menarik di mobile */
.jam-card .badge{
    font-size:0.85rem;
    padding:5px 12px;
}

/* Tombol mobile full-width dengan warna segar */
.jam-card .btn-warning{
    background: #7330ee;
    color: #ffffff;
}
.jam-card .btn-warning:hover{
    background: #0011ff;
}
.jam-card .btn-outline-secondary{
    background: #0e4092;
    color: #ffffff;
}
.jam-card .btn-outline-secondary:hover{
    background: #ff11a4;
    color: #000000;
}
.jam-card .btn-danger{
    background: #0b2751;
    color: #fff;
}
.jam-card .btn-danger:hover{
    background: #33ff0b;
}

/* Table desktop responsive */
.table td, .table th{
    vertical-align: middle;
    font-size:0.9rem;
    padding:0.55rem;
}
.table-hover tbody tr:hover{
    background: rgba(13,110,253,0.05);
}

/* MODAL DELETE */
.modal-content{
    border-radius:20px;
}
.modal-body h4{
    font-size:1.25rem;
}
.modal-body p{
    font-size:0.9rem;
}
.modal-body .btn{
    font-weight:600;
}

/* ===== RESPONSIVE MOBILE ===== */
@media (max-width: 575.98px){
    .badge-jam{
        font-size:0.85rem;
        padding:5px 12px;
    }
    .btn-action{
        font-size:0.85rem;
        padding:5px 10px;
    }
    .table td, .table th{
        font-size:0.82rem;
        padding:0.4rem;
    }
    .jam-card .btn{
        font-size:0.9rem;
        padding:0.5rem;
        border-radius:12px;
    }
    .jam-card .d-flex.gap-2{
        flex-direction: column;
    }
}
</style>

<div class="content" style="background:#f8f9fa; min-height:100vh;">
<div class="container-fluid px-2 px-md-4">

<div class="card shadow border-0 rounded-4">
    <!-- HEADER -->
    <div class="card-header card-header-info py-3 rounded-top-4">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <h4 class="mb-0 fw-semibold">⏰ Jam Presensi</h4>

            <div class="d-flex gap-2 mt-2 mt-md-0">
                <a href="<?= base_url('admin/menuseting') ?>" 
                   class="btn btn-secondary btn-sm fw-semibold shadow-sm">
                   ← Kembali
                </a>

                <a href="<?= base_url('admin/jam-presensi/create') ?>"
                   class="btn btn-light btn-sm fw-semibold shadow-sm">
                   + Tambah Jam
                </a>
            </div>
        </div>
    </div>

    <div class="card-body p-3 p-md-4">

    <!-- ================= DESKTOP ================= -->
    <div class="d-none d-md-block">
        <div class="table-responsive">
            <table class="table table-hover align-middle text-center">
                <thead class="table-light">
                    <tr>
                        <th>Jenis</th>
                        <th>Jam</th>
                        <th>Status</th>
                        <th width="220">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($jam as $j): ?>
                <tr>
                    <td class="fw-semibold text-uppercase"><?= esc($j['jenis']) ?></td>

                    <td>
                        <span class="badge-jam">
                            <?= substr($j['jam_mulai'],0,5) ?> - <?= substr($j['jam_selesai'],0,5) ?>
                        </span>
                    </td>

                    <td>
                        <?= $j['aktif']
                            ? '<span class="badge bg-success">Aktif</span>'
                            : '<span class="badge bg-danger">Nonaktif</span>' ?>
                    </td>

                    <td>
                        <div class="d-flex justify-content-center gap-2">
                            <a href="<?= base_url('admin/jam-presensi/edit/'.$j['id']) ?>"
                               class="btn btn-warning btn-sm btn-action">
                               ✏️
                            </a>

                            <a href="<?= base_url('admin/jam-presensi/toggle/'.$j['id']) ?>"
                               class="btn btn-outline-secondary btn-sm btn-action">
                               🔁
                            </a>

                            <!-- DELETE BUTTON -->
                            <button type="button"
                                class="btn btn-danger btn-sm btn-action"
                                data-bs-toggle="modal"
                                data-bs-target="#deleteModal"
                                data-id="<?= $j['id'] ?>"
                                data-name="<?= esc($j['jenis']) ?>">
                                🗑️
                            </button>
                        </div>
                    </td>
                </tr>
                <?php endforeach ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- ================= MOBILE ================= -->
    <div class="d-block d-md-none">
        <div class="row g-3">
        <?php foreach ($jam as $j): ?>
        <div class="col-12">
            <div class="card jam-card shadow-sm border-0">
                <div class="card-body">

                    <div class="d-flex justify-content-between mb-2">
                        <span class="fw-semibold text-uppercase"><?= esc($j['jenis']) ?></span>
                        <?= $j['aktif']
                            ? '<span class="badge bg-success">Aktif</span>'
                            : '<span class="badge bg-danger">Nonaktif</span>' ?>
                    </div>

                    <div class="bg-light rounded-3 text-center py-3 mb-3">
                        <h5 class="fw-bold mb-0">
                            <?= substr($j['jam_mulai'],0,5) ?> – <?= substr($j['jam_selesai'],0,5) ?>
                        </h5>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="<?= base_url('admin/jam-presensi/edit/'.$j['id']) ?>"
                           class="btn btn-warning btn-sm w-100">
                           ✏️ Edit
                        </a>
                        <a href="<?= base_url('admin/jam-presensi/toggle/'.$j['id']) ?>"
                           class="btn btn-outline-secondary btn-sm w-100">
                           🔁 Toggle
                        </a>
                    </div>

                    <button type="button"
                        class="btn btn-danger btn-sm w-100 mt-2"
                        data-bs-toggle="modal"
                        data-bs-target="#deleteModal"
                        data-id="<?= $j['id'] ?>"
                        data-name="<?= esc($j['jenis']) ?>">
                        🗑️ Hapus
                    </button>

                </div>
            </div>
        </div>
        <?php endforeach ?>
        </div>
    </div>

    </div>
</div>

</div>
</div>

<!-- ================= MODAL DELETE ================= -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 rounded-5 shadow-lg">

      <div class="modal-body text-center p-4">

        <div class="mb-3">
          <div class="bg-danger bg-opacity-10 rounded-circle d-inline-flex
                      align-items-center justify-content-center"
               style="width:90px;height:90px;">
            <span style="font-size:42px;">🗑️</span>
          </div>
        </div>

        <h4 class="fw-bold mb-1">Bener Arek Di Hapus?</h4>
        <p class="text-muted mb-3">
          Soalna Data <strong id="deleteName">-</strong> bakal di pupus
          moal bisa di balikeun deui.
        </p>

        <div class="d-flex justify-content-center gap-3 mt-4">
          <button type="button"
                  class="btn btn-light px-4 rounded-pill"
                  data-bs-dismiss="modal">
            Moal Jadi
          </button>

          <a id="deleteConfirmBtn"
             class="btn btn-danger px-4 rounded-pill shadow-sm">
             Pupus We lah
          </a>
        </div>

      </div>

    </div>
  </div>
</div>

<script>
const deleteModal = document.getElementById('deleteModal');

deleteModal.addEventListener('show.bs.modal', function (event) {
    const button = event.relatedTarget;
    const id   = button.getAttribute('data-id');
    const name = button.getAttribute('data-name');

    document.getElementById('deleteName').innerText = name;
    document.getElementById('deleteConfirmBtn').href =
        "<?= base_url('admin/jam-presensi/delete/') ?>" + id;
});
</script>

<?= $this->endSection() ?>
