<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<?php
function formatTanggalHari($tanggal)
{
    if (!$tanggal) return '-';
    $hari = [
        'Sunday'=>'Minggu','Monday'=>'Senin','Tuesday'=>'Selasa',
        'Wednesday'=>'Rabu','Thursday'=>'Kamis','Friday'=>'Jumat','Saturday'=>'Sabtu'
    ];
    return $hari[date('l', strtotime($tanggal))].', '.date('d-m-Y', strtotime($tanggal));
}

function ambilJam($row, $keys)
{
    foreach ($keys as $key) {
        if (!empty($row[$key])) return $row[$key];
    }
    return '-';
}

// 🔥 CEK TELAT (BATAS 07:00)
function isTelat($status, $jamMasuk)
{
    if ($status !== 'Hadir') return false;
    if (!$jamMasuk || $jamMasuk === '-') return false;
    return $jamMasuk > '07:00';
}

// 🔥 JAM KELUAR + TAP
function jamKeluarDenganTap($status, $jamMasuk, $jamKeluar)
{
    if ($status !== 'Hadir') return '-';

    if ($jamMasuk !== '-' && ($jamKeluar === '-' || empty($jamKeluar))) {
        return '<span class="badge bg-danger">TAP</span>';
    }

    return $jamKeluar ?: '-';
}
?>

<style>
.detail-card{border-radius:18px;overflow:hidden}
.detail-header{background:linear-gradient(135deg,#0dcaf0,#0d6efd);color:#fff}
.table tbody tr:hover{background:#f1f8ff}
.badge-status{padding:6px 12px;font-size:13px;border-radius:12px}
.mobile-detail-card{
    border-radius:18px;
    background:linear-gradient(180deg,#fff,#f8f9fa);
    transition:.25s
}
.mobile-detail-card:hover{
    transform:translateY(-3px);
    box-shadow:0 10px 25px rgba(0,0,0,.12)
}

/* ===== CARD JUDUL LAPORAN ===== */
.report-title-card{
    border-radius:20px;
    background:linear-gradient(135deg,#0d6efd,#0dcaf0);
    color:#fff;
    padding:24px 28px;
    box-shadow:0 12px 30px rgba(13,110,253,.25);
}
.report-title-card h3{
    font-weight:700;
    margin:0;
}
.report-title-sub{
    font-size:14px;
    opacity:.9;
}
.report-icon{
    width:52px;
    height:52px;
    border-radius:14px;
    background:rgba(255,255,255,.2);
    display:flex;
    align-items:center;
    justify-content:center;
    font-size:26px;
}
</style>

<div class="content py-4" style="min-height:100vh;background:#f8f9fa">
<div class="container-fluid">

<!-- ===== CARD JUDUL LAPORAN ===== -->
<div class="card mb-4 border-0 report-title-card">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
        <div class="d-flex align-items-center gap-3">
            <div class="report-icon">📊</div>
            <div>
                <h3><?= esc($title) ?></h3>
                <div class="report-title-sub">
                    Detail Kehadiran Siswa • <?= date('F Y', strtotime($bulan.'-01')) ?>
                </div>
            </div>
        </div>
        <div class="text-end">
            <div class="fw-semibold"><?= esc($namaSiswa ?? '') ?></div>
            <small class="opacity-75">
                Kelas <?= esc($namaKelas ?? $selectedKelas) ?>
            </small>
        </div>
    </div>
</div>
<!-- ===== END CARD JUDUL ===== -->

<div class="card shadow-sm mb-4 detail-card">
<div class="card-header detail-header">
    <h4 class="mb-0"><?= esc($title) ?></h4>
</div>

<div class="card-body">

<div class="mb-4 d-flex justify-content-between flex-wrap gap-2">
    <a href="<?= base_url('admin/kehadiran/rekapbulanan?kelas='.$selectedKelas.'&bulan='.$bulan) ?>"
       class="btn text-white"
       style="background:linear-gradient(135deg,#6c757d,#495057);border:none">
       ⬅ Kembali
    </a>


    <a href="<?= base_url('admin/kehadiran/exportCSVDetail?idSiswa='.$idSiswa.'&bulan='.$bulan) ?>"
   class="btn btn-success">⬇ Export CSV</a>

    <!-- <a href="<?= base_url('admin/kehadiran/exportCSVDetail2?idSiswa='.$idSiswa.'&bulan='.$bulan) ?>"
       class="btn btn-success">⬇ Export CSV</a> -->
</div>

<!-- ================= DESKTOP ================= -->
<div class="table-responsive d-none d-md-block">
<table class="table table-hover align-middle text-center">
<thead class="table-light">
<tr>
    <th>No</th>
    <th>Tanggal</th>
    <th>Status</th>
    <th>Jam Masuk</th>
    <th>Jam Sholat</th>
    <th>Jam Keluar</th>
</tr>
</thead>
<tbody>

<?php $no=1; foreach($detail as $row): ?>

<?php
$statusClass = match($row['status']) {
    'Hadir'=>'success','Sakit'=>'info','Izin'=>'primary',default=>'danger'
};

$jamMasuk  = $row['status']=='Hadir'
    ? ambilJam($row, ['jam_masuk','jam_masuk_absen','jam_datang'])
    : '-';

$jamKeluar = $row['status']=='Hadir'
    ? ambilJam($row, ['jam_keluar','jam_keluar_absen','jam_pulang'])
    : '-';

$telat = isTelat($row['status'], $jamMasuk);
?>

<tr>
    <td><?= $no++ ?></td>
    <td class="fw-semibold"><?= formatTanggalHari($row['tanggal']) ?></td>
    <td><span class="badge bg-<?= $statusClass ?> badge-status"><?= $row['status'] ?></span></td>
    <td>
        <?= $jamMasuk ?>
        <?php if($telat): ?><span class="badge bg-danger ms-1">Telat</span><?php endif ?>
    </td>
    <td><?= $row['jam_sholat'] ?? '-' ?></td>
    <td><?= jamKeluarDenganTap($row['status'], $jamMasuk, $jamKeluar) ?></td>
</tr>

<?php endforeach ?>
</tbody>
</table>
</div>

<!-- ================= MOBILE ================= -->
<div class="d-block d-md-none">
<?php foreach($detail as $row): ?>

<?php
$statusClass = match($row['status']) {
    'Hadir'=>'success','Sakit'=>'info','Izin'=>'primary',default=>'danger'
};

$jamMasuk  = $row['status']=='Hadir'
    ? ambilJam($row, ['jam_masuk','jam_masuk_absen','jam_datang'])
    : '-';

$jamKeluar = $row['status']=='Hadir'
    ? ambilJam($row, ['jam_keluar','jam_keluar_absen','jam_pulang'])
    : '-';

$telat = isTelat($row['status'], $jamMasuk);
?>

<div class="card mb-3 border-0 shadow-sm mobile-detail-card">
<div class="card-body">

<div class="d-flex justify-content-between mb-2">
    <strong>Tanggal</strong>
    <span><?= formatTanggalHari($row['tanggal']) ?></span>
</div>

<div class="d-flex justify-content-between mb-2">
    <strong>Status</strong>
    <span class="badge bg-<?= $statusClass ?> badge-status"><?= $row['status'] ?></span>
</div>

<div class="d-flex justify-content-between mb-2">
    <strong>Jam Masuk</strong>
    <span>
        <?= $jamMasuk ?>
        <?php if($telat): ?><span class="badge bg-danger ms-1">Telat</span><?php endif ?>
    </span>
</div>

<div class="d-flex justify-content-between mb-2">
    <strong>Jam Sholat</strong>
    <span><?= $row['jam_sholat'] ?? '-' ?></span>
</div>

<div class="d-flex justify-content-between">
    <strong>Jam Keluar</strong>
    <span><?= jamKeluarDenganTap($row['status'], $jamMasuk, $jamKeluar) ?></span>
</div>

</div>
</div>

<?php endforeach ?>
</div>

</div>
</div>

</div>
</div>

<?= $this->endSection() ?>
