<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ===== GLOBAL ===== */
.table thead th {
    vertical-align: middle;
    font-size: 14px;
    text-align: center;
    background: linear-gradient(135deg,#0d6efd,#0dcaf0);
    color: #fff;
}
.table tbody td {
    vertical-align: middle;
    font-size: 14px;
}
.table tbody tr:hover {
    background: #e3f2fd;
    transition: background 0.2s ease;
}

/* ===== CARD HEADER ===== */
.header-card {
    border-radius: 18px;
    background: linear-gradient(135deg,#0d6efd,#0dcaf0);
    color: white;
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}
.header-card i {
    font-size: 28px;
}

/* ===== FILTER AREA ===== */
.filter-card {
    border-radius: 18px;
    background: #f8f9fa;
    padding: 15px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    margin-top: 15px;
}

/* ===== MOBILE CARD ===== */
.mobile-card {
    border-radius: 16px;
    transition: all .25s ease;
    color: white;
}
.mobile-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0,0,0,.12);
}
</style>

<?php
// =======================
// Cari nama kelas dari $kelasList
// =======================
$kelasName = '-';
if($selectedKelas) {
    foreach($kelasList as $kelas){
        if($kelas['id_kelas'] == $selectedKelas){
            $kelasName = $kelas['kelas'];
            break;
        }
    }
}
?>

<div class="content">
<div class="container-fluid">

<!-- ===== BARIS 1: HEADER JUDUL ===== -->
<div class="header-card mb-4">
    <i class="material-icons">event_note</i>
    <h4 class="mb-0 fw-bold">LAPORAN KEHADIRAN BULANAN SISWA</h4>
</div>

<!-- ===== BARIS 2: FILTER AREA ===== -->
<div class="filter-card">
    <div class="row">
        <!-- Kolom 1: Info Kelas dan Bulan -->
        <div class="col-md-6 mb-2">
            <div class="fw-bold">Kelas: <?= esc($kelasName) ?> | Bulan: <?= $bulan ?></div>
        </div>

        <!-- Kolom 2: Dropdown Filter + Buttons -->
        <div class="col-md-6">
            <div class="row">
                <!-- Baris 1: Dropdown Kelas & Bulan dengan Auto-Submit -->
                <div class="col-12 mb-2">
                    <form method="get" id="filterForm" class="row g-2">
                        <div class="col-6">
                            <select name="kelas" class="form-select" required onchange="document.getElementById('filterForm').submit()">
                                <option value="">-- Pilih Kelas --</option>
                                <?php foreach($kelasList as $kelas): ?>
                                    <option value="<?= $kelas['id_kelas'] ?>" <?= $selectedKelas == $kelas['id_kelas'] ? 'selected' : '' ?>>
                                        <?= $kelas['kelas'] ?>
                                    </option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <div class="col-6">
                            <input type="month" name="bulan" class="form-control" value="<?= $bulan ?>" required onchange="document.getElementById('filterForm').submit()">
                        </div>
                    </form>
                </div>

                <!-- Baris 2: Buttons Reset, Menu, Export -->
                <div class="col-12 d-flex gap-2">
                    <a href="<?= base_url('admin/kehadiran/rekapbulanan') ?>" class="btn btn-secondary flex-fill">Reset</a>
                    <a href="<?= base_url('admin/menurekap') ?>" class="btn flex-fill" style="background-color: #154683; color: white;">Menu</a>
                    <?php if($selectedKelas): ?>
                        <a href="<?= base_url('admin/kehadiran/rekapbulanan/exportCSV') ?>?kelas=<?= $selectedKelas ?>&bulan=<?= $bulan ?>" class="btn btn-success flex-fill">Export CSV</a>
                    <?php endif ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ===== BARIS 3: DESKTOP TABLE ===== -->
<div class="table-responsive d-none d-md-block mt-4">
<table class="table table-hover align-middle">
<thead>
<tr>
    <th>No</th>
    <th>Nama Siswa</th>
    <th>Hadir</th>
    <th>Sakit</th>
    <th>Izin</th>
    <th>Alpa</th>
    <th>Tidak Sholat</th>
</tr>
</thead>
<tbody>
<?php $no=1; foreach($laporan as $row): ?>
<tr style="cursor:pointer;" onclick="window.location='<?= site_url('admin/kehadiran/detail/'.$row['id_siswa']) ?>?kelas=<?= $selectedKelas ?>&bulan=<?= $bulan ?>';">
    <td class="text-center"><?= $no++ ?></td>
    <td><strong><?= esc($row['nama_siswa']) ?></strong></td>
    <td class="text-center"><span class="badge bg-success"><?= $row['hadir'] ?? 0 ?></span></td>
    <td class="text-center"><span class="badge bg-info"><?= $row['sakit'] ?? 0 ?></span></td>
    <td class="text-center"><span class="badge bg-primary"><?= $row['izin'] ?? 0 ?></span></td>
    <td class="text-center"><span class="badge bg-danger"><?= $row['alpha'] ?? 0 ?></span></td>
    <td class="text-center"><span class="badge bg-warning text-dark"><?= $row['TidakSholat'] ?? 0 ?></span></td>
</tr>
<?php endforeach ?>
</tbody>
</table>
</div>

<!-- ===== BARIS 3: MOBILE CARD TERINTEGRASI ===== -->
<div class="d-block d-md-none mt-3">
<?php foreach($laporan as $row): ?>
<a href="<?= site_url('admin/kehadiran/detail/'.$row['id_siswa']) ?>?kelas=<?= $selectedKelas ?>&bulan=<?= $bulan ?>" class="text-decoration-none text-dark">
<div class="card mb-3 border-3 shadow-sm mobile-card" style="background: linear-gradient(135deg, #f8931f, #8a2be2); color: white; border-radius: 16px;">
<div class="card-body">

    <!-- Baris 1: Nama Siswa -->
    <div class="mb-3">
        <h5 class="fw-bold mb-0"><?= esc($row['nama_siswa']) ?></h5>
    </div>

    <!-- Baris 2: 3 Kolom Label | Pemisah | Data -->
    <div class="row mb-2">
        <div class="col-4 fw-bold text-start">
            Hadir<br>
            Sakit<br>
            Izin<br>
            Alpa<br>
            Tidak Sholat
        </div>
        <div class="col-1 text-start">
            :<br>:<br>:<br>:<br>:
        </div>
        <div class="col-7 text-start">
            <?= $row['hadir'] ?? 0 ?><br>
            <?= $row['sakit'] ?? 0 ?><br>
            <?= $row['izin'] ?? 0 ?><br>
            <?= $row['alpha'] ?? 0 ?><br>
            <?= $row['TidakSholat'] ?? 0 ?>
        </div>
    </div>

    <!-- Baris 3: Highlight dengan teks di tengah -->
    <div class="p-2 mt-2 d-flex justify-content-center align-items-center" 
         style="background-color: #D1E7DD; border-radius: 8px; color: #000; height: 40px;">
        <strong>Klik Untuk Melihat Detail Siswa</strong>
    </div>

</div>
</div>
</a>
<?php endforeach ?>
</div>

</div>
</div>

<?= $this->endSection() ?>
