<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>


<?php
// ==========================
// 1️⃣ HELPER FUNCTIONS BADGE
// ==========================
            function badgeJamMasuk($jam)
            {
                if (!$jam) return '<span class="badge bg-secondary">-</span>';
                if ($jam <= '07:00') return '<span class="badge badge-masuk bg-success">Tepat</span>';
                elseif ($jam <= '07:15') return '<span class="badge badge-masuk bg-warning text-dark">Telat</span>';
                else return '<span class="badge badge-masuk bg-danger">Telat Berat</span>';
            }

            function badgeSholat($jam)
            {
                return $jam
                    ? '<span class="badge badge-sholat bg-success">✔ Sholat</span>'
                    : '<span class="badge badge-sholat bg-danger">✖ Tidak</span>';
            }

            function badgeKeluar($jamKeluar, $status)
            {
                if ($jamKeluar) return '<span class="badge badge-keluar bg-info text-white">' . esc($jamKeluar) . '</span>';
                return ($status === 'Hadir') 
                    ? '<span class="badge badge-keluar bg-danger text-white">TAP</span>'
                    : '<span class="badge badge-keluar bg-secondary text-white">-</span>';
            }

            function badgeKehadiran($status)
            {
                switch($status){
                    case 'Hadir': return '<span class="badge badge-hadir w-100">Hadir</span>';
                    case 'Sakit': return '<span class="badge badge-sakit w-100">Sakit</span>';
                    case 'Izin':  return '<span class="badge badge-izin w-100">Izin</span>';
                    case 'Telat': return '<span class="badge badge-telat w-100">Telat</span>';
                    case 'Telat Berat': return '<span class="badge badge-telat w-100">Telat Berat</span>';
                    default: return '<span class="badge badge-alpha w-100">Alpha</span>';
                }
            }
            ?>

<!-- =========================================
2️⃣ STYLE BADGE, TABLE, CARD, LEGEND
========================================= -->
            <style>
            /* ===== FOTO SISWA ===== */
            .foto-siswa { width:55px; height:55px; object-fit:cover; border-radius:50%; border:2px solid #ddd; }

            /* ===== LEGEND PRESENSI ===== */
            .legend-presensi { display:flex; gap:12px; flex-wrap:wrap; margin-bottom:15px; font-size:13px; }
            .legend-item { display:flex; align-items:center; gap:6px; padding:5px 10px; border-radius:20px; font-weight:500; }
            .legend-dot { width:12px; height:12px; border-radius:50%; }
            .legend-hadir{background:#e9f7ef;} .legend-sakit{background:#fff8e1;} .legend-izin{background:#e7f5ff;} .legend-alpha{background:#fdecea;}
            .legend-hadir .legend-dot{background:#28a745;} .legend-sakit .legend-dot{background:#ffc107;} 
            .legend-izin  .legend-dot{background:#0dcaf0;} .legend-alpha .legend-dot{background:#dc3545;}

            /* ===== BADGE GLOBAL ===== */
            .badge-hadir { background-color: #28a745; color: #fff; }
            .badge-sakit { background-color: #0d6efd; color: #fff; }
            .badge-izin  { background-color: #ffc107; color: #000; }
            .badge-telat { background-color: #fd7e14; color: #fff; }
            .badge-telat-berat { background-color: #dc3545; color: #fff; }
            .badge-alpha { background-color: #fa4a1a; color: #fff; }
            .badge-masuk, .badge-sholat, .badge-keluar { box-shadow:0 1px 4px rgba(0,0,0,0.15); }

            /* ===== DESKTOP TABLE ===== */
            @media (min-width: 769px) {
                .table-view { display: block; }
                .card-view { display: none; }

                .table-view thead th {
                    background: linear-gradient(135deg, #0dcaf0, #0d6efd);
                    color: #fff;
                    text-align: center;
                    font-weight: 600;
                    border: 1px solid #fff;
                }
            }

            /* ===== MOBILE CARD ===== */
            @media (max-width: 768px) {
                .table-view{display:none;}
                .presensi-card{
                    border-radius:15px; box-shadow:0 6px 15px rgba(0,0,0,.1); margin-bottom:15px;
                    overflow:hidden; border-left:6px solid #ccc; transition: transform 0.3s, box-shadow 0.3s;
                }
                .card-hadir{border-left-color:#28a745;} .card-sakit{border-left-color:#ffc107;}
                .card-izin{border-left-color:#0dcaf0;} .card-alpha{border-left-color:#dc3545;}
                .presensi-card .card-header{background:linear-gradient(135deg,#1e3c72,#2a5298); color:#fff; font-size:14px; font-weight:bold;}
                .presensi-card:hover{ transform: translateY(-3px); box-shadow:0 12px 25px rgba(0,0,0,.15);}
                .presensi-card .badge{ font-size:0.78rem; padding:0.35em 0.6em; border-radius:12px; }
            }

            /* HIDE FOTO SAAT PRINT */
            @media print{ img{display:none!important;} }
            </style>

            <div class="content py-4" style="min-height:100vh;background:#f8f9fa">
            <div class="container-fluid">

<!-- ===========================
1️⃣ AWAL HALAMAN
=========================== -->
            <div class="card mb-4">
                <div class="card-header card-header-info">
                    <h4 class="card-title text-center"><strong>LAPORAN KEHADIRAN HARIAN SISWA</strong></h4>
                </div>
                <div class="card-body">
                    <form method="get" class="row g-3">
                        <div class="col-12 col-md-3">
                            <label class="fw-bold">Kelas</label>
                            <select name="kelas" class="form-select" required>
                                <option value="">-- Pilih Kelas --</option>
                                <?php foreach($kelasList as $kelas): ?>
                                    <option value="<?= $kelas['id_kelas'] ?>" <?= $selectedKelas == $kelas['id_kelas'] ? 'selected' : '' ?>>
                                        <?= $kelas['kelas'] ?>
                                    </option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <div class="col-12 col-md-3">
                            <label class="fw-bold">Tanggal</label>
                            <input type="date" name="tanggal" class="form-control" value="<?= $tanggal ?>" required>
                        </div>
                        <div class="col-12 col-md-6 d-grid d-md-flex gap-2 align-items-end">
                            <button class="btn btn-primary flex-fill">Filter</button>
                            <a href="<?= base_url('admin/kehadiran/rekapharian') ?>" class="btn btn-secondary flex-fill">Reset</a>
                            <?php if(!empty($selectedKelas)): ?>
                                <a href="<?= base_url('admin/kehadiran/exportCSV') ?>?kelas=<?= $selectedKelas ?>&tanggal=<?= $tanggal ?>" class="btn btn-success flex-fill">Export CSV</a>
                            <?php endif ?>
                        </div>
                    </form>
                </div>
            </div>

<!-- ===========================
2️⃣ DESKTOP TABLE
=========================== -->
            <div class="table-view table-responsive mb-4">
            <table class="table table-bordered table-striped align-middle">
            <thead class="table-light text-center">
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>JK</th>
                <th>Kelas</th>
                <th>Masuk</th>
                <th>Duhur</th>
                <th>Keluar</th>
                <th>Status</th>
            </tr>
            </thead>
            <tbody>
            <?php if($laporan): $no=1; foreach($laporan as $row): ?>
            <tr>
                <td class="text-center"><?= $no++ ?></td>
                <td><?= esc($row['nama_siswa']) ?></td>
                <td class="text-center"><?= esc($row['jenis_kelamin'] ?? '-') ?></td>
                <td class="text-center"><?= esc($row['kelas']) ?></td>
                <td class="text-center"><?= esc($row['jam_masuk'] ?? '-') ?><br><?= badgeJamMasuk($row['jam_masuk'] ?? null) ?></td>
                <td class="text-center"><?= badgeSholat($row['jam_sholat'] ?? null) ?></td>
                <td class="text-center"><?= badgeKeluar($row['jam_keluar'] ?? null, $row['kehadiran'] ?? null) ?></td>
                <td class="text-center"><?= badgeKehadiran($row['kehadiran'] ?? null) ?></td>
            </tr>
            <?php endforeach; else: ?>
            <tr><td colspan="8" class="text-center text-muted">Data tidak tersedia</td></tr>
            <?php endif ?>
            </tbody>
            </table>
            </div>




<!-- ===========================
3️⃣ MOBILE CARD + LEGEND
=========================== -->
        <div class="card-view d-md-none">
            <!-- LEGEND -->
            <div class="legend-presensi mb-3">
                <div class="legend-item legend-hadir"><span class="legend-dot"></span> Hadir</div>
                <div class="legend-item legend-sakit"><span class="legend-dot"></span> Sakit</div>
                <div class="legend-item legend-izin"><span class="legend-dot"></span> Izin</div>
                <div class="legend-item legend-alpha"><span class="legend-dot"></span> Alpha</div>
            </div>

            <?php if($laporan): foreach($laporan as $row): ?>
                <?php
                    $status = strtolower($row['kehadiran'] ?? 'alpha');
                    $cardClass = match($status){
                        'hadir' => 'card-hadir',
                        'sakit' => 'card-sakit',
                        'izin'  => 'card-izin',
                        default => 'card-alpha'
                    };
                    $foto = !empty($row['photo']) ? base_url('uploads/siswa/'.$row['photo']) : base_url('uploads/default.png');
                ?>
                <div class="card presensi-card <?= $cardClass ?>">
                    <div class="card-header"><?= esc($row['nama_siswa']) ?> • <?= esc($row['kelas']) ?></div>
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-2">
                            <img src="<?= $foto ?>" class="foto-siswa me-4">
                            <div>
                                <div class="fw-bold"><?= esc($row['nama_siswa']) ?></div>
                                <small><?= esc($row['nis'] ?? '-') ?> | <?= esc($row['jenis_kelamin'] ?? '-') ?></small>
                            </div>
                        </div>
                        <div class="row g-2 text-center mb-2">
                            <div class="col"><b>Jam Masuk</b><br><?= esc($row['jam_masuk'] ?? '-') ?><br><?= badgeJamMasuk($row['jam_masuk'] ?? null) ?></div>
                            <div class="col"><b>Jam Sholat</b><br><?= badgeSholat($row['jam_sholat'] ?? null) ?></div>
                            <div class="col"><b>Jam Pulang</b><br><?= badgeKeluar($row['jam_keluar'] ?? null, $row['kehadiran'] ?? null) ?></div>
                        </div>
                        <div class="text-center mt-2"><?= badgeKehadiran($row['kehadiran'] ?? null) ?></div>
                        <div class="text-center"><b>Keterangan</b> <?= esc($row['keterangan'] ?? '') ?></div>
                    </div>
                </div>
            <?php endforeach; else: ?>
                <div class="text-center text-muted py-4">Data tidak tersedia</div>
            <?php endif; ?>
        </div>



<!-- ===========================
1️⃣ AKHIR HALAMAN
=========================== -->
            <div class="card mb-4">
                <div class="card-header card-header-info">
                    <h4 class="card-title text-center"><strong>LAPORAN KEHADIRAN HARIAN SISWA</strong></h4>
                </div>
                <div class="card-body">
                    
                </div>
            </div>


        </div>
        </div>

        <?= $this->endSection() ?>