<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ================= TABLE MATRIX ================= */
.table-matrix{font-size:.7rem}
.table-matrix th,.table-matrix td{padding:4px;text-align:center;min-width:32px}
.table-matrix thead th{background:#0d6efd;color:#fff;position:sticky;top:0;z-index:3}

/* ================= STICKY COL ================= */
.nama-col{position:sticky;left:0;background:#fff;min-width:140px;text-align:left!important;z-index:5;padding-left:8px}
.kelas-col{position:sticky;left:140px;background:#f8f9fa;min-width:90px;font-size:.75rem;z-index:4}

/* ================= STATUS CELL ================= */
.cell-hadir{background:#198754;color:#fff;font-weight:600}
.cell-terlambat{background:#ffc107;color:#000;font-weight:600}
.cell-sakit{background:#0dcaf0;color:#000;font-weight:600}
.cell-ijin{background:#6f42c1;color:#fff;font-weight:600}
.cell-alpa{background:#dc3545;color:#fff;font-weight:600}
.cell-libur{background:#ffeeba;color:#856404;font-weight:700}
.cell-empty{background:#f8f9fa;color:#adb5bd}

/* ================= MOBILE ================= */
.mobile-card{border-radius:.75rem}
.mobile-card .hari{width:36px;text-align:center;font-size:.7rem;border-radius:.4rem}
.mobile-card .hadir{background:#198754;color:#fff}
.mobile-card .terlambat{background:#ffc107;color:#000}
.mobile-card .sakit{background:#0dcaf0;color:#000}
.mobile-card .ijin{background:#6f42c1;color:#fff}
.mobile-card .alpa{background:#dc3545;color:#fff}
.mobile-card .libur{background:#ffeeba;color:#856404}
.mobile-card .kosong{background:#f8f9fa;color:#adb5bd}



/* ================= HIGHLIGHT PERSENTASE ================= */
.row-tertinggi{background:#e6fffa}
.row-terendah{background:#ffe6e6}

.badge-tertinggi{background:#20c997}
.badge-terendah{background:#dc3545}





.progress{height:6px}
@media(max-width:576px){.nama-col{min-width:120px;font-size:.75rem}}
</style>

<?php
/* ================= HELPER ================= */
function isWeekend($tanggal){
    // 6 = Sabtu, 7 = Minggu
    return date('N', strtotime($tanggal)) >= 6;
}
?>



<?php
/* ================= HITUNG MAX & MIN PERSEN ================= */
$persentaseSiswa = [];

foreach($siswa as $s){
    $hariEfektif = 0;
    $hadir = 0;

    for($d=1;$d<=$days;$d++){
        $tanggal = $bulan.'-'.str_pad($d,2,'0',STR_PAD_LEFT);

        if(in_array($tanggal,$hariLibur) || isWeekend($tanggal)){
            continue;
        }

        $hariEfektif++;

        if(($matrix[$s['id_siswa']][$d]['id_kehadiran'] ?? '')==='1'){
            $hadir++;
        }
    }

    $persen = $hariEfektif > 0 ? round(($hadir/$hariEfektif)*100) : 0;
    $persentaseSiswa[$s['id_siswa']] = $persen;
}

$maxPersen = !empty($persentaseSiswa) ? max($persentaseSiswa) : 0;
$minPersen = !empty($persentaseSiswa) ? min($persentaseSiswa) : 0;
?>

<div class="content py-3">
<div class="container-fluid">

<!-- ================= HEADER ================= -->
<div class="card shadow-sm mb-3">
    <div class="card-body py-2">
        <h6 class="fw-bold mb-0">
            <i class="material-icons fs-6">event_available</i>
            Laporan Hadir Bulanan
        </h6>
        <small class="text-muted"><?= date('F Y', strtotime($bulan)) ?></small>
    </div>
</div>

<!-- ================= FILTER ================= -->
<div class="card shadow-sm mb-3">
<div class="card-body">
<form method="get" class="row g-2">
    <div class="col-12">
        <label class="form-label mb-1">Kelas</label>
        <select name="kelas" class="form-select form-select-sm">
            <option value="all">Semua Kelas</option>
            <?php foreach($kelasList as $k): ?>
                <option value="<?= $k['id_kelas'] ?>" <?= $selectedKelas==$k['id_kelas']?'selected':'' ?>>
                    <?= esc($k['kelas']) ?>
                </option>
            <?php endforeach ?>
        </select>
    </div>

    <div class="col-12">
        <label class="form-label mb-1">Bulan</label>
        <input type="month" name="bulan" value="<?= $bulan ?>" class="form-control form-control-sm">
    </div>

<div class="col-12 d-grid">
    <button class="btn btn-primary btn-sm w-100"
            style="background-color: #ff1111; color:white;">
        <i class="material-icons fs-6 align-middle">search</i>
        <span class="ms-1">Tampilkan</span>
    </button>        
</div>

<div class="col-12 d-grid">
    <a href="<?= base_url('admin/menurekap') ?>" 
       class="btn btn-primary btn-sm w-100"
       style="background-color: #154683; color:white;">
        <i class="material-icons fs-6 align-middle">menu</i>
        <span class="ms-1">Menu</span>
    </a>
</div>



</form>
</div>
</div>


























<!-- ================= DESKTOP TABLE ================= -->
<div class="card shadow-sm d-none d-md-block">
<div class="card-body table-responsive" style="max-height:75vh;overflow:auto">
<table class="table table-bordered table-matrix">
<thead>



<tr class="
<?= $persen==$maxPersen ? 'row-tertinggi' : '' ?>
<?= $persen==$minPersen ? 'row-terendah' : '' ?>
">

<!-- <tr> -->
    <th class="nama-col">Nama</th>
    <th class="kelas-col">Kelas</th>
    <th>%</th>
    <?php for($d=1;$d<=$days;$d++): ?>
        <th><?= $d ?></th>
    <?php endfor ?>
</tr>
</thead>
<tbody>

<?php foreach($siswa as $s): ?>
<?php
// $hadir=0;
// for($d=1;$d<=$days;$d++){
//     if(($matrix[$s['id_siswa']][$d]['id_kehadiran'] ?? '')==='1'){
//         $hadir++;
//     }
// }
// // $persen = round(($hadir/$days)*100);

$hariEfektif = 0;
$hadir = 0;

for($d=1;$d<=$days;$d++){
    $tanggal = $bulan.'-'.str_pad($d,2,'0',STR_PAD_LEFT);

    if(in_array($tanggal,$hariLibur) || isWeekend($tanggal)){
        continue;
    }

    $hariEfektif++;

    if(($matrix[$s['id_siswa']][$d]['id_kehadiran'] ?? '')==='1'){
        $hadir++;
    }
}

$persen = $hariEfektif > 0 ? round(($hadir/$hariEfektif)*100) : 0;













?>
<tr>
<td class="nama-col"><strong><?= esc($s['nama_siswa']) ?></strong></td>
<td class="kelas-col"><?= esc($s['nama_kelas'] ?? '-') ?></td>
<!-- <td><strong><?= $persen ?>%</strong></td> -->

<td>
<strong><?= $persen ?>%</strong>
<?php if($persen==$maxPersen): ?>
    <span class="badge badge-tertinggi ms-1">▲</span>
<?php elseif($persen==$minPersen): ?>
    <span class="badge badge-terendah ms-1">▼</span>
<?php endif ?>
</td>






<?php for($d=1;$d<=$days;$d++): ?>
<?php
$tanggal = $bulan.'-'.str_pad($d,2,'0',STR_PAD_LEFT);
$p = $matrix[$s['id_siswa']][$d] ?? null;

/* ✅ LIBUR: DB ATAU SABTU-MINGGU */
if(in_array($tanggal,$hariLibur) || isWeekend($tanggal)){
    echo '<td class="cell-libur">L</td>'; continue;
}

/* ALPA */
if(!$p || empty($p['id_kehadiran'])){
    echo '<td class="cell-alpa">A</td>'; continue;
}

switch($p['id_kehadiran']){
    case '1':
        $jam=$p['jam_masuk']??'';
        $late=$jam && $jam>'07:00:00';
        echo '<td class="'.($late?'cell-terlambat':'cell-hadir').'">'.substr($jam,0,5).'</td>';
        break;
    case '2': echo '<td class="cell-sakit">S</td>'; break;
    case '3': echo '<td class="cell-ijin">I</td>'; break;
    case '4': echo '<td class="cell-alpa">A</td>'; break;
}
?>
<?php endfor ?>
</tr>
<?php endforeach ?>

</tbody>
</table>
</div>
</div>

<!-- ================= MOBILE CARD ================= -->
<div class="d-block d-md-none mt-3">
<?php foreach($siswa as $s): ?>
<?php




// $hadir=0;
// for($d=1;$d<=$days;$d++){
//     if(($matrix[$s['id_siswa']][$d]['id_kehadiran'] ?? '')==='1') $hadir++;
// }
// $persen=round(($hadir/$days)*100);


$hariEfektif = 0;
$hadir = 0;

for($d=1;$d<=$days;$d++){
    $tanggal = $bulan.'-'.str_pad($d,2,'0',STR_PAD_LEFT);

    if(in_array($tanggal,$hariLibur) || isWeekend($tanggal)){
        continue;
    }

    $hariEfektif++;

    if(($matrix[$s['id_siswa']][$d]['id_kehadiran'] ?? '')==='1'){
        $hadir++;
    }
}

$persen = $hariEfektif > 0 ? round(($hadir/$hariEfektif)*100) : 0;















?>
<!-- <div class="card mobile-card shadow-sm mb-3"> -->

<div class="card mobile-card shadow-sm mb-3
<?= $persen==$maxPersen?'border border-success':'' ?>
<?= $persen==$minPersen?'border border-danger':'' ?>
">





<div class="card-body p-2">

<div class="mb-2">
<div class="d-flex justify-content-between">
<div>
<strong><?= esc($s['nama_siswa']) ?></strong><br>
<small class="text-muted"><?= esc($s['nama_kelas'] ?? '-') ?></small>
</div>
<!-- <span class="badge bg-primary"><?= $persen ?>%</span> -->

<span class="badge
<?= $persen==$maxPersen?'badge-tertinggi':'' ?>
<?= $persen==$minPersen?'badge-terendah':'bg-primary' ?>
">
<?= $persen ?>%
<?= $persen==$maxPersen?' ▲':'' ?>
<?= $persen==$minPersen?' ▼':'' ?>
</span>








</div>
<div class="progress mt-1">
<div class="progress-bar bg-success" style="width:<?= $persen ?>%"></div>
</div>
</div>

<div class="d-flex flex-wrap gap-1">
<?php for($d=1;$d<=$days;$d++): ?>
<?php
$tanggal=$bulan.'-'.str_pad($d,2,'0',STR_PAD_LEFT);
$p=$matrix[$s['id_siswa']][$d]??null;

$class='alpa'; $text='A';

if(in_array($tanggal,$hariLibur) || isWeekend($tanggal)){
    $class='libur'; $text='L';
}elseif($p && !empty($p['id_kehadiran'])){
    switch($p['id_kehadiran']){
        case '1':
            $jam=$p['jam_masuk']??'';
            $class=($jam && $jam>'07:00:00')?'terlambat':'hadir';
            $text=substr($jam,0,5); break;
        case '2': $class='sakit'; $text='S'; break;
        case '3': $class='ijin';  $text='I'; break;
        case '4': $class='alpa';  $text='A'; break;
    }
}
?>
<div class="hari <?= $class ?>">
    <div class="fw-bold"><?= $d ?></div>
    <div><?= $text ?></div>
</div>
<?php endfor ?>
</div>

</div>
</div>
<?php endforeach ?>
</div>

</div>
</div>

<?= $this->endSection() ?>
