<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<!-- //✅✅ Style -->
<style>
.card { border-radius:1rem; transition:.4s; box-shadow:0 6px 10px #000; cursor:pointer; }
.card:hover { transform:translateY(-1px); box-shadow:0 10px 10px rgba(0,0,0,.3); }
.card-icon i { font-size:3rem; transition:.4s; }
.card:hover .card-icon i { transform:scale(1.5) rotate(10deg); }
.card-glass { background:linear-gradient(135deg,#162f38,#472761); color:#fff; border-radius:1rem; border:none; }
.table thead.custom-header { background:#0d6efd; color:#fff; text-align:center; }
.card-header-solid { background:#0d6efd; color:#fff; }
.mobile-rekap-card { border-radius:12px; overflow:hidden; border:1px solid #dee2e6; }
.mobile-rekap-card .card-header { font-weight:600; font-size:.9rem; background:#0d6efd; color:#fff; }
.mobile-rekap-card .avatar img { width:50px; height:50px; border-radius:50%; object-fit:cover; border:2px solid #fff; }
.mobile-rekap-card .info small { font-size:.75rem; color:#6c757d; }
.mobile-rekap-card .status-bar { text-align:center; color:#fff; font-weight:600; padding:6px 0; border-radius:4px; }
</style>

<div class="content py-4" style="min-height:100vh;background:#4b88c5">
<div class="container-fluid mb-4">
<div class="card shadow-sm mb-4">

<div class="card-body border-bottom">
<h4 class="fw-bold mb-0">
<i class="material-icons align-middle">dashboard</i>
<?= esc($title ?? 'Laporan Presensi') ?>
</h4>
</div>

<div class="card-body">
<h4 class="fw-bold mb-0">Data Kehadiran Siswa</h4>
<div class="text-muted">
<?= esc($siswa['nama_siswa']) ?> • <?= esc($siswa['kelas']) ?> • <?= esc($siswa['nis']) ?>
</div>
</div>

<div class="card-body">
<form method="get" class="row g-3 align-items-end">
<div class="col-md-4">
<label class="fw-bold">Tanggal Awal</label>
<input type="date" name="awal" value="<?= $awal ?>" class="form-control">
</div>
<div class="col-md-4">
<label class="fw-bold">Tanggal Akhir</label>
<input type="date" name="akhir" value="<?= $akhir ?>" class="form-control">
</div>
<div class="col-md-4 d-flex gap-2">
<button class="btn btn-primary flex-fill">Filter</button>

<?php if (!empty($awal) && !empty($akhir)): ?>
<a href="<?= base_url(
'admin/lap/lapharian/exportSiswaCSVDetail'
.'?id_siswa='.$siswa['id_siswa']
.'&awal='.$awal
.'&akhir='.$akhir
) ?>" class="btn btn-success">
Export CSV
</a>
<?php endif; ?>

<a href="<?= $back_url ?>" class="btn btn-secondary flex-fill">Kembali</a>
</div>
</form>
</div>

<?php
function tanggal_indo($tanggal)
{
$hari = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
$bulan = [1=>'Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
$time = strtotime($tanggal);
return $hari[date('w',$time)].', '.date('d',$time).' '.$bulan[(int)date('m',$time)].' '.date('Y',$time);
}
?>

<div class="card-body table-responsive">
<table class="table table-bordered table-striped table-hover align-middle text-center mb-0">
<thead class="table-primary">
<tr>
<th>No</th>
<th>Tanggal</th>
<th>Jam Masuk</th>
<th>Jam Sholat</th>
<th>Jam Pulang</th>
<th>Status</th>
</tr>
</thead>

<tbody>
<?php if($presensi): $no=1; foreach($presensi as $p): ?>
<?php
$statusText = match($p['id_kehadiran']) {
'1'=>'Hadir','2'=>'Sakit','3'=>'Izin',default=>'Alpa'
};
$statusBadge = match($p['id_kehadiran']) {
'1'=>'bg-success','2'=>'bg-warning','3'=>'bg-info',default=>'bg-danger'
};
?>
<tr>
<td data-label="No"><?= $no++ ?></td>

<td data-label="Tanggal" class="text-start">
<?= tanggal_indo($p['tanggal']) ?>
</td>

<td data-label="Jam Masuk">
<?= $p['jam_masuk']
? (($p['jam_masuk'] > '07:00:00')
? esc($p['jam_masuk']).' <span class="text-danger fw-bold">Terlambat</span>'
: esc($p['jam_masuk']))
: '-' ?>
</td>

<td data-label="Jam Sholat">
<?php if ($p['id_kehadiran'] === '1' && empty($p['jam_sholat'])): ?>
    <span class="fw-bold text-danger">Tidak Solat</span>
<?php elseif (!empty($p['jam_sholat'])): ?>
    <?= esc($p['jam_sholat']) ?>
<?php else: ?>
    
<?php endif; ?>
</td>


<td data-label="Jam Pulang">
<?php if ($p['id_kehadiran']==='1' && empty($p['jam_keluar'])): ?>
<span class="fw-bold text-warning">TAP</span>
<?php elseif (!empty($p['jam_keluar'])): ?>
<?= esc($p['jam_keluar']) ?>
<?php else: ?>-<?php endif; ?>
</td>

<td data-label="Status">
<span class="badge <?= $statusBadge ?>"><?= $statusText ?></span>
</td>
</tr>
<?php endforeach; else: ?>
<tr><td colspan="6" class="text-center text-muted">Data tidak tersedia</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>

<style>
@media (max-width:576px){
table thead{display:none}
table tbody tr{display:block;margin-bottom:1rem;border:1px solid #dee2e6;border-radius:10px;padding:.5rem;background:#fff}
table tbody td{display:flex;justify-content:space-between;padding:.4rem .6rem;border:none;font-size:.85rem}
table tbody td::before{content:attr(data-label);font-weight:600;color:#555}
}
</style>

</div>
</div>
</div>

<?= $this->endSection() ?>
