<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<!-- //✅✅ Style -->
    <style>
        .card { border-radius:1rem; transition:.4s; box-shadow:0 6px 10px #000; cursor:pointer; }
        .card:hover { transform:translateY(-1px); box-shadow:0 10px 10px rgba(0,0,0,.3); }
        .card-icon i { font-size:3rem; transition:.4s; }
        .card:hover .card-icon i { transform:scale(1.5) rotate(10deg); }
        .card-glass { background:linear-gradient(135deg,#162f38,#472761); color:#fff; border-radius:1rem; border:none; }
        .table thead.custom-header { background:#0d6efd; color:#fff; text-align:center; }
        .card-header-solid { background:#0d6efd; color:#fff; }
        .mobile-rekap-card { 
            border-radius: 12px; overflow: hidden; border: 1px solid #dee2e6; 
        }
        .mobile-rekap-card .card-header { 
            font-weight: 600; font-size: 0.9rem; background-color: #0d6efd; color: #fff;
        }
        .mobile-rekap-card .avatar img { 
            width: 50px; height: 50px; border-radius: 50%; object-fit: cover; border: 2px solid #fff; 
        }
        .mobile-rekap-card .info small { font-size: 0.75rem; color: #6c757d; }
        .mobile-rekap-card .status-bar { text-align: center; color: #fff; font-weight: 600; padding: 6px 0; border-radius: 4px; }
    </style>
<!-- ---------------------------------------------------- -->

<!-- // ✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅ -->
 <!-- / Konten Di bungkus -->
<!-- RINGKASAN CARD -->
<div class="content py-4" style="min-height:100vh;background:#4b88c5">
<div class="container-fluid mb-4">
<!-- Background putih-->
<div class="card shadow-sm mb-4">

        <!-- ✅JUDUL -->
            <div class="card-body border-bottom">
                <h4 class="fw-bold mb-0">
                    <i class="material-icons align-middle">dashboard</i>
                    <?= esc($title ?? 'Laporan Presensi') ?>
                </h4>
            </div>
        <!-- ............................................. -->

            <!-- ✅Filter Kelas / Tanggal / Tombol  -->        
                <form method="get" class="row g-3 align-items-end">

                    <!-- Kelas -->
                    <div class="col-12 col-md-3">
                    <label class="form-label fw-bold">Kelas</label>
                    <select name="kelas" class="form-select">
                        <option value="all" <?= ($selectedKelas==='all')?'selected':'' ?>>Semua Kelas</option>
                        <?php foreach($kelasList ?? [] as $k): ?>
                        <option value="<?= $k['id_kelas'] ?>" <?= ($selectedKelas==$k['id_kelas'])?'selected':'' ?>>
                            <?= esc($k['kelas']) ?>
                        </option>
                        <?php endforeach ?>
                    </select>
                    </div>

                    <!-- Tanggal -->
                    <div class="col-12 col-md-3">
                    <label class="form-label fw-bold">Tanggal</label>
                    <input type="date" name="tanggal" value="<?= $tanggal ?>" class="form-control" required>
                    </div>

                    <!-- Tombol -->
                    <div class="col-12 col-md-6 d-flex flex-column flex-md-row gap-2">
                    <button class="btn btn-primary flex-fill">Filter</button>
                    <a href="<?= base_url('admin/lap/lapharian?kelas=&tanggal=') ?>" class="btn flex-fill" style="background-color: #1cbcf6; color: white;">Reset</a>
                    <a href="<?= base_url('admin/lap/lapharian/exportCSV?kelas='.($selectedKelas ?? 'all').'&tanggal='.$tanggal) ?>" class="btn btn-success flex-fill">Export</a>
                    <a href="<?= base_url('admin/menurekap') ?>" class="btn flex-fill" style="background-color: #154683; color: white;">Menu </a>
                    </div>
                </form>
        
                <style>
                /* Tambahan styling ringan agar tampilan lebih menarik di mobile */
                .card-body form label {
                    font-size: 0.9rem;
                }

                @media (max-width: 575.98px) {
                    .card-body form .btn {
                        font-size: 0.9rem;
                        padding: 0.5rem;
                    }
                }
                </style>
            <!-- ............................................. -->        

            <!-- Jarak  -->
            <div class="card-body"><div class="card-body"></div></div>


            <!-- ✅ CARD HADIR / SAKIT / IJIN / ALPA / JUMLAH SISWA -->
                    <div class="card-body">

            <!-- ✅JUDUL -->
                <div class="card shadow-sm mb-2">
                <div class="card-body ">
                    
                    <h4 class="fw-bold mb-0">
                        <i class="material-icons align-middle">print</i>
                        <?= esc('Laporan Presensi') ?>
                    </h4>
                </div>
                </div>


                        <?php
                        $hadir=$sakit=$izin=$alpa=$terlambat=0;
                        foreach($laporan ?? [] as $row){
                            switch($row['id_kehadiran'] ?? ''){
                                case '1':
                                    $hadir++;
                                    if(!empty($row['jam_masuk']) && $row['jam_masuk']>'07:00:00'){
                                        $terlambat++;
                                    }
                                    break;
                                case '2':$sakit++;break;
                                case '3':$izin++;break;
                                default:$alpa++;
                            }
                        }
                        $statusAktif=$_GET['status'] ?? 'all';

                        $barisCards=[
                            ['icon'=>'how_to_reg','title'=>'Hadir','value'=>$hadir,'status'=>'1'],
                            ['icon'=>'medical_services','title'=>'Sakit','value'=>$sakit,'status'=>'2'],
                            ['icon'=>'assignment_turned_in','title'=>'Izin','value'=>$izin,'status'=>'3'],
                            ['icon'=>'qr_code_scanner','title'=>'Alpa','value'=>$alpa,'status'=>'4'],
                            ['icon'=>'schedule','title'=>'Datang Terlambat','value'=>$terlambat,'status'=>'terlambat'], // <-- GANTI 'all' menjadi 'terlambat'
                            ['icon'=>'group','title'=>'Total Siswa','value'=>count($laporan ?? []),'status'=>'all'],
                        ];

                        ?>

                        <div class="row mb-5">
                        <?php foreach($barisCards as $c): ?>
                        <?php
                        $isActive=($statusAktif===$c['status'])?'border border-3 border-warning':'';
                        $url=current_url().'?kelas='.($selectedKelas ?? 'all').'&tanggal='.($tanggal ?? '').'&status='.$c['status'];
                        ?>
                        <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                        <a href="<?= $url ?>" class="text-decoration-none">
                        <div class="card card-glass text-center h-100 <?= $isActive ?>">
                        <div class="card-body">
                        <div class="card-icon mb-1"><i class="material-icons"><?= $c['icon'] ?></i></div>
                        <h6><?= $c['title'] ?></h6>
                        <h4><?= $c['value'] ?></h4>
                        <?php if($isActive): ?><small class="text-warning fw-bold">AKTIF</small><?php endif ?>
                        </div>
                        </div>
                        </a>
                        </div>
                        <?php endforeach ?>
                        </div>
            <!-- ............................................. -->


            <!-- ✅ TABEL / JUMLAH SISWA -->
                    <!-- TABEL -->
                    <table class="table table-bordered table-striped d-none d-sm-table">
                        <thead class="custom-header">
                            <tr>
                                <th>No</th>
                                <th>Nama</th>
                                <th>JK</th>
                                <th>Kelas</th>
                                <th>Jam Masuk</th>
                                <th>Jam Sholat</th>
                                <th>Jam Keluar</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($laporan): $no = 1; foreach ($laporan as $r): ?>
                                <tr>
                                    <td class="text-center"><?= $no++ ?></td>
                                    <td>
                                        <a href="<?= site_url('admin/lap/detail-siswa/'.$r['id_siswa'].'?tanggal='.$tanggal.'&kelas='.$selectedKelas) ?>"
                                        class="fw-bold text-decoration-none">
                                            <?= esc($r['nama_siswa']) ?>
                                        </a>
                                    </td>
                                    <td class="text-center"><?= esc($r['jk']) ?></td>
                                    <td class="text-center"><?= esc($r['kelas']) ?></td>
                                    <td class="text-center">
                                        <?= $r['jam_masuk']
                                            ? (($r['jam_masuk'] > '07:00:00')
                                                ? esc($r['jam_masuk']).' <span class="text-danger fw-bold">Terlambat</span>'
                                                : esc($r['jam_masuk']))
                                            : '-' ?>
                                    </td>
                                    <td class="text-center"><?= $r['jam_sholat'] ?: '-' ?></td>
                                    <td class="text-center"><?= $r['jam_keluar'] ?: '-' ?></td>
                                    <td class="text-center">
                                        <span class="badge <?= $r['id_kehadiran']=='1'?'bg-success':($r['id_kehadiran']=='2'?'bg-warning':'bg-danger') ?>">
                                            <?= ['1'=>'Hadir','2'=>'Sakit','3'=>'Izin'][$r['id_kehadiran']] ?? 'Alpa' ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; else: ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">Data tidak tersedia</td>
                                </tr>
                            <?php endif ?>
                        </tbody>
                    </table>
                    </div>
            <!-- ......................................... -->


            <!-- ✅ Mobile Card TABEL  -->
                    <div class="card-body">
                    <!-- Kode Dimana Tabel ini hanya tampil di Mobile -->
                    <div class="d-block d-sm-none">
                    <!-- Kode Dimana Tabel ini hanya tampil di Mobile -->

                    <?php if(!empty($laporan)): ?>
                        <?php $no = 1; foreach($laporan as $row): ?>
                            <?php 
                                $statusText = match($row['id_kehadiran'] ?? '') { '1'=>'Hadir','2'=>'Sakit','3'=>'Izin',default=>'Alpa' };
                                $statusColor = match($row['id_kehadiran'] ?? '') { '1'=>'#28a745','2'=>'#fbff00','3'=>'#17a2b8',default=>'#ff0000' };
                                $foto = !empty($row['photo']) ? base_url('uploads/siswa/'.$row['photo']) : base_url('uploads/default.png');
                                $jamSholatDisplay = !empty($row['jam_sholat']) ? esc($row['jam_sholat']) : (($row['id_kehadiran']=='1') ? '<span class="badge text-bg-danger">Tidak</span>' : '-');
                                $jamMasukDisplay = !empty($row['jam_masuk']) ? (($row['jam_masuk'] > '07:00:00') ? esc($row['jam_masuk']).' <span class="text-danger fw-bold">Terlambat</span>' : esc($row['jam_masuk'])) : '-';
                                $jamKeluarDisplay = !empty($row['jam_keluar']) ? esc($row['jam_keluar']) : (($row['id_kehadiran']=='1') ? '<span class="text-danger fw-bold">TAP</span>' : '-');

                                // LINK DETAIL SISWA
                                $detailUrl = site_url(
                                    'admin/lap/detail-siswa/' . $row['id_siswa']
                                    . '?tanggal=' . $tanggal
                                    . '&kelas=' . ($selectedKelas ?? 'all')
                                );
                            ?>
                            <div class="card mb-3 shadow-sm mobile-card">

                                <!-- HEADER (KLIK MASUK DETAIL SISWA) -->
                                <div class="card-header">
                                    <a href="<?= $detailUrl ?>" class="text-decoration-none text-white">
                                        <?= esc($row['nama_siswa'] ?? '-') ?>
                                        • <?= esc($row['kelas'] ?? $row['nama_kelas'] ?? '-') ?>
                                    </a>
                                </div>

                                <div class="card-body d-flex gap-3 align-items-center">
                                    <div class="avatar">
                                        <img src="<?= $foto ?>" alt="Foto Siswa">
                                    </div>
                                    <div class="info flex-grow-1">
                                        <h6 class="mb-1">
                                            <!-- NAMA JUGA BISA DIKLIK -->
                                            <a href="<?= $detailUrl ?>" class="text-decoration-none text-dark">
                                                <?= esc($row['nama_siswa'] ?? '-') ?>
                                            </a>
                                        </h6>
                                        <p class="mb-2 text-muted">
                                            <?= esc($row['nis'] ?? '-') ?> | <?= esc($row['jk'] ?? '-') ?>
                                        </p>
                                        <div class="d-flex justify-content-between text-center mb-1">
                                            <div>
                                                <small>Jam Masuk</small>
                                                <div><?= $jamMasukDisplay ?></div>
                                            </div>
                                            <div>
                                                <small>Jam Sholat</small>
                                                <div><?= $jamSholatDisplay ?></div>
                                            </div>
                                            <div>
                                                <small>Jam Pulang</small>
                                                <div><?= $jamKeluarDisplay ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="status-bar mt-2" style="background-color: <?= $statusColor ?>;">
                                    <?= $statusText ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="text-center text-muted">Data tidak tersedia</div>
                    <?php endif; ?>
                    </div>
                    <!-- ......................................... -->
                    <!-- Style Mobile Card -->
                    <!-- ......................................... -->
                    <style>
                        .mobile-card { border-radius: 12px; overflow: hidden; border: none; }
                        .mobile-card .card-header { background-color: #0d6efd; color: #fff; font-weight: 600; font-size: 0.9rem; }
                        .mobile-card .avatar img { width: 50px; height: 50px; border-radius: 50%; object-fit: cover; border: 2px solid #fff; }
                        .mobile-card .info small { font-size: 0.75rem; color: #6c757d; }
                        .mobile-card .status-bar { text-align: center; color: #fff; font-weight: 600; padding: 6px 0; border-radius: 4px; }
                        .mobile-card .badge.text-bg-danger { font-size: 0.75rem; padding: 2px 6px; }
                    </style>
            <!-- ......................................... -->


</div>
</div>
</div>

<?= $this->endSection() ?>
