<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<!-- //✅✅ Style -->
    <style>
        .card { border-radius:1rem; transition:.4s; box-shadow:0 6px 10px #000; cursor:pointer; }
        .card:hover { transform:translateY(-1px); box-shadow:0 10px 10px rgba(0,0,0,.3); }
        .card-icon i { font-size:3rem; transition:.4s; }
        .card:hover .card-icon i { transform:scale(1.5) rotate(10deg); }
        .card-glass { background:linear-gradient(135deg,#162f38,#472761); color:#fff; border-radius:1rem; border:none; }
        .table thead.custom-header { background:#0d6efd; color:#fff; text-align:center; }
        .card-header-solid { background:#0d6efd; color:#fff; }
        .mobile-rekap-card { 
            border-radius: 12px; overflow: hidden; border: 1px solid #dee2e6; 
        }
        .mobile-rekap-card .card-header { 
            font-weight: 600; font-size: 0.9rem; background-color: #0d6efd; color: #fff;
        }
        .mobile-rekap-card .avatar img { 
            width: 50px; height: 50px; border-radius: 50%; object-fit: cover; border: 2px solid #fff; 
        }
        .mobile-rekap-card .info small { font-size: 0.75rem; color: #6c757d; }
        .mobile-rekap-card .status-bar { text-align: center; color: #fff; font-weight: 600; padding: 6px 0; border-radius: 4px; }
    </style>
<!-- ---------------------------------------------------- -->

<!-- // ✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅ -->
 <!-- / Konten Di bungkus -->
<!-- RINGKASAN CARD -->
<div class="content py-4" style="min-height:100vh;background:#4b88c5">
<div class="container-fluid mb-4">

    <!-- Background putih-->
    <div class="card shadow-sm mb-4">
        <div class="card-body border-bottom">
            <h4 class="fw-bold mb-0">
                <i class="material-icons align-middle">dashboard</i>
                <?= esc($title ?? 'Laporan Presensi') ?>
            </h4>
        </div>

        <form method="get" class="row g-3 align-items-end">

      <!-- Kelas -->
      <div class="col-12 col-md-4 col-lg-3">
        <label for="kelas" class="form-label fw-bold">Kelas</label>
        <select id="kelas" name="kelas" class="form-select">
          <option value="all" <?= ($selectedKelas === 'all') ? 'selected' : '' ?>>Semua Kelas</option>
          <?php foreach($kelasList ?? [] as $k): ?>
            <option value="<?= $k['id_kelas'] ?>" <?= ($selectedKelas == $k['id_kelas']) ? 'selected' : '' ?>>
              <?= esc($k['kelas']) ?>
            </option>
          <?php endforeach ?>
        </select>
      </div>

      <!-- Pilih Minggu -->
      <div class="col-12 col-md-5 col-lg-4">
        <label class="form-label fw-bold">Pilih Minggu</label>
        <div class="d-flex flex-column flex-sm-row align-items-center gap-2">
          <input type="date" name="tanggal_awal" class="form-control flex-fill" value="<?= $tanggalAwal ?? date('Y-m-d') ?>" required>
          <span class="mx-1 d-none d-sm-inline">s/d</span>
          <input type="date" name="tanggal_akhir" class="form-control flex-fill" value="<?= $tanggalAkhir ?? date('Y-m-d') ?>" required>
        </div>
        <small class="text-muted">Pilih rentang Senin - Jum'at</small>
      </div>

      <!-- Tombol -->
      <div class="col-12 col-md-12 col-lg-5 d-flex flex-column flex-md-row gap-2">
        <button type="submit" class="btn btn-primary flex-fill">Filter</button>
            <a href="<?= base_url('admin/lap/lapmingguan') . '?kelas=' . ($selectedKelas ?? '') . '&tanggal_awal=&tanggal_akhir=' ?>" class="btn btn-secondary flex-fill">Reset Tanggal</a>
            <a href="<?= base_url('admin/lap/lapmingguan/exportCSV?kelas=' . ($selectedKelas ?? 'all') . '&tanggal_awal=' . $tanggalAwal . '&tanggal_akhir=' . $tanggalAkhir) ?>" class="btn btn-success flex-fill">Export</a>
             <a href="<?= base_url('admin/menurekap') ?>" class="btn flex-fill" style="background-color: #154683; color: white;">Menu </a>
      </div>

    </form>

    <style>
        /* Styling ringan untuk tampilan lebih rapi di mobile */
        .card-body form label {
            font-size: 0.9rem;
        }

        .card-body form .btn {
            min-height: 38px; /* tombol lebih proporsional di mobile */
        }

        @media (max-width: 575.98px) {
            .card-body form .btn {
                font-size: 0.9rem;
                padding: 0.45rem;
            }
        }
        </style>

       <!-- Ringkasan Card -->
        <div class="card-body">
            <?php 
            $statusAktif = $_GET['status'] ?? 'all';
            $barisCards = [
                ['icon'=>'how_to_reg','title'=>'Hadir','value'=>$summary['hadir'] ?? 0,'status'=>'1'],
                ['icon'=>'medical_services','title'=>'Sakit','value'=>$summary['sakit'] ?? 0,'status'=>'2'],
                ['icon'=>'assignment_turned_in','title'=>'Izin','value'=>$summary['izin'] ?? 0,'status'=>'3'],
                ['icon'=>'qr_code_scanner','title'=>'Alpa','value'=>$summary['alpa'] ?? 0,'status'=>'4'],
                ['icon'=>'schedule','title'=>'Datang Terlambat','value'=>$summary['terlambat'] ?? 0,'status'=>'terlambat'],
                ['icon'=>'group','title'=>'Total Siswa','value'=>$summary['total'] ?? 0,'status'=>'all'],
            ];
            ?>
            <div class="row mb-4">
                <?php foreach($barisCards as $c): ?>
                    <?php
                    $isActive = ($statusAktif === $c['status']) ? 'border border-3 border-warning' : '';
                    $url = current_url().'?kelas='.($selectedKelas ?? 'all').'&tanggal_awal='.($tanggalAwal ?? '').'&tanggal_akhir='.($tanggalAkhir ?? '').'&status='.$c['status'];
                    ?>
                    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                        <a href="<?= $url ?>" class="text-decoration-none">
                            <div class="card card-glass text-center h-100 <?= $isActive ?>">
                                <div class="card-body">
                                    <div class="card-icon mb-1"><i class="material-icons"><?= $c['icon'] ?></i></div>
                                    <h6><?= $c['title'] ?></h6>
                                    <h4><?= $c['value'] ?></h4>
                                    <?php if($isActive): ?><small class="text-warning fw-bold">AKTIF</small><?php endif ?>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach ?>
            </div>


<div class="card-body">
            <?php if($laporan): ?>
            <h5 class="mt-4">Rekap Mingguan
                <small class="text-muted">(<?= date('d M Y', strtotime($tanggalAwal)) ?> s/d <?= date('d M Y', strtotime($tanggalAkhir)) ?>)</small>
            </h5>

            <div class="d-none d-sm-block">
                <table class="table table-bordered table-sm">
                    <thead class="table-secondary">
                        <tr>
                            <th>No</th>
                            <th>Nama</th>
                            <th>Hadir</th>
                            <th>Sakit</th>
                            <th>Izin</th>
                            <th>Alpa</th>
                            <th>Terlambat</th>
                            <th>Tidak Solat</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no=1; foreach($laporan as $r): ?>
                            <tr>
                                <td class="text-center"><?= $no++ ?></td>
                                <td><?= esc($r['nama_siswa']) ?></td>
                                <td class="text-center"><?= $r['hadir'] ?></td>
                                <td class="text-center"><?= $r['sakit'] ?></td>
                                <td class="text-center"><?= $r['izin'] ?></td>
                                <td class="text-center"><?= $r['alpa'] ?></td>
                                <td class="text-center"><?= $r['terlambat'] ?></td>
                                <td class="text-center"><?= $r['tidak_solat'] ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Card Mobile -->
            <div class="d-block d-sm-none">
                <?php $no=1; foreach($laporan as $row): ?>
                    <?php 
                        $foto = !empty($row['photo']) ? base_url('uploads/siswa/'.$row['photo']) : base_url('uploads/default.png');
                    ?>
                    <div class="card mb-3 shadow-sm mobile-rekap-card">
                        <div class="card-header"><?= $no++ ?> • <?= esc($row['nama_siswa']) ?> • <?= esc($row['kelas']) ?></div>
                        <div class="card-body d-flex gap-2 align-items-center">
                            <div class="avatar"><img src="<?= $foto ?>" alt="Foto Siswa"></div>
                            <div class="info flex-grow-1">
                                <h6 class="mb-1"><?= esc($row['nama_siswa']) ?></h6>
                                <p class="mb-1 text-muted"><?= esc($row['nis'] ?? '-') ?> | <?= esc($row['jk'] ?? '-') ?></p>
                                <div class="d-flex flex-wrap justify-content-between mb-1">
                                    <div><small>Hadir</small><div><?= $row['hadir'] ?></div></div>
                                    <div><small>Sakit</small><div><?= $row['sakit'] ?></div></div>
                                    <div><small>Izin</small><div><?= $row['izin'] ?></div></div>
                                    <div><small>Alpa</small><div><?= $row['alpa'] ?></div></div>
                                    <div><small>Terlambat</small><div><?= $row['terlambat'] ?></div></div>
                                    <div><small>Tidak Solat</small><div><?= $row['tidak_solat'] ?></div></div>
                                </div>
                            </div>
                        </div>
                        <div class="status-bar mt-2" style="background-color:#0d6efd;"><?= esc($row['kelas']) ?></div>
                    </div>
                <?php endforeach; ?>
            </div>

            <?php else: ?>
                <div class="text-center text-muted">Data tidak tersedia</div>
            <?php endif; ?>
        </div>




        </div>
    </div>


</div>
</div>
</div>

<?= $this->endSection() ?>
