<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
    <div class="container-fluid px-2 px-md-4">

        <div class="card">
            <div class="card-header card-header-info py-3">
                <h4 class="card-title mb-0 fs-6 fs-md-5">
                    ini di view kamu bagian Card Title
                </h4>
            </div>

            <div class="card-body">








<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>LAPORAN DATA SISWA </title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
/* ===== FOTO SISWA (MOBILE ONLY) ===== */
.foto-siswa{
    width:50px;
    height:50px;
    border-radius:50%;
    object-fit:cover;
    border:2px solid #dee2e6;
}

/* ===== MOBILE CARD ===== */
@media (max-width:768px){
    .table-responsive{display:none;}

    .presensi-card{
        border-radius:15px;
        box-shadow:0 6px 15px rgba(0,0,0,.1);
        margin-bottom:15px;
        overflow:hidden;
    }
    .card-hadir{border-left:6px solid #28a745;}
    .card-sakit{border-left:6px solid #ffc107;}
    .card-izin{border-left:6px solid #0dcaf0;}
    .card-alpha{border-left:6px solid #dc3545;}

    .presensi-card .card-header{
        background:linear-gradient(135deg,#1e3c72,#2a5298);
        color:#fff;
        font-weight:bold;
        font-size:14px;
    }
}

/* HIDE FOTO SAAT PRINT */
@media print{
    img{display:none!important;}
}
</style>
</head>
<body class="bg-light">

<div class="container py-4">

    <h4 class="mb-3">
        <i class="fa fa-file-alt text-primary"></i> DATA SISWA
    </h4>

    <!-- FORM FILTER -->
    <form method="get" class="row g-2 mb-4">
        
        <div class="col-12 col-md-3">
            <select name="kelas" class="form-select" onchange="this.form.submit()">
                <option value="">-- Semua Kelas --</option>
                <?php foreach ($kelas as $k): ?>
                    <option value="<?= $k['id_kelas'] ?>"
                        <?= $id_kelas == $k['id_kelas'] ? 'selected' : '' ?>>
                        <?= $k['kelas'] ?>
                    </option>
                <?php endforeach ?>
            </select>
        </div>
    </form>


    <div id="areaCetak">
        <!-- ===== MOBILE CARDS ===== -->
        <?php foreach ($data as $row): ?>
        <?php
            $status = strtolower($row['kehadiran'] ?? 'alpha');

            $cardClass = match($status){
                'hadir' => 'card-hadir',
                'sakit' => 'card-sakit',
                'izin'  => 'card-izin',
                default => 'card-alpha'
            };

            $badgeClass = match($status){
                'hadir' => 'success',
                'sakit' => 'warning',
                'izin'  => 'info',
                default => 'danger'
            };

            $foto = !empty($row['foto'])
                ? base_url('uploads/siswa/'.$row['foto'])
                : base_url('uploads/default.png');
        ?>
        <div class="card presensi-card d-md-none <?= $cardClass ?>">
            <div class="card-header">
                <?= $row['nama_siswa'] ?> • <?= $row['kelas'] ?>
            </div>
            <div class="card-body small">
                <div class="d-flex align-items-center mb-2">
                    <img src="<?= $foto ?>" class="foto-siswa me-3">
                    <div>
                        <div class="fw-bold"><?= $row['nama_siswa'] ?></div>
                        <small><?= $row['jenis_kelamin'] ?></small>
                    </div>
                </div>

            </div>
        </div>
        <?php endforeach ?>


        <!-- ===== DESKTOP TABLE ===== -->
        <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
        <thead class="table-dark text-center">
        <tr>
        <th>No</th>
        <th>Nama</th>
        <th>JK</th>
        <th>Kelas</th>

        </tr>
        </thead>
        <tbody>
        <?php $no=1; foreach ($data as $row): ?>
        <tr>
        <td class="text-center"><?= $no++ ?></td>
        <td><?= $row['nama_siswa'] ?></td>
        <td class="text-center"><?= $row['jenis_kelamin'] ?></td>
        <td class="text-center"><?= $row['kelas'] ?></td>

        
        </tr>
        <?php endforeach ?>
        </tbody>
        </table>
        </div>

    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function printLaporan(){
    let c=document.getElementById('areaCetak').innerHTML;
    let o=document.body.innerHTML;
    document.body.innerHTML=`<html><head><style>
        body{font-family:Arial;}
        table{width:100%;border-collapse:collapse;}
        table,th,td{border:1px solid #000;}
        th,td{padding:6px;font-size:12px;}
        img{display:none;}
    </style></head><body>${c}</body></html>`;
    window.print(); 
    document.body.innerHTML=o; 
    location.reload();
}
</script>

</body>
</html>




















            </div>
        </div>

    </div>
</div>

<?= $this->endSection() ?>
