<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
.filter-box{
    background:#f8f9fa;
    border:1px solid #dee2e6;
    border-radius:12px;
    padding:14px;
    margin-bottom:15px;
}
.rekap-box{
    border-radius:14px;
    padding:12px;
    background:#e7f1ff;
    font-size:13px;
}
@media print{
    button,.filter-box{display:none!important;}
}
</style>

<div class="content">
<div class="container-fluid px-2 px-md-4">

<div class="card shadow border-0">
<div class="card-header card-header-info py-3">
    <h4 class="card-title mb-0">📅 LAPORAN PRESENSI BULANAN</h4>
</div>

<div class="card-body">

<h5 class="fw-bold text-center mb-1">SISWA SMAN 1 CIKATOMAS</h5>
<p class="text-center text-muted mb-3">
    Bulan: <?= date('F Y', strtotime($bulan.'-01')) ?>
</p>

<!-- FILTER -->
<form method="get" class="row g-2 filter-box align-items-end">
    <div class="col-md-3">
        <label>Bulan</label>
        <input type="month" name="bulan"
               value="<?= $bulan ?? date('Y-m') ?>"
               class="form-control">
    </div>

    <div class="col-md-4">
        <label>Kelas</label>
        <select name="kelas" class="form-select">
            <option value="">-- Semua Kelas --</option>
            <?php foreach($kelas as $k): ?>
            <option value="<?= $k['id_kelas'] ?>"
                <?= $id_kelas==$k['id_kelas']?'selected':'' ?>>
                <?= $k['kelas'] ?>
            </option>
            <?php endforeach ?>
        </select>
    </div>

    <div class="col-md-3">
        <button class="btn btn-primary w-100">🔍 Tampilkan</button>
    </div>
</form>

<button onclick="window.print()" class="btn btn-success mb-3">
    🖨 Cetak Laporan
</button>

<a href="<?= base_url('admin/laporan-bulanan/excel?bulan='.$bulan.'&kelas='.$id_kelas) ?>"
   class="btn btn-success mb-3">
   📥 Export Excel
</a>




<!-- REKAP -->
<?php
$totalHadir=$totalSakit=$totalIzin=$totalAlpha=$totalDuhur=0;
foreach($data as $r){
    $totalHadir+=$r['hadir'];
    $totalSakit+=$r['sakit'];
    $totalIzin+=$r['izin'];
    $totalAlpha+=$r['alpha'];
    // $totalDuhur+=$r['duhur'];
}
?>

<div class="rekap-box mb-3">
    Hadir: <b class="text-success"><?= $totalHadir ?></b> |
    Sakit: <b class="text-warning"><?= $totalSakit ?></b> |
    Izin: <b class="text-info"><?= $totalIzin ?></b> |
    Alpha: <b class="text-danger"><?= $totalAlpha ?></b> |
    <!-- Duhur: <b class="text-success"><?= $totalDuhur ?></b> -->
</div>

<!-- TABLE -->
<div class="table-responsive">
<table class="table table-bordered table-striped align-middle">
<thead class="table-dark text-center">
<tr>
    <th>No</th>
    <th>Nama</th>
    <!-- <th>JK</th> -->
    <th>Kelas</th>
    <th>Hadir</th>
    <th>Sakit</th>
    <th>Izin</th>
    <th>Alpha</th>
    <!-- <th>Duhur</th> -->
</tr>
</thead>
<tbody>
<?php $no=1; foreach($data as $row): ?>
<tr class="text-center">
    <td><?= $no++ ?></td>
    <td class="text-start"><?= $row['nama_siswa'] ?></td>
  
    <td><?= $row['kelas'] ?></td>
    <td class="text-success fw-semibold"><?= $row['hadir'] ?></td>
    <td class="text-warning fw-semibold"><?= $row['sakit'] ?></td>
    <td class="text-info fw-semibold"><?= $row['izin'] ?></td>
    <td class="text-danger fw-semibold"><?= $row['alpha'] ?></td>
    
</tr>
<?php endforeach ?>
</tbody>
</table>
</div>

</div>
</div>

</div>
</div>

<?= $this->endSection() ?>
