<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
    <!-- <div class="container-fluid"> -->

        <div class="card">
            <div class="card-header card-header-info">
                <h4 class="card-title">ISI SAMA JUDUL</h4>
                <p class="card-category">Pilih Kelas Terlebih dahulu untuk mencetak Laporan</p>
            </div>
<div class="card-body">





<style>
/* ===== LEGEND ===== */
.legend-presensi{
    display:flex;
    gap:12px;
    flex-wrap:wrap;
    margin-bottom:15px;
    font-size:13px;
}
.legend-item{
    display:flex;
    align-items:center;
    gap:6px;
    padding:5px 10px;
    border-radius:20px;
    font-weight:500;
}
.legend-dot{width:12px;height:12px;border-radius:50%;}
.legend-hadir{background:#e9f7ef}.legend-hadir .legend-dot{background:#28a745}
.legend-sakit{background:#fff8e1}.legend-sakit .legend-dot{background:#ffc107}
.legend-izin{background:#e7f5ff}.legend-izin .legend-dot{background:#0dcaf0}
.legend-alpha{background:#fdecea}.legend-alpha .legend-dot{background:#dc3545}

/* ===== FOTO SISWA ===== */
.foto-siswa{
    width:48px;
    height:48px;
    border-radius:50%;
    object-fit:cover;
    border:2px solid #fff;
    box-shadow:0 2px 6px rgba(0,0,0,.2);
}

/* ===== MOBILE CARD ===== */
@media (max-width:768px){
    .table-responsive{display:none;}

    .presensi-card{
        border-radius:15px;
        box-shadow:0 6px 15px rgba(0,0,0,.1);
        margin-bottom:15px;
        border-left:6px solid #ccc;
    }
    .card-hadir{border-left-color:#28a745}
    .card-sakit{border-left-color:#ffc107}
    .card-izin{border-left-color:#0dcaf0}
    .card-alpha{border-left-color:#dc3545}

    .presensi-card .card-header{
        background:linear-gradient(135deg,#1e3c72,#2a5298);
        color:#fff;
        font-weight:bold;
        font-size:14px;
        display:flex;
        align-items:center;
        gap:10px;
    }
}

@media print{
    .legend-presensi{display:none;}
    .foto-siswa{display:none;}
}
</style>

<h4 class="mb-4">
    <i class="fa fa-calendar-week text-primary"></i> Laporan Presensi Mingguan
</h4>

<form method="get" class="row mb-4">
    <div class="col-md-3">
        <label class="form-label fw-bold">Bulan</label>
        <input type="month" name="bulan" value="<?= $bulan ?>" class="form-control">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold">Minggu</label>
        <select name="minggu" class="form-select">
            <option value="">-- Semua Minggu --</option>
            <?php for($i=1;$i<=5;$i++): ?>
                <option value="<?= $i ?>" <?= $minggu==$i?'selected':'' ?>>
                    Minggu <?= $i ?>
                </option>
            <?php endfor ?>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold">Kelas</label>
        <select name="kelas" class="form-select">
            <option value="">-- Semua Kelas --</option>
            <?php foreach($kelas as $k): ?>
                <option value="<?= $k['id_kelas'] ?>" <?= $id_kelas==$k['id_kelas']?'selected':'' ?>>
                    <?= $k['kelas'] ?>
                </option>
            <?php endforeach ?>
        </select>
    </div>

    <div class="col-md-3 d-flex align-items-end">
        <button class="btn btn-primary w-100">
            <i class="fa fa-search"></i> Tampilkan
        </button>
    </div>
</form>

<button onclick="printLaporan()" class="btn btn-success mb-3">
    <i class="fa fa-print"></i> Cetak Laporan Mingguan
</button>

<div id="areaCetak">
<hr>

<!-- MOBILE CARD -->
<?php foreach($data as $row): ?>
<div class="card presensi-card d-md-none card-hadir">
    <div class="card-header">
        <img src="<?= base_url('uploads/default.png') ?>" class="foto-siswa">
        <div>
            <?= $row['nama_siswa'] ?><br>
            <small><?= $row['kelas'] ?></small>
        </div>
    </div>
    <div class="card-body small">
        <div>Hadir : <b class="text-success"><?= $row['hadir'] ?></b></div>
        <div>Sakit : <b class="text-warning"><?= $row['sakit'] ?></b></div>
        <div>Izin  : <b class="text-info"><?= $row['izin'] ?></b></div>
        <div>Alpha : <b class="text-danger"><?= $row['alpha'] ?></b></div>
    </div>
</div>
<?php endforeach ?>

<!-- DESKTOP TABLE -->
<div class="table-responsive">
<table class="table table-bordered table-striped">
<thead class="table-dark text-center">
<tr>
<th>No</th><th>NIS</th><th>Nama</th><th>Kelas</th>
<th>Hadir</th><th>Sakit</th><th>Izin</th><th>Alpha</th>
</tr>
</thead>
<tbody>
<?php $no=1; foreach($data as $row): ?>
<tr class="text-center">
<td><?= $no++ ?></td>
<td><?= $row['nis'] ?></td>
<td class="text-start"><?= $row['nama_siswa'] ?></td>
<td><?= $row['kelas'] ?></td>
<td class="text-success fw-bold"><?= $row['hadir'] ?></td>
<td class="text-warning fw-bold"><?= $row['sakit'] ?></td>
<td class="text-info fw-bold"><?= $row['izin'] ?></td>
<td class="text-danger fw-bold"><?= $row['alpha'] ?></td>
</tr>
<?php endforeach ?>
</tbody>
</table>
</div>
</div>

<script>
function printLaporan(){
    let c=document.getElementById('areaCetak').innerHTML;
    let o=document.body.innerHTML;
    document.body.innerHTML=`<html><head><style>
    body{font-family:Arial;}
    table{width:100%;border-collapse:collapse;}
    table,th,td{border:1px solid #000;}
    th,td{padding:6px;font-size:12px;}
    </style></head><body>${c}</body></html>`;
    window.print(); document.body.innerHTML=o; location.reload();
}
</script>








<?= $this->endSection() ?>





