<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
    <div class="container-fluid">

        <div class="card">
            <div class="card-header card-header-info">
                <h4 class="card-title">Laporan Presensi Bulanan</h4>
                <p class="card-category">Pilih Kelas Terlebih dahulu untuk mencetak Laporan</p>
            </div>
<div class="card-body">

<style>
/* FOTO */
.foto-siswa {
    width: 70px;
    height: 70px;
    object-fit: cover;
    border-radius: 50%;
    border: 3px solid #eaeaea;
}
.foto-siswa-sm {
    width: 40px;
    height: 40px;
    object-fit: cover;
    border-radius: 50%;
}

/* CARD MOBILE */
@media (max-width: 768px) {
    .table-responsive { display: none; }

    .presensi-card {
        border-radius: 16px;
        box-shadow: 0 6px 18px rgba(0,0,0,.1);
        margin-bottom: 15px;
        overflow: hidden;
    }

    .presensi-card .card-header {
        background: linear-gradient(135deg,#1e3c72,#2a5298);
        color: #fff;
        font-weight: bold;
        font-size: 14px;
    }
}
</style>

<?php
function hariIndonesia($tanggal)
{
    $hari = date('N', strtotime($tanggal));
    $namaHari = [1=>'Senin',2=>'Selasa',3=>'Rabu',4=>'Kamis',5=>'Jumat',6=>'Sabtu',7=>'Minggu'];
    return $namaHari[$hari];
}
?>

<h4 class="mb-4">
    <i class="fa fa-user text-primary"></i> Laporan Presensi Per Siswa
</h4>

<button onclick="printLaporan()" class="btn btn-primary mb-3">
    <i class="fa fa-print"></i> Cetak
</button>

<form method="get" class="row g-2 mb-4">
    <div class="col-12 col-md-4">
        <select name="siswa" class="form-select" onchange="this.form.submit()">
            <option value="">-- Pilih Siswa --</option>
            <?php foreach ($siswaList as $s): ?>
                <option value="<?= $s['id_siswa'] ?>"
                    <?= ($siswa && $siswa['id_siswa'] == $s['id_siswa']) ? 'selected' : '' ?>>
                    <?= $s['nis'].' - '.$s['nama_siswa'].' ('.$s['kelas'].')' ?>
                </option>
            <?php endforeach ?>
        </select>
    </div>

    <div class="col-12 col-md-3">
        <input type="month" name="bulan" value="<?= $bulan ?>"
               class="form-control" onchange="this.form.submit()">
    </div>
</form>

<div id="areaCetak">

<?php if ($siswa): ?>

<?php
$foto = !empty($siswa['foto'])
    ? base_url('uploads/siswa/'.$siswa['foto'])
    : base_url('uploads/default.png');
?>

<div class="card mb-3">
    <div class="card-body d-flex align-items-center">
        <img src="<?= $foto ?>" class="foto-siswa me-3">
        <div>
            <b><?= $siswa['nama_siswa'] ?></b><br>
            <small class="text-muted"><?= $siswa['nis'] ?></small>
        </div>
    </div>
</div>

<!-- ===== CARD MOBILE ===== -->
<?php if (!empty($data)): foreach ($data as $d): ?>

<?php
    $tanggalData = date('Y-m-d', strtotime($d['tanggal']));
    if ($tanggalData > date('Y-m-d')) continue;
    if (isset($hariLibur) && in_array($tanggalData, $hariLibur)) continue;
    if (date('N', strtotime($d['tanggal'])) >= 6) continue;

    switch ($d['kehadiran']) {
        case 'Hadir': $badge='success'; break;
        case 'Sakit': $badge='warning'; break;
        case 'Izin':  $badge='info'; break;
        default:      $badge='danger'; break;
    }
?>

<div class="card presensi-card d-md-none">
    <div class="card-header">
        <?= hariIndonesia($d['tanggal']) ?>,
        <?= date('d-m-Y', strtotime($d['tanggal'])) ?>
    </div>
    <div class="card-body">
        <div><b>Jam Masuk:</b> <?= $d['jam_masuk'] ?: '-' ?></div>
        <div><b>Jam Keluar:</b> <?= $d['jam_keluar'] ?: '-' ?></div>
        <div>
            <b>Status:</b>
            <span class="badge bg-<?= $badge ?>">
                <?= $d['kehadiran'] ?: 'Alpha' ?>
            </span>
        </div>
        <div><b>Keterangan:</b> <?= $d['keterangan'] ?: '-' ?></div>
    </div>
</div>

<?php endforeach; endif; ?>

<!-- ===== TABEL DESKTOP ===== -->
<div class="table-responsive">
<table class="table table-bordered table-striped align-middle">
    <thead class="table-dark text-center">
        <tr>
            <th>Tanggal</th>
            <th>Jam Masuk</th>
            <th>Jam Keluar</th>
            <th>Status</th>
            <th>Keterangan</th>
        </tr>
    </thead>
    <tbody>

<?php if (!empty($data)): foreach ($data as $d): ?>

<?php
    $tanggalData = date('Y-m-d', strtotime($d['tanggal']));
    if ($tanggalData > date('Y-m-d')) continue;
    if (isset($hariLibur) && in_array($tanggalData, $hariLibur)) continue;
    if (date('N', strtotime($d['tanggal'])) >= 6) continue;

    switch ($d['kehadiran']) {
        case 'Hadir': $badge='success'; $status='Hadir'; break;
        case 'Sakit': $badge='warning'; $status='Sakit'; break;
        case 'Izin':  $badge='info';    $status='Izin'; break;
        default:      $badge='danger';  $status='Alpha'; break;
    }
?>

<tr class="text-center">
    <td><?= hariIndonesia($d['tanggal']) ?>, <?= date('d-m-Y', strtotime($d['tanggal'])) ?></td>
    <td><?= $d['jam_masuk'] ?: '-' ?></td>
    <td><?= $d['jam_keluar'] ?: '-' ?></td>
    <td><span class="badge bg-<?= $badge ?>"><?= $status ?></span></td>
    <td><?= $d['keterangan'] ?: '-' ?></td>
</tr>

<?php endforeach; else: ?>
<tr>
    <td colspan="6" class="text-center text-danger">Tidak ada data</td>
</tr>
<?php endif ?>

    </tbody>
</table>
</div>

<?php endif ?>
</div>

<script>
function printLaporan() {
    let printContent = document.getElementById('areaCetak').innerHTML;
    let originalContent = document.body.innerHTML;
    document.body.innerHTML = `<html><head><style>
        body{font-family:Arial}
        table{width:100%;border-collapse:collapse}
        table,th,td{border:1px solid #000;padding:6px;font-size:12px}
    </style></head><body>${printContent}</body></html>`;
    window.print();
    document.body.innerHTML = originalContent;
    location.reload();
}
</script>


<?= $this->endSection() ?>
