<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid px-2 px-md-4">

<div class="card">
<div class="card-header card-header-info py-3">
    <h4 class="card-title mb-0 fs-6 fs-md-5">DATA SISWA ALPHA</h4>
</div>

<div class="card-body">

<style>
body{font-size:14px;}
@media(max-width:576px){body{font-size:13px;}}

.foto-siswa{
    width:52px;height:52px;object-fit:cover;
    border-radius:50%;border:2px solid #ddd;
}

.legend-presensi{
    display:flex;gap:8px;flex-wrap:wrap;
    margin-bottom:10px;font-size:12px;
}
.legend-item{
    display:flex;align-items:center;gap:6px;
    padding:4px 10px;border-radius:20px;font-weight:500;
}
.legend-dot{width:10px;height:10px;border-radius:50%;}
.legend-hadir{background:#e9f7ef;}
.legend-sakit{background:#fff8e1;}
.legend-izin{background:#e7f5ff;}
.legend-alpha{background:#fdecea;}
.legend-hadir .legend-dot{background:#28a745;}
.legend-sakit .legend-dot{background:#ffc107;}
.legend-izin .legend-dot{background:#0dcaf0;}
.legend-alpha .legend-dot{background:#dc3545;}

.filter-box{
    background:#f8f9fa;border:1px solid #dee2e6;
    border-radius:10px;padding:12px 14px;margin-bottom:15px;
}

.bg-absen{
    background-color:#fdecea !important;
}

@media(max-width:768px){
    .table-responsive{display:none;}
    .presensi-card{
        border-radius:14px;box-shadow:0 4px 12px rgba(0,0,0,.08);
        margin-bottom:14px;overflow:hidden;border-left:5px solid #ccc;
    }
    .card-hadir{border-left-color:#28a745;}
    .card-sakit{border-left-color:#ffc107;}
    .card-izin{border-left-color:#0dcaf0;}
    .card-alpha{border-left-color:#dc3545;}
    .presensi-card .card-header{
        background:#1e88e5;color:#fff;font-size:13px;
        font-weight:600;padding:10px 12px;
    }
    .presensi-card .card-body{padding:12px;font-size:13px;}
}

@media print{img{display:none!important;}}
</style>

<h5 class="fw-bold mb-1 text-center">SISWA SMAN 1 CIKATOMAS</h5>
<p class="text-center text-muted mb-3">
    Tanggal: <?= !empty($tanggal) ? date('d-m-Y', strtotime($tanggal)) : date('d-m-Y') ?>
</p>

<form method="get" class="row g-2 mb-3 filter-box align-items-end">
    <div class="col-12 col-md-3">
        <label>Tanggal</label>
        <input type="date" id="filterTanggal" name="tanggal"
               value="<?= !empty($tanggal) ? $tanggal : date('Y-m-d') ?>"
               class="form-control">
    </div>

    <div class="col-12 col-md-3">
        <label>Kelas</label>
        <select name="kelas" class="form-select" onchange="this.form.submit()">
            <option value="">-- Semua Kelas --</option>
            <?php foreach ($kelas as $k): ?>
            <option value="<?= $k['id_kelas'] ?>"
                <?= $id_kelas==$k['id_kelas']?'selected':'' ?>>
                <?= $k['kelas'] ?>
            </option>
            <?php endforeach ?>
        </select>
    </div>
</form>

<button onclick="printLaporan()" class="btn btn-primary mb-3">
    <i class="fa fa-print"></i> Cetak Laporan
</button>

<div id="areaCetak">

<div class="legend-presensi">
    <div class="legend-item legend-alpha"><span class="legend-dot"></span> Alpha</div>
</div>

<?php
// Filter hanya siswa alpha
$alphaData = array_filter($data, function($r){
    return strtolower($r['kehadiran'] ?? 'alpha') === 'alpha';
});

// Hitung statistik
$jmlAlpha = count($alphaData);
$jmlDuhur = $jmlTidakDuhur = 0;
foreach($alphaData as $r){
    if(empty($r['jam_sholat']) || $r['jam_sholat']=='-') $jmlTidakDuhur++;
    else $jmlDuhur++;
}
$total = count($alphaData);
$namaKelas=!empty($alphaData) ? $alphaData[array_key_first($alphaData)]['kelas'] : 'Semua Kelas';
?>

<div class="alert alert-info py-2 mb-3">
    <!-- <b><?= $namaKelas ?></b> —  -->
    Alpha: <b class="text-danger"><?= $jmlAlpha ?></b> |
    <!-- Duhur: <b class="text-success"><?= $jmlDuhur ?></b>, -->
    <!-- Tidak Duhur: <b class="text-danger"><?= $jmlTidakDuhur ?></b> | -->
    <!-- Total: <b><?= $total ?></b> -->
</div>

<?php foreach($alphaData as $row):
$foto=!empty($row['foto'])
?base_url('uploads/siswa/'.$row['foto'])
:base_url('uploads/default.png');
?>

<div class="card presensi-card d-md-none card-alpha">
    <div class="card-header"><?= $row['nama_siswa'] ?> • <?= $row['kelas'] ?></div>
    <div class="card-body">
        <div class="d-flex align-items-center mb-3">
            <img src="<?= $foto ?>" class="foto-siswa me-3">
            <div>
                <div class="fw-semibold"><?= $row['nama_siswa'] ?></div>
                <small class="text-muted"><?= $row['nis'] ?> • <?= $row['jenis_kelamin'] ?></small>
            </div>
        </div>
        <!-- <div><b>Masuk:</b> <?= $row['jam_masuk'] ?? '-' ?></div>
        <div><b>Duhur:</b> <?= $row['jam_sholat'] ?? '-' ?></div> -->
        <!-- <div><b>Keluar:</b> <?= $row['jam_keluar'] ?? '-' ?></div> -->
        <span class="badge bg-danger mt-1">Alpha</span>
    </div>
</div>
<?php endforeach ?>

<div class="table-responsive">
<table class="table table-bordered table-striped align-middle">
<thead class="table-dark text-center">
<tr>
<th>No</th><th>Nama</th><th>JK</th><th>Kelas</th>
<!-- <th>Masuk</th><th>Duhur</th><th>Keluar</th> -->
<th>Status</th>
</tr>
</thead>
<tbody>
<?php $no=1; foreach($alphaData as $row): ?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= $row['nama_siswa'] ?></td>
<td class="text-center"><?= $row['jenis_kelamin'] ?></td>
<td class="text-center"><?= $row['kelas'] ?></td>
<!-- 
<td class="text-center <?= empty($row['jam_masuk']) || $row['jam_masuk']=='-' ? 'bg-absen' : '' ?>">
    <?= $row['jam_masuk'] ?? '-' ?>
</td>

<td class="text-center <?= empty($row['jam_sholat']) || $row['jam_sholat']=='-' ? 'bg-absen' : '' ?>">
    <?= $row['jam_sholat'] ?? '-' ?>
</td>

<td class="text-center <?= empty($row['jam_keluar']) || $row['jam_keluar']=='-' ? 'bg-absen' : '' ?>">
    <?= $row['jam_keluar'] ?? '-' ?>
</td> -->

<td class="text-center">
<span class="badge bg-danger">Alpha</span>
</td>
</tr>
<?php endforeach ?>
</tbody>
</table>
</div>

</div>

<script>
document.getElementById('filterTanggal').addEventListener('change',function(){
    this.form.submit();
});
function printLaporan(){
    let c=document.getElementById('areaCetak').innerHTML;
    let o=document.body.innerHTML;
    document.body.innerHTML=`<html><body>${c}</body></html>`;
    window.print();document.body.innerHTML=o;location.reload();
}
</script>

</div></div></div></div>

<?= $this->endSection() ?>
