<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content" style="background-color: #f8f9fa; min-height: 100vh;">
    <div class="container-fluid px-2 px-md-4">
        
        <div class="py-3 mb-3 border-bottom bg-white shadow-sm" style="border-radius: 10px; padding: 15px;">
            <h5 class="fw-bold mb-0 text-dark">
                <i class="fa fa-clipboard-list text-primary me-2"></i> REKAP KEHADIRAN SISWA
            </h5>
            <small class="text-muted">SMAN 1 CIKATOMAS</small>
        </div>

        <style>
            /* STYLE TOMBOL KELAS 2 KOLOM */
            .grid-filter-kelas { display: grid; grid-template-columns: 1fr 1fr; gap: 8px; }
            @media (min-width: 992px) { .grid-filter-kelas { grid-template-columns: repeat(6, 1fr); } }
            .radio-hidden { position: absolute; opacity: 0; pointer-events: none; }
            .btn-opsi-kelas { display: block; padding: 12px 5px; text-align: center; background: #fff; border: 2px solid #eee; border-radius: 10px; font-weight: 600; font-size: 13px; cursor: pointer; transition: 0.2s; color: #555; }
            .radio-hidden:checked + .btn-opsi-kelas { background: #007bff; color: #fff; border-color: #007bff; box-shadow: 0 4px 8px rgba(0,123,255,0.2); }

            /* STYLE CARD MOBILE */
            .foto-siswa-sm { width: 50px; height: 50px; border-radius: 50%; object-fit: cover; }
            @media (max-width: 768px) {
                .desktop-table { display: none; }
                .presensi-card { background: #fff; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.08); margin-bottom: 15px; overflow: hidden; border: none; }
                .status-strip { height: 5px; width: 100%; }
                .bg-hadir { background: #28a745; }
                .bg-sakit { background: #ffc107; }
                .bg-izin { background: #0dcaf0; }
                .bg-alpha { background: #dc3545; }
            }
            @media (min-width: 769px) { .mobile-cards { display: none; } }

            .jam-terlambat { color: #dc3545; font-weight: bold; } /* Jam masuk terlambat */
        </style>

<form method="get" id="mainFilterForm" class="mb-4">
    <div class="bg-white p-3 rounded shadow-sm border">
        <div class="row g-3">

            <!-- FILTER KELAS -->
            <div class="col-12 col-lg-6">
                <label class="form-label small fw-bold text-muted">PILIH UNIT KELAS</label>
                <div class="grid-filter-kelas">
                    <?php foreach ($kelas as $k): ?>
                    <div>
                        <input type="radio" name="kelas" id="kls-<?= $k['id_kelas'] ?>" value="<?= $k['id_kelas'] ?>" 
                               class="radio-hidden" <?= $id_kelas == $k['id_kelas'] ? 'checked' : '' ?> 
                               onchange="this.form.submit()">
                        <label for="kls-<?= $k['id_kelas'] ?>" class="btn-opsi-kelas shadow-sm"><?= $k['kelas'] ?></label>
                    </div>
                    <?php endforeach ?>
                </div>
            </div>

            <!-- FILTER TANGGAL -->
            <div class="col-12 col-lg-6">
                <label class="form-label small fw-bold text-muted">PILIH TANGGAL</label>
                <input type="date" name="tanggal" value="<?= $tanggal ?>" class="form-control" onchange="this.form.submit()">
            </div>

        </div>
    </div>
</form>


        <div id="areaCetak">
            <div class="text-center mb-4 d-none d-print-block">
                <h4 class="fw-bold mb-0">LAPORAN PRESENSI HARIAN</h4>
                <p>Tanggal: <?= date('d-m-Y', strtotime($tanggal)) ?></p>
            </div>

            <?php 
            $limitJam = '07:00'; // batas jam terlambat
            $sort = $_GET['sort'] ?? '';

            // SORTING DATA BERDASARKAN PILIHAN USER
            if($sort == 'terlambat'){
                usort($data, function($a, $b) use ($limitJam) {
                    $jamA = $a['jam_masuk'] ?? '00:00';
                    $jamB = $b['jam_masuk'] ?? '00:00';
                    $terlambatA = ($jamA > $limitJam) ? 1 : 0;
                    $terlambatB = ($jamB > $limitJam) ? 1 : 0;
                    if($terlambatA != $terlambatB) return $terlambatB <=> $terlambatA;
                    return strcmp($jamA, $jamB);
                });
            }
            elseif($sort == 'hadir'){
                usort($data, function($a, $b){
                    $statusA = strtolower($a['kehadiran'] ?? 'alpha');
                    $statusB = strtolower($b['kehadiran'] ?? 'alpha');
                    $order = ['hadir'=>1, 'izin'=>2, 'sakit'=>3, 'alpha'=>4];
                    return ($order[$statusA] ?? 5) <=> ($order[$statusB] ?? 5);
                });
            }
            // default = tidak diubah
            ?>

            <!-- SORT BUTTON DI ATAS TABEL -->
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0">DAFTAR SISWA</h5>
                <div style="width: 200px;">
                    <form method="get" id="sortForm">
                        <select name="sort" onchange="this.form.submit()" class="form-select form-select-sm">
                            <option value="">-- Urutkan --</option>
                            <option value="terlambat" <?= ($sort=='terlambat')?'selected':'' ?>>Terlambat Dulu</option>
                            <option value="hadir" <?= ($sort=='hadir')?'selected':'' ?>>Hadir Dulu</option>
                        </select>
                    </form>
                </div>
            </div>

            <!-- MOBILE CARDS -->
            <div class="mobile-cards">
                <?php foreach ($data as $row): ?>
                <?php 
                    $status = strtolower($row['kehadiran'] ?? 'alpha');
                    $colorClass = match($status){ 'hadir'=>'bg-hadir', 'sakit'=>'bg-sakit', 'izin'=>'bg-izin', default=>'bg-alpha' };
                    $foto = !empty($row['foto']) ? base_url('uploads/siswa/'.$row['foto']) : base_url('uploads/default.png');
                    $jamMasuk = $row['jam_masuk'] ?? '-';
                    $terlambat = ($jamMasuk > $limitJam);
                ?>
                <div class="presensi-card shadow-sm" <?= $terlambat ? 'style="border-left:4px solid #dc3545;"' : '' ?>>
                    <div class="status-strip <?= $colorClass ?>"></div>
                    <div class="p-3">
                        <div class="d-flex align-items-center mb-3">
                            <img src="<?= $foto ?>" class="foto-siswa-sm me-3 border">
                            <div style="flex: 1;">
                                <div class="fw-bold text-dark" style="font-size: 15px;"><?= $row['nama_siswa'] ?></div>
                                <div class="text-muted small"><?= $row['kelas'] ?> | <?= $row['jenis_kelamin'] ?></div>
                            </div>
                            <span class="badge <?= str_replace('bg-', 'bg-soft-', $colorClass) ?> text-uppercase shadow-sm" 
                                  style="background-color: <?= match($status){'hadir'=>'#28a745','sakit'=>'#ffc107','izin'=>'#0dcaf0',default=>'#dc3545'}; ?>; color: #fff;">
                                <?= $status ?>
                            </span>
                        </div>
                        <div class="row text-center g-2 py-2 bg-light rounded shadow-sm border mx-0">
                            <div class="col-4 border-end">
                                <small class="text-muted d-block" style="font-size: 10px;">MASUK</small>
                                <b class="small <?= $terlambat ? 'jam-terlambat' : '' ?>"><?= $jamMasuk ?></b>
                            </div>
                            <div class="col-4 border-end">
                                <small class="text-muted d-block" style="font-size: 10px;">DUHUR</small>
                                <b class="small"><?= $row['jam_sholat'] ?? '-' ?></b>
                            </div>
                            <div class="col-4">
                                <small class="text-muted d-block" style="font-size: 10px;">KELUAR</small>
                                <b class="small"><?= $row['jam_keluar'] ?? '-' ?></b>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach ?>
            </div>

<!-- REKAP EXCEL  -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="fw-bold mb-0">DAFTAR SISWA</h5>
    <div class="d-flex gap-2">
        <form method="get" id="sortForm">
            <select name="sort" onchange="this.form.submit()" class="form-select form-select-sm">
                <option value="">-- Urutkan --</option>
                <option value="terlambat" <?= ($sort=='terlambat')?'selected':'' ?>>Terlambat Dulu</option>
                <option value="hadir" <?= ($sort=='hadir')?'selected':'' ?>>Hadir Dulu</option>
            </select>
        </form>
        <!-- Tombol Export -->
        <form method="get" action="<?= base_url('admin/rekap/export') ?>">
            <input type="hidden" name="kelas" value="<?= $id_kelas ?>">
            <input type="hidden" name="tanggal" value="<?= $tanggal ?>">
            <button type="submit" class="btn btn-sm btn-success"><i class="fa fa-file-excel"></i> Export Excel</button>
        </form>
    </div>
</div>
<!-- REKAP EXCEL  -->


<form method="get" action="<?= base_url('admin/rekap/export') ?>">
    <input type="hidden" name="kelas" value="<?= $id_kelas ?>">
    <input type="hidden" name="tanggal" value="<?= $tanggal ?>">
    <button type="submit" class="btn btn-sm btn-success">Export Excel</button>
</form>



<a href="<?= base_url('admin/rekap/export?kelas='.$id_kelas.'&tanggal='.$tanggal) ?>"
   class="btn btn-success btn-sm">
   <i class="fa fa-file-excel"></i> Export Excel
</a>





            <!-- DESKTOP TABLE -->
            <div class="desktop-table bg-white rounded shadow-sm overflow-hidden">
                <table class="table table-hover table-bordered mb-0 align-middle text-center">
                    <thead class="table-dark">
                        <tr>
                            <th width="5%">No</th>
                            <th>Nama Lengkap</th>
                            <th width="5%">JK</th>
                            <th width="12%">Kelas</th>
                            <th width="10%">Masuk</th>
                            <th width="10%">Duhur</th>
                            <th width="10%">Keluar</th>
                            <th width="12%">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1; 
                        $countSakit = $countIzin = $countAlpha = 0; 
                        foreach ($data as $row): 
                            $status = $row['kehadiran'] ?? 'Alpha';
                            $jamMasuk = $row['jam_masuk'] ?? '-';
                            $terlambat = ($jamMasuk > $limitJam);
                            if(strtolower($status) == 'sakit') $countSakit++;
                            if(strtolower($status) == 'izin') $countIzin++;
                            if(strtolower($status) == 'alpha') $countAlpha++;
                            $badge = match($status){ 'Hadir'=>'success', 'Sakit'=>'warning text-dark', 'Izin'=>'info', default=>'danger' };
                        ?>
                        <tr>
                            <td class="text-center fw-bold"><?= $no++ ?></td>
                            <td><span class="fw-bold text-dark"><?= $row['nama_siswa'] ?></span></td>
                            <td class="text-center small"><?= $row['jenis_kelamin'] ?></td>
                            <td class="text-center fw-bold text-primary"><?= $row['kelas'] ?></td>
                            <td class="text-center font-monospace small <?= $terlambat ? 'jam-terlambat' : '' ?>"><?= $jamMasuk ?></td>
                            <td class="text-center font-monospace small"><?= $row['jam_sholat'] ?? '-' ?></td>
                            <td class="text-center font-monospace small"><?= $row['jam_keluar'] ?? '-' ?></td>
                            <td class="text-center">
                                <span class="badge bg-<?= $badge ?> w-100 py-2"><?= $status ?></span>
                            </td>
                        </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>

            <!-- TOTAL -->
            <?php $totalSiswa = count($data); $countHadir = $totalSiswa - ($countSakit + $countIzin + $countAlpha); ?>
            <div class="col-12 col-lg-12">
                <div class="total-kehadiran shadow-sm rounded-3 p-3 mt-4 bg-white text-center">
                    <h6 class="fw-bold mb-3 text-secondary">Total Kehadiran Siswa</h6>
                    <div class="d-flex flex-wrap justify-content-center gap-3">
                        <span class="badge total-badge bg-success text-white px-3 py-2 rounded-pill">Jumlah Siswa Terlambat : <?= $countHadir ?></span>
                        <!-- <span class="badge total-badge bg-warning text-dark px-3 py-2 rounded-pill">Sakit: <?= $countSakit ?></span>
                        <span class="badge total-badge bg-info text-dark px-3 py-2 rounded-pill">Izin: <?= $countIzin ?></span>
                        <span class="badge total-badge bg-danger text-white px-3 py-2 rounded-pill">Alpha: <?= $countAlpha ?></span>
                        <span class="badge total-badge bg-secondary text-white px-3 py-2 rounded-pill">Total Siswa: <?= $totalSiswa ?></span> -->
                    </div>
                </div>
            </div>

            <style>
                .total-kehadiran { border: 1px solid #e0e0e0; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
                .total-badge { font-size: 0.9rem; font-weight: 600; min-width: 90px; text-align: center; margin: 5px; }
                @media (max-width: 576px) { .total-badge { min-width: 70px; font-size: 0.8rem; padding: 0.35rem 0.75rem; margin: 4px; } }
            </style>

        </div>

    </div>
</div>
<?= $this->endSection() ?>
