<?= $this->extend('templates/starting_page_layout'); ?>

<?= $this->section('navaction') ?>
<?= $this->endSection() ?>

<?= $this->section('content'); ?>

<!-- FONT FORMAL -->
<link href="https://fonts.googleapis.com/css2?family=Source+Sans+3:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
/* ================= GLOBAL ================= */
body {
    background: linear-gradient(180deg, #207dee 0%, #f5f7fa 100%);
    font-family: 'Source Sans 3', system-ui, sans-serif;
    color: #ffffff;
}

/* ================= CARD ================= */
.card {
    background: #292159;
    border: 1px solid #dbe2ea;
    box-shadow: 0 6px 20px #292159;
    border-radius: 8px;
}

/* ================= HEADER ================= */
.card-header-primary {
    background: linear-gradient(135deg, #04bc94, #4c00ff) !important;    
    padding: 28px 20px 24px;
    border-radius: 8px 8px 0 0;
}

/* ================= LOGO ================= */
.login-logo {
    width: 78px;
    margin-bottom: 14px;
}

/* ================= TITLE ================= */
.card-header h4 {
    text-transform: uppercase;
    letter-spacing: 1.2px;
    font-weight: 600;
    color: #ff0000;
    font-size: 16px;
    margin-bottom: 6px;
}

.card-category {
    color: #d0ff01;
    font-size: 13px;
    letter-spacing: .3px;
}

/* ================= FORM ================= */
.form-control {
    background: #ffffff;
    border: 1px solid #cfd8dc;
    border-radius: 5px;
    padding: 11px 14px;
    font-size: 16px;
    color: #000000;
}

.form-control:focus {
    border-color: #616af6;
    box-shadow: 0 0 0 3px rgb(255, 255, 255);
}

/* ================= LABEL ================= */
.bmd-label-floating {
    color: #8034fa !important;
    font-size: 13px;
    font-weight: 600;
}

/* ================= BUTTON =================  WARNA TOMBOL */
.btn-primary {
    background: linear-gradient(135deg, #1e0582, #41108a9a);
    border: none;
    font-weight: 600;
    letter-spacing: .8px;
    border-radius: 5px;
    padding: 12px;
    text-transform: uppercase;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #7111f7, #f55d0c);
}

/* ================= CHECKBOX & LINK ================= */
.form-check-label {
    font-size: 13px;
    color: #ffffff;
}

a {
    color: #0d47a1;
    font-size: 13px;
    font-weight: 600;
}

a:hover {
    color: #08306b;
    text-decoration: underline;
}

/* ================= ALERT ================= */
.alert {
    font-size: 13px;
    border-radius: 5px;
}

/* ================= ICON ================= */
.material-icons {
    vertical-align: middle;
    font-size: 20px;
}
</style>

<div class="main-panel">
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-4 m-auto">
                    <div class="card">
                        <div class="card-header card-header-primary text-center">

                            <!-- LOGO -->
                            <img src="<?= base_url('public/assets/img/logo.png'); ?>"
                                 alt="Logo Sekolah"
                                 class="login-logo">

                            <h4 class="card-title">
                                <i class="material-icons">security</i>
                                ACCESS LOGIN
                            </h4>
                            <p class="card-category">
                                AUTHORIZATION REQUIRED
                            </p>
                        </div>

                        <div class="card-body mx-4 my-3">
                            <?= view('\App\Views\admin\_message_block') ?>

                            <form action="<?= url_to('login') ?>" method="post">
                                <?= csrf_field() ?>

                                <div class="form-group">
                                    <label class="bmd-label-floating">
                                        <?= lang('Auth.emailOrUsername') ?>
                                    </label>
                                    <input type="text"
                                           name="login"
                                           class="form-control <?= session('errors.login') ? 'is-invalid' : '' ?>"
                                           autofocus>
                                    <div class="invalid-feedback">
                                        <?= session('errors.login') ?>
                                    </div>
                                </div>

                                <div class="form-group mt-3">
                                    <label class="bmd-label-floating">PASSWORD</label>
                                    <input type="password"
                                           name="password"
                                           class="form-control <?= session('errors.password') ? 'is-invalid' : '' ?>">
                                    <div class="invalid-feedback">
                                        <?= session('errors.password') ?>
                                    </div>
                                </div>

                                <?php if ($config->allowRemembering) : ?>
                                    <div class="form-check mt-3">
                                        <label class="form-check-label">
                                            <input type="checkbox" name="remember" class="form-check-input">
                                            REMEMBER ACCESS
                                        </label>
                                    </div>
                                <?php endif; ?>

                                <button type="submit" class="btn btn-primary btn-block mt-4">
                                    LOGIN SYSTEM
                                </button>

                                <?php if ($config->activeResetter) : ?>
                                    <p class="mt-3 text-center">
                                        <a href="<?= url_to('forgot') ?>">
                                            FORGOT PASSWORD?
                                        </a>
                                    </p>
                                <?php endif; ?>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>
