<?php
$totalSiswa = 0;
$persentaseHadir = 0;

if (isset($jumlahKehadiranSiswa)) {

    $hadir = $jumlahKehadiranSiswa['hadir'] ?? 0;
    $sakit = $jumlahKehadiranSiswa['sakit'] ?? 0;
    $izin  = $jumlahKehadiranSiswa['izin'] ?? 0;
    $alfa  = $jumlahKehadiranSiswa['alfa'] ?? 0;

    $totalSiswa = $hadir + $sakit + $izin + $alfa;

    if ($totalSiswa > 0) {
        $persentaseHadir = round(($hadir / $totalSiswa) * 100, 1);
    }
}
?>

<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
    :root {
        --card-radius: 1rem;
        --card-shadow: 0 6px 12px rgba(0,0,0,0.12);
        --card-hover-shadow: 0 14px 28px rgba(0,0,0,0.2);
    }


    .stat-icon{
    font-size: 80px;   /* 🔥 dari default jadi besar */
    opacity: .9;
    margin: 12px 0;
}



    /* ================= CARD GRID ================= */
    .row-cards {
        display: flex;
        flex-wrap: wrap;
        gap: 1rem;
        justify-content: center;
    }

    /* 5 CARD PER BARIS (DESKTOP) */
    .col-5 {
        flex: 0 0 20%;
        max-width: 20%;
    }

    /* RESPONSIVE */
    @media (max-width: 991px) {
        .col-5 { flex: 0 0 33.333%; max-width: 33.333%; }
    }
    @media (max-width: 575px) {
        .col-5 { flex: 0 0 100%; max-width: 100%; }
    }

    /* ================= CARD STYLE ================= */
    .stat-card {
        border-radius: var(--card-radius);
        box-shadow: var(--card-shadow);
        transition: .3s ease;
        min-height: 230px;
        text-align: center;
        color: #ffffff;
        cursor: pointer;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }
    .stat-card:hover {
        transform: translateY(-6px) scale(1.03);
        box-shadow: var(--card-hover-shadow);
    }

    /* HEADER */
    .stat-header {
        font-weight: 600;
        font-size: clamp(1rem, 1.2vw, 1.25rem);
        padding: .8rem;
    }

    /* ICON AUTO SCALE */
    .stat-icon {
        font-size: clamp(3rem, 5vw, 4.5rem);
        opacity: .9;
    }

    /* FOOTER */
    .stat-footer {
        padding: .6rem;
        font-size: clamp(.85rem, 1vw, 1rem);
        background: rgba(255,255,255,.12);
    }
</style>

<div class="content">
<div class="container-fluid">

<!-- ================= HEADER ================= -->
<div class="card mb-4 border-info text-center">
    <div class="card-header bg-info text-white">
        <h4 class="mb-0 fw-bold">📊 Persentase Kehadiran</h4>
    </div>
</div>





<?php
if ($persentaseHadir >= 90) {
    $warnaCard = 'linear-gradient(135deg, #28a745, #1e7e34)'; // Hijau
    $icon = 'verified';
} elseif ($persentaseHadir >= 75) {
    $warnaCard = 'linear-gradient(135deg, #0d6efd, #084298)'; // Biru
    $icon = 'trending_up';
} elseif ($persentaseHadir >= 60) {
    $warnaCard = 'linear-gradient(135deg, #ffc107, #e0a800)'; // Kuning
    $icon = 'warning';
} else {
    $warnaCard = 'linear-gradient(135deg, #dc3545, #b02a37)'; // Merah
    $icon = 'error';
}
?>


<!-- ========================================================= -->
<!-- 📈 PERSENTASE KEHADIRAN (HORIZONTAL) -->
<!-- ========================================================= -->
<div class="row mb-3">
    <div class="col-12">
        <div class="card text-white shadow-lg hover-card animated-card"
             style="background: <?= $warnaCard ?>;">
            <div class="card-body d-flex justify-content-between align-items-center"
                 style="min-height:160px;">

                <!-- TEXT KIRI -->
                <div>
                    <h3 class="fw-extra-bold mb-2 animated-title" style="font-size:1.8rem;">
                        📈 Persentase Kehadiran Hari Ini
                    </h3>

                    <h1 class="fw-extra-bold mb-1" style="font-size:3rem;">
    <span id="livePersen"><?= $persentaseHadir ?></span>%
</h1>

<p class="mb-0 opacity-75">
    <span id="liveHadir"><?= $jumlahKehadiranSiswa['hadir'] ?></span>
    dari
    <span id="liveTotal"><?= $totalSiswa ?></span>
    siswa hadir hari ini
</p>
                </div>

                <!-- ICON KANAN -->
                <i class="material-icons d-none d-md-block animated-icon"
                   style="font-size:90px; opacity:.25;">
                    <?= $icon ?>
                </i>

            </div>
        </div>
    </div>
</div>









        <!-- ================= CARD MENU ================= -->
    <div class="row-cards">

            <!-- CARD 1 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg, #265ae8, #a331ef);">
                    <div class="stat-header">Persentase Kehadiran Siswa</div>
                    <div><i class="material-icons stat-icon">menu_book</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Rekap kehadiran harian, mingguan, dan bulanan
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 2 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/tren-harian'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg, #111190, #198754);">
                    <div class="stat-header">Persentase Kehadiran Tren Harian</div>
                    <div><i class="material-icons stat-icon">login</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Persentase kehadiran siswa per tanggal selama 1 bulan
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 3 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/kelas-terbaik-solat'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg, #17a2b8, #138496);">
                    <div class="stat-header">Kelas Terbaik Solat Duhur</div>
                    <div><i class="material-icons stat-icon">mosque</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Persentase kehadiran solat duhur tiap kelas
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 4 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/kelas-terbaik'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg,#dc3545,#b02a37);">
                    <div class="stat-header">Kelas Terbaik Berdasarkan Kehadiran</div>
                    <div><i class="material-icons stat-icon">logout</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Persentase kehadiran tiap kelas dari tertinggi
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 5 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/kelas-paling-telat'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg,#ffc107,#e0a800);">
                    <div class="stat-header">Kelas Paling Banyak Kesiangan</div>
                    <div><i class="material-icons stat-icon">assignment</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Persentase siswa telat masuk tiap kelas
                    </div>
                </div>
            </a>
            </div>


            <!-- CARD 6 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/kelas-paling-alpa'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg,#eb17c1,#f52656);">
                    <div class="stat-header">Kelas Paling Banyak Alpa</div>
                    <div><i class="material-icons stat-icon">menu_book</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Persentase siswa alpa tiap kelas
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 7 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/perbandingan-siswa'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg,#111190,#198754);">
                    <div class="stat-header">Perbandingan Antar Siswa</div>
                    <div><i class="material-icons stat-icon">login</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Persentase kehadiran tiap siswa dalam kelas
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 8 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/perbandingan-siswa-sekolah'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg,#17a2b8,#138496);">
                    <div class="stat-header">Perbandingan Antar Siswa Seluruh Sekolah</div>
                    <div><i class="material-icons stat-icon">mosque</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Persentase kehadiran tiap siswa dari seluruh sekolah
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 9 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/perbandingan-kelas'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg,#dc3545,#b02a37);">
                    <div class="stat-header">Perbandingan Antar Kelas</div>
                    <div><i class="material-icons stat-icon">logout</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Melihat kelas dengan kehadiran terendah hingga tertinggi
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 10 -->
            <div class="col-5">
            <a href="<?= base_url('admin/persentase/perbandingan-sekolah'); ?>" class="text-white">
                <div class="stat-card" style="background:linear-gradient(135deg,#ffc107,#e0a800);">
                    <div class="stat-header">Perbandingan Kehadiran Sekolah</div>
                    <div><i class="material-icons stat-icon">assignment</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Persentase kehadiran seluruh siswa per hari
                    </div>
                </div>
            </a>
            </div>

            <!-- CARD 11 -->
            <div class="col-5">
                <a href="<?= base_url('admin/developer'); ?>" class="text-white text-decoration-none">
                    <div class="stat-card" style="background:linear-gradient(135deg,#111190,#198754);">
                        
                        <div class="stat-header">
                            SISWA TERCANTIK
                        </div>

                        <div>
                            <i class="material-icons stat-icon" style="font-size:56px;">
                                login
                            </i>
                        </div>

                        <div class="stat-footer">
                            <i class="material-icons">qr_code_scanner</i>
                            Perbandingan Siswa Tercantik <br>
                            <small>By : Gilang Bujang</small>
                        </div>

                    </div>
                </a>
            </div>


            <!-- CARD 12 -->
            <div class="col-5">
            <!-- <a href="<?= base_url('admin/absen-siswa'); ?>" class="text-white"> -->
                <a href="<?= base_url('admin/developer'); ?>" class="text-white text-decoration-none">

                <div class="stat-card" style="background:linear-gradient(135deg,#eb17c1,#f52656);">
                    <div class="stat-header">Gemul Dahar MBG</div>
                    <div><i class="material-icons stat-icon">menu_book</i></div>
                    <div class="stat-footer">
                        <i class="material-icons">qr_code_scanner</i> Siswa Nu Gemul Dahar MBG
                    </div>
                </div>
            </a>
            </div>

    </div>
<!-- ---------------------------------------- -->

</div>
</div>





<script>
function loadLivePersentase() {
    fetch("<?= base_url('admin/live-persentase') ?>")
        .then(res => res.json())
        .then(data => {
            document.getElementById('livePersen').innerText = data.persentase;
            document.getElementById('liveHadir').innerText = data.hadir;
            document.getElementById('liveTotal').innerText = data.total;
        })
        .catch(err => console.error(err));
}

// refresh tiap 5 detik
setInterval(loadLivePersentase, 5000);

// load pertama
loadLivePersentase();
</script>

<?= $this->endSection() ?>
