<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
:root {
    --primary: #0d6efd;
    --danger: #dc3545;
    --card-radius: 1.2rem;
    --card-shadow: 0 8px 18px rgba(0,0,0,0.15);
    --card-hover-shadow: 0 14px 30px rgba(0,0,0,0.25);
}

/* CARD MENU SAJA */
.menu-card {
    border-radius: var(--card-radius);
    transition: all 0.3s ease;
    box-shadow: var(--card-shadow);
    min-height: 320px;
}

.menu-card:hover {
    transform: translateY(-6px);
    box-shadow: var(--card-hover-shadow);
}

.card-icon i {
    font-size: 5rem;
}



:root {
    --menu-header-bg: #0d6efd;     /* Warna background */
    --menu-header-text: #ffffff;   /* Warna teks */
    --menu-header-radius: 12px;    /* Atur rounded di sini */
}

/* Header khusus */
.card .bg-primary.text-white {
    background-color: var(--menu-header-bg) !important;
    color: var(--menu-header-text) !important;
    border-top-left-radius: var(--menu-header-radius) !important;
    border-top-right-radius: var(--menu-header-radius) !important;
}



</style>

<div class="content">
    <div class="container-fluid">

        <!-- CARD INFORMASI (TIPIS) -->
<div class="card mb-4 border-0 shadow-sm text-center">

    <!-- HEADER BIRU -->
    <div class="bg-primary text-white py-3 rounded-top">
        <h4 class="fw-bold mb-0">MENU PIKET</h4>
    </div>

    <!-- DESKRIPSI -->
    <div class="card-body py-3">
        <small class="text-muted">
            Kelola surat izin & pelanggaran siswa
        </small>
    </div>

</div>




        <!-- MENU GRID -->
        <div class="row g-4">

            <!-- SURAT IZIN -->
            <div class="col-lg-4 col-md-6">
                <a href="<?= base_url('admin/piket/suratizin'); ?>" class="text-decoration-none">
                    <div class="card menu-card text-white" style="background: linear-gradient(135deg,#0d6efd,#084298);">
                        <div class="card-body text-center">
                            <div class="card-icon mb-3">
                                <i class="material-icons">description</i>
                            </div>
                            <h4 class="fw-bold">Surat Izin</h4>
                            <p class="mb-0">
                                Data siswa izin, sakit, dan keperluan khusus
                            </p>
                        </div>
                    </div>
                </a>
            </div>

            <!-- CATATAN PELANGGARAN -->
            <div class="col-lg-4 col-md-6">
                <a href="<?= base_url('admin/pelanggaran'); ?>" class="text-decoration-none">
                    <div class="card menu-card text-white" style="background: linear-gradient(135deg,#dc3545,#842029);">
                        <div class="card-body text-center">
                            <div class="card-icon mb-3">
                                <i class="material-icons">warning</i>
                            </div>
                            <h4 class="fw-bold">Catatan Pelanggaran</h4>
                            <p class="mb-0">
                                Pencatatan pelanggaran dan kedisiplinan siswa
                            </p>
                        </div>
                    </div>
                </a>
            </div>

        </div>

    </div>
</div>

<?= $this->endSection() ?>
