<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ====================== BRANDING ====================== */
:root {
    --primary: #0d6efd;
    --info: #17a2b8;
    --success: #28a745;
    --danger: #dc3545;
    --card-radius: 1rem;
    --card-shadow: 0 6px 12px rgba(0,0,0,0.1);
    --card-hover-shadow: 0 12px 25px rgba(0,0,0,0.15);
}

/* CARD UMUM */
.card {
    border-radius: var(--card-radius);
    transition: all 0.3s ease;
    box-shadow: var(--card-shadow);
    overflow: hidden;
    cursor: pointer;
    min-height: 300px; /* Tinggi card diperbesar */
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}
.card:hover {
    transform: translateY(-5px) scale(1.02);
    box-shadow: var(--card-hover-shadow);
}

/* CARD HEADER */
.card-header {
    border-bottom: none;
    font-weight: 600;
    text-align: center;
    font-size: 1.2rem;
    padding: 1rem 0;
}

/* CARD ICON */
.card-icon {
    font-size: 6rem; /* ikon diperbesar */
    margin-bottom: 15px;
}

/* MATERIAL ICON CUSTOM CLASS */
.material-icons.qr-icon {
    font-size: 6rem; /* ikon scan barcode besar */
}

.card-footer {
    background: rgba(255,255,255,0.1);
    text-align: center;
    font-size: 1rem;
    color: #fff;
    padding: 0.75rem 0;
}

/* FLEX GAP UNTUK ROW CARD */
.row-gap {
    display: flex;
    flex-wrap: wrap;
    gap: 2rem; /* jarak antar card */
    justify-content: center;
}

/* RESPONSIVE */
@media (max-width: 991.98px) {
    .card-icon, .material-icons.qr-icon {
        font-size: 5rem;
    }
    .card { min-height: 260px; }
}

@media (max-width: 575.98px) {
    .card-icon, .material-icons.qr-icon {
        font-size: 4rem;
    }
    .card { min-height: 220px; }
}
</style>

<div class="content">
    <div class="container-fluid">

        <!-- BARIS 1: INFORMASI PENTING -->
        <div class="card mb-4 shadow-sm border-info text-center">
            <div class="card-header bg-info text-white">
                <h4 class="card-title mb-0"><strong>PENTING! BACA TERLEBIH DAHULU</strong></h4>
            </div>
            <div class="card-body">
                <h5><strong>Pastikan memilih menu dengan benar agar data presensi tercatat akurat 👍</strong></h5>
                




                        <div class="text-start mt-2">

                            <div class="d-flex align-items-start mb-2">
                                <i class="material-icons text-primary me-2" style="font-size:20px;">check_circle</i>
                                <p class="text-muted mb-0">
                                    <strong>1️⃣ Absen Manual</strong> <strong> ⚡ Manual Input </strong>
                                </p>
                            </div>

                            <div class="d-flex align-items-start mb-2">
                                <i class="material-icons text-primary me-2" style="font-size:20px;">check_circle</i>
                                <p class="text-muted mb-0">
                                    <strong>2️⃣ Absen Duhur QRCODE</strong> ⚡ Auto Input
                                </p>
                            </div>

                            <div class="d-flex align-items-start mb-2">
                                <i class="material-icons text-primary me-2" style="font-size:20px;">check_circle</i>
                                <p class="text-muted mb-0">
                                    <strong>3️⃣ Absen Pulang QRCODE</strong> ⚡ Auto Input
                                </p>
                            </div>


                            <div class="d-flex align-items-start mb-2">
                                <i class="material-icons text-primary me-2" style="font-size:20px;">check_circle</i>
                                <p class="text-muted mb-0">
                                    <strong>4️⃣ Absen Izin QRCODE</strong> ⚡ Auto Input
                                </p>
                            </div>

                        </div>
















            </div>
        </div>

        <!-- BARIS 2: CARD SCAN ABSENSI -->
        <div class="row-gap">



            <!-- Absen Tambahan (Opsional) -->
            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="card text-white" style="background: linear-gradient(135deg, #eb17c1, #f52656);">
                    <div class="card-header text-center">
                        <div class="card-icon">
                            <a href="<?= base_url('admin/absen-siswa'); ?>" class="text-white">
                                <i class="material-icons qr-icon">menu_book</i>
                            </a>
                        </div>
                        <p class="mb-0">Absen Manual Siswa</p>
                    </div>
                    <div class="card-footer">
                        <i class="material-icons">edit</i>
                        Absensi Manual
                    </div>
                </div>
            </div>





            <!-- Absen Masuk -->
            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="card text-white" style="background: linear-gradient(135deg, #111190, #198754);">
                    <div class="card-header text-center">
                        <div class="card-icon">
                            <a href="<?= base_url('scan/masuk'); ?>" class="text-white">
                                <i class="material-icons qr-icon">qr_code_scanner</i>
                            </a>
                        </div>
                        <p class="mb-0">Absen Masuk</p>
                    </div>
                    <div class="card-footer">
                        <i class="material-icons text-success">qr_code_scanner</i>
                        Aplikasi Scan Datang
                    </div>
                </div>
            </div>

            <!-- Absen Duhur -->
            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="card text-white" style="background: linear-gradient(135deg, #17a2b8, #138496);">
                    <div class="card-header text-center">
                        <div class="card-icon">
                            <a href="<?= base_url('scan/duhur'); ?>" class="text-white">
                                <i class="material-icons qr-icon">qr_code_scanner</i>
                            </a>
                        </div>
                        <p class="mb-0">Absen Duhur</p>
                    </div>
                    <div class="card-footer">
                        <i class="material-icons">qr_code_scanner</i>
                        Aplikasi Scan Solat Duhur
                    </div>
                </div>
            </div>

            <!-- Absen Pulang -->
            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="card text-white" style="background: linear-gradient(135deg, #dc3545, #b02a37);">
                    <div class="card-header text-center">
                        <div class="card-icon">
                            <a href="<?= base_url('scan/pulang'); ?>" class="text-white">
                                <i class="material-icons qr-icon">qr_code_scanner</i>
                            </a>
                        </div>
                        <p class="mb-0">Absen Pulang</p>
                    </div>
                    <div class="card-footer">
                        <i class="material-icons">qr_code_scanner</i>
                        Aplikasi Scan Pulang
                    </div>
                </div>
            </div>




            <!-- Absen Tambahan (Opsional) -->
            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="card text-white" style="background: linear-gradient(135deg, #ffc107, #e0a800);">
                    <div class="card-header text-center">
                        <div class="card-icon">
                            <a href="<?= base_url('scan/izin'); ?>" class="text-white">
                                <i class="material-icons qr-icon">qr_code_scanner</i>
                            </a>
                        </div>
                        <p class="mb-0">Absen IZIN Keluar</p>
                    </div>
                    <div class="card-footer">
                        <i class="material-icons">qr_code_scanner</i>
                        Aplikasi Scan Lain
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>

<?= $this->endSection() ?>
