<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ====================== BRANDING ====================== */
:root {
    --primary: #0d6efd;
    --info: #17a2b8;
    --success: #28a745;
    --warning: #ffc107;
    --card-radius: 1rem;
    --card-shadow: 0 6px 12px rgba(0,0,0,0.1);
    --card-hover-shadow: 0 12px 25px rgba(0,0,0,0.15);
}

/* CARD UMUM */
.card {
    border-radius: var(--card-radius);
    transition: all 0.3s ease;
    box-shadow: var(--card-shadow);
    cursor: pointer;
    min-height: 280px;
}
.card:hover {
    transform: translateY(-5px);
    box-shadow: var(--card-hover-shadow);
}

/* CARD ICON */
.card-icon i {
    font-size: 5rem;
}

/* FLEX GAP */
.row-gap {
    display: flex;
    flex-wrap: wrap;
    gap: 2rem;
    justify-content: center;
}
</style>

<div class="content">
    <div class="container-fluid">

        <!-- INFORMASI -->
        <div class="card mb-4 border-info text-center">
            <div class="card-header bg-info text-white">
                <h4 class="mb-0"><strong>MENU KEHADIRAN SISWA</strong></h4>
            </div>
            <div class="card-body">
                <p class="mb-0 text-muted">
                    Pilih jenis rekap laporan kehadiran sesuai kebutuhan (Harian, Mingguan, atau Bulanan)
                </p>
            </div>
        </div>

        <!-- MENU REKAP KEHADIRAN -->
        <div class="row-gap">

            <!-- Rekap Harian -->
            <div class="col-lg-3 col-md-6 col-sm-6">
                <a href="<?= base_url('admin/lap/lapharian?kelas=&tanggal='); ?>" class="text-decoration-none">
                    <div class="card text-white" style="background: linear-gradient(135deg,#0d6efd,#0b5ed7);">
                        <div class="card-body text-center">
                            <div class="card-icon mb-3">
                                <i class="material-icons">today</i>
                            </div>
                            <h5 class="fw-bold">Rekap Harian</h5>
                            <p class="mb-0">Laporan kehadiran per hari</p>
                        </div>
                        <div class="card-footer text-center">
                            <i class="material-icons">event</i> Lihat Data
                        </div>
                    </div>
                </a>
            </div>

            <!-- Rekap Mingguan -->
            <div class="col-lg-3 col-md-6 col-sm-6">
                <a href="<?= base_url('admin/lap/lapmingguan?kelas=&tanggal='); ?>" class="text-decoration-none">
                    <div class="card text-white" style="background: linear-gradient(135deg,#28a745,#1e7e34);">
                        <div class="card-body text-center">
                            <div class="card-icon mb-3">
                                <i class="material-icons">date_range</i>
                            </div>
                            <h5 class="fw-bold">Rekap Mingguan</h5>
                            <p class="mb-0">Laporan kehadiran per minggu</p>
                        </div>
                        <div class="card-footer text-center">
                            <i class="material-icons">view_week</i> Lihat Data
                        </div>
                    </div>
                </a>
            </div>

            <!-- Rekap Bulanan -->
            <div class="col-lg-3 col-md-6 col-sm-6">
                <a href="<?= base_url('admin/kehadiran/rekapbulanan'); ?>" class="text-decoration-none">
                    <div class="card text-white" style="background: linear-gradient(135deg,#ffc107,#e0a800);">
                        <div class="card-body text-center">
                            <div class="card-icon mb-3">
                                <i class="material-icons">calendar_month</i>
                            </div>
                            <h5 class="fw-bold">Rekap Bulanan</h5>
                            <p class="mb-0">Laporan kehadiran per bulan</p>
                        </div>
                        <div class="card-footer text-center">
                            <i class="material-icons">assessment</i> Lihat Data
                        </div>
                    </div>
                </a>
            </div>

<!-- Rekap List Tanggal Bulanan -->
<div class="col-lg-3 col-md-6 col-sm-6">
    <a href="<?= base_url('admin/lap/lapbulananhadir'); ?>" class="text-decoration-none">
        <div class="card text-white" style="background: linear-gradient(135deg,#17a2b8,#117a8b);">
            <div class="card-body text-center">
                <div class="card-icon mb-3">
                    <i class="material-icons">view_day</i>
                </div>
                <h5 class="fw-bold">List Bulanan</h5>
                <p class="mb-0">Daftar tanggal dari 1 sampai akhir bulan</p>
            </div>
            <div class="card-footer text-center">
                <i class="material-icons">calendar_view_month</i> Lihat Data
            </div>
        </div>
    </a>
</div>







        </div>

    </div>
</div>

<?= $this->endSection() ?>
