<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

<!-- ================= CARD HEADER ================= -->
<div class="card mb-4 shadow-sm">
    <div class="card-header card-header-primary d-flex align-items-center">
        <i class="material-icons me-2">menu</i>
        <h4 class="mb-0"><b><?= esc($title) ?></b></h4>
    </div>
    <div class="card-body">

        <!-- Flashdata -->
        <?php if(session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= session()->getFlashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        <?php if(session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= session()->getFlashdata('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Tombol Tambah Menu -->
        <div class="mb-3 text-end">
            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addMenuModal">
                <i class="material-icons">add</i> Tambah Menu
            </button>
        </div>

        <!-- ================= TABEL MENU ================= -->
        <div class="table-responsive">
            <table class="table table-striped table-hover table-bordered align-middle text-center mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Label</th>
                        <th>Icon</th>
                        <th>URL</th>
                        <th>Roles</th>
                        <th>Urutan</th>
                        <th>Aktif</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!empty($menus)): ?>
                        <?php foreach($menus as $menu): ?>
                        <tr class="menu-item" data-id="<?= $menu['id'] ?>">
                            <td><?= $menu['id'] ?></td>
                            <td><?= esc($menu['label']) ?></td>
                            <td><i class="material-icons fs-5"><?= esc($menu['icon']) ?></i></td>
                            <td><?= esc($menu['url']) ?></td>
                            <td><?= esc($menu['roles']) ?></td>
                            <td><?= esc($menu['urutan']) ?></td>
                            <td><?= $menu['is_active'] ? 'Ya' : 'Tidak' ?></td>
                            <td class="text-center">
                                <button class="btn btn-sm btn-warning editBtn"
                                    data-id="<?= $menu['id'] ?>"
                                    data-label="<?= esc($menu['label']) ?>"
                                    data-icon="<?= esc($menu['icon']) ?>"
                                    data-url="<?= esc($menu['url']) ?>"
                                    data-ctx="<?= esc($menu['ctx']) ?>"
                                    data-roles="<?= esc($menu['roles']) ?>"
                                    data-urutan="<?= esc($menu['urutan']) ?>"
                                    data-sidebar_color="<?= esc($menu['sidebar_color']) ?>"
                                    data-is_active="<?= $menu['is_active'] ?>"
                                >
                                    <i class="material-icons">edit</i>
                                </button>
                                <button class="btn btn-sm btn-danger deleteBtn"
                                    data-id="<?= $menu['id'] ?>"
                                    data-label="<?= esc($menu['label']) ?>"
                                >
                                    <i class="material-icons">delete</i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8" class="text-center">Belum ada menu</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

    </div>
</div>

</div>
</div>
</div>
</div>

<!-- ================= MODAL TAMBAH MENU ================= -->
<div class="modal fade" id="addMenuModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form action="<?= base_url('admin/menus/store') ?>" method="post">
      <div class="modal-content">
        <div class="modal-header bg-success text-white">
          <h5 class="modal-title">Tambah Menu</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
            <div class="mb-2"><input type="text" name="label" class="form-control" placeholder="Label" required></div>
            <div class="mb-2"><input type="text" name="icon" class="form-control" placeholder="Icon" required></div>
            <div class="mb-2"><input type="text" name="url" class="form-control" placeholder="URL" required></div>
            <div class="mb-2"><input type="text" name="ctx" class="form-control" placeholder="Context (ctx)" required></div>
            <div class="mb-2"><input type="text" name="urutan" class="form-control" placeholder="Urutan"></div>
            <div class="mb-2"><input type="text" name="roles" class="form-control" placeholder="Roles (1,2,3)"></div>
            <div class="mb-2"><input type="text" name="sidebar_color" class="form-control" placeholder="Sidebar Color"></div>
            <div class="mb-2">
                <select name="is_active" class="form-select">
                    <option value="1">Aktif</option>
                    <option value="0">Tidak Aktif</option>
                </select>
            </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success w-100">Simpan</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- ================= MODAL EDIT MENU ================= -->
<div class="modal fade" id="editMenuModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form id="editMenuForm" method="post">
      <div class="modal-content">
        <div class="modal-header bg-warning text-dark">
          <h5 class="modal-title">Edit Menu</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
            <div class="mb-2"><input type="text" name="label" class="form-control" placeholder="Label" required></div>
            <div class="mb-2"><input type="text" name="icon" class="form-control" placeholder="Icon" required></div>
            <div class="mb-2"><input type="text" name="url" class="form-control" placeholder="URL" required></div>
            <div class="mb-2"><input type="text" name="ctx" class="form-control" placeholder="Context (ctx)" required></div>
            <div class="mb-2"><input type="text" name="urutan" class="form-control" placeholder="Urutan"></div>
            <div class="mb-2"><input type="text" name="roles" class="form-control" placeholder="Roles (1,2,3)"></div>
            <div class="mb-2"><input type="text" name="sidebar_color" class="form-control" placeholder="Sidebar Color"></div>
            <div class="mb-2">
                <select name="is_active" class="form-select">
                    <option value="1">Aktif</option>
                    <option value="0">Tidak Aktif</option>
                </select>
            </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-warning w-100">Simpan Perubahan</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- ================= JS EDIT & DELETE ================= -->
<script>
document.addEventListener("DOMContentLoaded", function(){

    // Edit Menu
    const editButtons = document.querySelectorAll('.editBtn');
    const editForm = document.getElementById('editMenuForm');
    const editModal = new bootstrap.Modal(document.getElementById('editMenuModal'));
    editButtons.forEach(btn => {
        btn.addEventListener('click', function(e){
            e.preventDefault();
            editForm.action = '<?= base_url('admin/menus/update') ?>/' + this.dataset.id;
            editForm.label.value = this.dataset.label;
            editForm.icon.value = this.dataset.icon;
            editForm.url.value = this.dataset.url;
            editForm.ctx.value = this.dataset.ctx;
            editForm.roles.value = this.dataset.roles;
            editForm.urutan.value = this.dataset.urutan;
            editForm.sidebar_color.value = this.dataset.sidebar_color;
            editForm.is_active.value = this.dataset.is_active;
            editModal.show();
        });
    });

    // Delete Menu
    const deleteButtons = document.querySelectorAll('.deleteBtn');
    deleteButtons.forEach(btn => {
        btn.addEventListener('click', function(){
            if(confirm(`Yakin ingin menghapus menu "${this.dataset.label}"?`)){
                window.location.href = '<?= base_url('admin/menus/delete') ?>/' + this.dataset.id;
            }
        });
    });

});
</script>

<?= $this->endSection() ?>
