<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
:root {
    --card-radius: 1rem;
    --card-shadow: 0 6px 18px rgba(0,0,0,0.12);
    --card-hover-shadow: 0 14px 28px rgba(0,0,0,0.2);
}

/* ================= HEADER ================= */
.menu-header {
    border-radius: var(--card-radius);
    box-shadow: var(--card-shadow);
}

/* ================= CARD WRAPPER (JARAK) ================= */
.card-wrapper {
    margin-bottom: 1.5rem; /* JARAK ANTAR CARD ATAS-BAWAH */
}

/* ================= CARD STYLE ================= */
.setting-card {
    border-radius: var(--card-radius);
    transition: 0.3s ease;
    box-shadow: var(--card-shadow);
    height: 100%;
    color: white;
}

.setting-card:hover {
    transform: translateY(-6px);
    box-shadow: var(--card-hover-shadow);
}

.setting-card .card-body {
    padding: 3rem 1.5rem;
}

.setting-icon i {
    font-size: 5rem;
    margin-bottom: 1rem;
}
</style>

<div class="content">
    <div class="container-fluid">

        <!-- ================= HEADER ================= -->
        <div class="card mb-4 border-0 menu-header">
            <div class="card-body text-center bg-dark text-white rounded">
                <h4 class="mb-2 fw-bold">MENU PENGATURAN SISTEM</h4>
                <p class="mb-0 opacity-75">
                    Kelola konfigurasi absensi dan kedisiplinan siswa
                </p>
            </div>
        </div>

        <!-- ================= MENU CARD ================= -->
        <div class="row g-4">

            <!-- SETTING siswa -->
            <div class="col-lg-4 col-md-6 card-wrapper">
                <a href="<?= base_url('admin/absenotomatis'); ?>" class="text-decoration-none">
                    <div class="card setting-card" style="background: linear-gradient(135deg,#17a2b8,#0f6674);">
                        <div class="card-body text-center">
                            <div class="setting-icon">
                                <i class="material-icons">event</i>
                            </div>
                            <h4 class="fw-bold">Auto Absensi System</h4>
                            <p class="mb-0">
                                Absen di otomatiskan sama system
                            </p>
                        </div>
                    </div>
                </a>
            </div>






            <!-- SETTING WAKTU ABSENSI -->
            <div class="col-lg-4 col-md-6 card-wrapper">
                <a href="<?= base_url('admin/jam-presensi'); ?>" class="text-decoration-none">
                    <div class="card setting-card" style="background: linear-gradient(135deg,#0d6efd,#084298);">
                        <div class="card-body text-center">
                            <div class="setting-icon">
                                <i class="material-icons">schedule</i>
                            </div>
                            <h4 class="fw-bold">Setting Waktu Absensi</h4>
                            <p class="mb-0">
                                Atur jam masuk, pulang dan batas keterlambatan siswa.
                            </p>
                        </div>
                    </div>
                </a>
            </div>

            <!-- EDIT DATA SISWA (UNIQ KODE) -->
            <div class="col-lg-4 col-md-6 card-wrapper">
                <a href="<?= base_url('admin/siswa/kelas'); ?>" class="text-decoration-none">
                    <div class="card setting-card" style="background: linear-gradient(135deg,#198754,#0f5132);">
                        <div class="card-body text-center">
                            <div class="setting-icon">
                                <i class="material-icons">badge</i>
                            </div>
                            <h4 class="fw-bold">Edit Data Siswa</h4>
                            <p class="mb-0">
                                Perbarui data siswa berdasarkan <b>Uniq_Kode</b> yang terdaftar.
                            </p>
                        </div>
                    </div>
                </a>
            </div>

            <!-- SETTING HARI LIBUR -->
            <div class="col-lg-4 col-md-6 card-wrapper">
                <a href="<?= base_url('admin/harilibur'); ?>" class="text-decoration-none">
                    <div class="card setting-card" style="background: linear-gradient(135deg,#17a2b8,#0f6674);">
                        <div class="card-body text-center">
                            <div class="setting-icon">
                                <i class="material-icons">event</i>
                            </div>
                            <h4 class="fw-bold">Setting Hari Libur</h4>
                            <p class="mb-0">
                                Kelola hari libur nasional dan kalender sekolah.
                            </p>
                        </div>
                    </div>
                </a>
            </div>

            <!-- SETTING PELANGGARAN -->
            <div class="col-lg-4 col-md-6 card-wrapper">
                <a href="<?= base_url('admin/pelanggaran/inputjenispelanggaran'); ?>" class="text-decoration-none">
                    <div class="card setting-card" style="background: linear-gradient(135deg,#dc3545,#842029);">
                        <div class="card-body text-center">
                            <div class="setting-icon">
                                <i class="material-icons">warning</i>
                            </div>
                            <h4 class="fw-bold">Setting Pelanggaran Siswa</h4>
                            <p class="mb-0">
                                Atur jenis pelanggaran dan sistem poin siswa.
                            </p>
                        </div>
                    </div>
                </a>
            </div>


            <!-- SETTING siswa -->
            <div class="col-lg-4 col-md-6 card-wrapper">
                <a href="<?= base_url('admin/userloginaktif'); ?>" class="text-decoration-none">
                    <div class="card setting-card" style="background: linear-gradient(135deg,#17a2b8,#0f6674);">
                        <div class="card-body text-center">
                            <div class="setting-icon">
                                <i class="material-icons">event</i>
                            </div>
                            <h4 class="fw-bold">Ganti Password</h4>
                            <p class="mb-0">
                                Ubah Password Sesuai dengan keinginan Gunakan Kombinasi Hurup Besar Kecil Karakter angka bikin seuinik mungkin
                            </p>
                        </div>
                    </div>
                </a>
            </div>
            <!-- SETTING WAKTU ABSENSI -->
            <!-- <div class="col-lg-4 col-md-6 card-wrapper">
                <a href="<?= base_url('admin/backup'); ?>" class="text-decoration-none">
                    <div class="card setting-card" style="background: linear-gradient(135deg,#0d6efd,#084298);">
                        <div class="card-body text-center">
                            <div class="setting-icon">
                                <i class="material-icons">schedule</i>
                            </div>
                            <h4 class="fw-bold">Backup Database</h4>
                            <p class="mb-0">
                                Backup Database
                            </p>
                        </div>
                    </div>
                </a>
            </div> -->
            <!-- SETTING WAKTU ABSENSI -->
            <!-- <div class="col-lg-4 col-md-6 card-wrapper">
                <a href="<?= base_url('admin/restore'); ?>" class="text-decoration-none">
                    <div class="card setting-card" style="background: linear-gradient(135deg,#0d6efd,#084298);">
                        <div class="card-body text-center">
                            <div class="setting-icon">
                                <i class="material-icons">schedule</i>
                            </div>
                            <h4 class="fw-bold">Restore Database</h4>
                            <p class="mb-0">
                                Restore
                            </p>
                        </div>
                    </div>
                </a>
            </div> -->






        </div>

    </div>
</div>

<?= $this->endSection() ?>
