<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">

                <!-- FLASH MESSAGE -->
                <?php if(session()->getFlashdata('success')): ?>
                    <div class="px-3 pb-2">
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?= session()->getFlashdata('success') ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- CARD UTAMA -->
                <div class="card shadow-sm">

                    <!-- HEADER CARD -->
                    <div class="card-header text-white" style="background: linear-gradient(135deg,#6a11cb,#2575fc);">
                        <h4 class="card-title mb-1"style="color: #fbff00;">
                            <i class="material-icons">gavel</i>
                            <b>Data Pelanggaran Siswa</b>
                        </h4>
                        <p class="card-category mb-0" style="color: #ffd700;">
                            Catatan dan riwayat pelanggaran siswa
                        </p>
                    </div>

                    <!-- BODY CARD -->
                    <div class="card-body">

                        <!-- TOOLBAR -->
<div class="row g-2 mb-3">

    <!-- Tambah Pelanggaran -->
    <div class="col-12 col-md-4">
        <a href="<?= base_url('admin/pelanggaran/tambah') ?>"
           class="btn btn-success btn-lg d-flex align-items-center justify-content-center gap-2 w-100 text-white"
           style="background-color: #28a745; border-color: #218838;">
            <i class="material-icons">add</i>
            Tambah Pelanggaran
        </a>
    </div>

    <!-- Rekap Poin -->
    <div class="col-12 col-md-4">
        <a href="<?= base_url('admin/pelanggaran/rekap') ?>"
           class="btn btn-info btn-lg d-flex align-items-center justify-content-center gap-2 w-100 text-white"
           style="background-color: #17a2b8; border-color: #138496;">
            <i class="material-icons">assessment</i>
            Rekap Poin
        </a>
    </div>

    <!-- Kembali -->
    <div class="col-12 col-md-4">
        <a href="<?= base_url('admin/menupiket') ?>"
           class="btn btn-lg d-flex align-items-center justify-content-center gap-2 w-100 text-white"
           style="background-color:#9844ff;border-color:#b144ff;">
            <i class="material-icons">arrow_back</i>
            Kembali
        </a>
    </div>

</div>


                        <!-- TABLE DESKTOP -->
                        <div class="table-responsive d-none d-md-block">
                            <table class="table table-striped table-hover align-middle">
                                <thead class="table-primary">
                                    <tr>
                                        <th>#</th>
                                        <th>Nama Siswa</th>
                                        <th>Kelas</th>
                                        <th>Pelanggaran</th>
                                        <th>Poin</th>
                                        <th>Keterangan</th>
                                        <th>Tanggal</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no=1; foreach($data as $d): ?>
                                    <?php
                                        $poin = (int)$d['poin'];
                                        $badgeClass = 'bg-success';
                                        if($poin >= 5 && $poin < 10) $badgeClass = 'bg-warning text-dark';
                                        if($poin >= 10) $badgeClass = 'bg-danger';
                                    ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= esc($d['nama_siswa']) ?></td>
                                        <td><?= esc($d['kelas']) ?></td>
                                        <td><?= esc($d['jenis_pelanggaran']) ?></td>
                                        <td>
                                            <span class="badge <?= $badgeClass ?> px-2 py-1"><?= $poin ?></span>
                                        </td>
                                        <td><?= esc($d['keterangan']) ?></td>
                                        <td><?= date('d M Y', strtotime($d['tanggal'])) ?></td>
                                    </tr>
                                    <?php endforeach ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- CARD MOBILE -->
                        <div class="d-block d-md-none">

                            <?php foreach($data as $d): ?>
                            <div class="mobile-card shadow-sm p-3 mb-3 rounded-3" style="background: linear-gradient(135deg, #f0f4ff, #ffffff);">

                                <!-- Header: Nama & Kelas -->
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <h6 class="fw-bold mb-0"><?= esc($d['nama_siswa']) ?></h6>
                                        <small class="text-muted"><?= esc($d['kelas']) ?></small>
                                    </div>
                                    <div>
                                        <i class="material-icons text-danger">gavel</i>
                                    </div>
                                </div>

                                <hr class="my-2">

                                <!-- Jenis Pelanggaran -->
                                <div class="mb-2">
                                    <span class="fw-semibold">Pelanggaran:</span>
                                    <span><?= esc($d['jenis_pelanggaran']) ?></span>
                                </div>

                                <!-- Poin dengan badge dinamis -->
                                <?php
                                    $poin = (int)$d['poin'];
                                    $badgeClass = 'bg-success';
                                    if($poin >= 5 && $poin < 10) $badgeClass = 'bg-warning text-dark';
                                    if($poin >= 10) $badgeClass = 'bg-danger';
                                ?>
                                <div class="text-end">
                                    <span class="badge <?= $badgeClass ?> px-2 py-1">
                                        <?= $poin ?> poin
                                    </span>
                                </div>

                                <!-- Keterangan -->
                                <?php if(!empty($d['keterangan'])): ?>
                                    <div class="mt-2 small text-muted">
                                        <i class="material-icons me-1" style="font-size:16px;">note</i>
                                        <?= esc($d['keterangan']) ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Tanggal -->
                                <div class="mt-1 small text-end text-secondary">
                                    <?= date('d M Y', strtotime($d['tanggal'])) ?>
                                </div>

                            </div>
                            <?php endforeach ?>

                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- STYLE MOBILE CARD -->
<style>
.mobile-card {
    border-radius: 0.75rem;
    padding: 0.75rem 1rem;
    margin-bottom: 1rem;
    background-color: #fff;
    transition: transform 0.2s, box-shadow 0.2s;
}
.mobile-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.12);
}
.badge {
    font-weight: 600;
}
</style>

<?= $this->endSection() ?>
