<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid py-4">

    <!-- ================== JUDUL ================== -->
    <h4 class="mb-4 fw-bold">
        <i class="bi bi-journal-text me-2"></i>Kelola Jenis Pelanggaran
    </h4>

    <!-- ================== FORM TAMBAH ================== -->
    <div class="card shadow-sm border-0 mb-4">
        <div class="card-header fw-semibold">
            <i class="bi bi-plus-circle me-1"></i>Tambah Jenis Pelanggaran
        </div>
        <div class="card-body">
            <form method="post"
                  action="<?= base_url('admin/pelanggaran/inputjenispelanggaran/simpan') ?>"
                  class="row g-3">
                <?= csrf_field() ?>

                <div class="col-12 col-md-6">
                    <label class="form-label">Nama Pelanggaran</label>
                    <input type="text" name="nama" class="form-control"
                           placeholder="Contoh: Tidak memakai atribut"
                           required>
                </div>

                <div class="col-12 col-md-3">
                    <label class="form-label">Poin</label>
                    <input type="number" name="poin" class="form-control"
                           placeholder="10" required>
                </div>

                <div class="col-12 col-md-3 d-grid">
                    <label class="form-label d-none d-md-block">&nbsp;</label>
                    <button class="btn btn-success">
                        <i class="bi bi-plus-circle me-1"></i>Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- ================== SEARCH ================== -->
    <div class="row mb-3">
        <div class="col-12 col-md-4 ms-auto">
            <div class="input-group">
                <span class="input-group-text">
                    <i class="bi bi-search"></i>
                </span>
                <input type="text"
                       id="searchInput"
                       class="form-control"
                       placeholder="Cari pelanggaran atau poin...">
            </div>
        </div>
    </div>

    <!-- ================== DESKTOP TABLE ================== -->
    <div class="card shadow-sm border-0 d-none d-md-block">
        <div class="card-header fw-semibold">
            <i class="bi bi-table me-1"></i>Daftar Pelanggaran
        </div>
        <div class="card-body">
            <table class="table table-hover align-middle">
                <thead class="table-dark text-center">
                    <tr>
                        <th width="5%">No</th>
                        <th>Nama Pelanggaran</th>
                        <th width="15%">Pointtt</th>
                        <th width="25%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; foreach ($jenisPelanggaran as $jp): ?>
                    <tr class="data-item"
                        data-nama="<?= strtolower($jp['nama']) ?>"
                        data-poin="<?= $jp['poin'] ?>">
                        <td class="text-center"><?= $no++ ?></td>
                        <td><?= $jp['nama'] ?></td>
                        <td class="text-center">
                            <span class="badge bg-primary fs-6">
                                <?= $jp['poin'] ?> poin
                            </span>
                        </td>
                        <td class="text-center">
                            <div class="btn-group btn-group-sm">
                                <button class="btn btn-warning"
                                        data-bs-toggle="modal"
                                        data-bs-target="#edit<?= $jp['id'] ?>">
                                    <i class="bi bi-pencil-square me-1"></i>Edit
                                </button>

                                <form method="post"
                                      action="<?= base_url('admin/pelanggaran/inputjenispelanggaran/hapus/'.$jp['id']) ?>"
                                      onsubmit="return confirm('Yakin ingin dihapus?')">
                                    <?= csrf_field() ?>
                                    <button class="btn btn-danger">
                                        <i class="bi bi-trash me-1"></i>Hapus
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- ================== MOBILE CARD LIST ================== -->
<div class="d-md-none">

    <!-- SEARCH MOBILE -->
    <div class="mb-3">
        <div class="input-group">
            <span class="input-group-text">
                <i class="bi bi-search"></i>
            </span>
            <input type="text"
                   id="mobileSearch"
                   class="form-control"
                   placeholder="Cari pelanggaran atau poin...">
        </div>
    </div>

    <?php foreach ($jenisPelanggaran as $jp): ?>
    <div class="card mb-3 border-0 shadow-sm mobile-item"
         data-nama="<?= strtolower($jp['nama']) ?>"
         data-poin="<?= $jp['poin'] ?>">

        <div class="card-body">

            <!-- JUDUL + BADGE -->
            <div class="d-flex justify-content-between align-items-start mb-2">
                <h6 class="fw-bold mb-0"><?= $jp['nama'] ?></h6>
                <span class="badge bg-primary fs-6">
                    <?= $jp['poin'] ?> poin
                </span>
            </div>

            <!-- TOMBOL AKSI -->
            <div class="d-grid gap-2 mt-3">
                <button class="btn btn-warning btn-lg"
                        data-bs-toggle="modal"
                        data-bs-target="#edit<?= $jp['id'] ?>">
                    <i class="bi bi-pencil-square me-1"></i>Edit
                </button>

                <form method="post"
                      action="<?= base_url('admin/pelanggaran/inputjenispelanggaran/hapus/'.$jp['id']) ?>"
                      onsubmit="return confirm('Yakin ingin dihapus?')">
                    <?= csrf_field() ?>
                    <button class="btn btn-danger btn-lg w-100">
                        <i class="bi bi-trash me-1"></i>Hapus
                    </button>
                </form>
            </div>

        </div>
    </div>
    <?php endforeach ?>

    <!-- EMPTY STATE -->
    <div id="mobileEmpty"
         class="text-center text-muted py-5 d-none">
        <i class="bi bi-inbox fs-1 d-block mb-2"></i>
        Data tidak ditemukan
    </div>

</div>

<!-- ================== MOBILE SEARCH SCRIPT ================== -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const searchInput = document.getElementById('mobileSearch');
    const items = document.querySelectorAll('.mobile-item');
    const empty = document.getElementById('mobileEmpty');

    searchInput.addEventListener('keyup', function () {
        const keyword = this.value.toLowerCase();
        let visible = 0;

        items.forEach(item => {
            const nama = item.dataset.nama;
            const poin = item.dataset.poin;

            if (nama.includes(keyword) || poin.includes(keyword)) {
                item.style.display = '';
                visible++;
            } else {
                item.style.display = 'none';
            }
        });

        empty.classList.toggle('d-none', visible !== 0);
    });
});
</script>


<!-- ================== MODAL EDIT ================== -->
<?php foreach ($jenisPelanggaran as $jp): ?>
<div class="modal fade" id="edit<?= $jp['id'] ?>" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form method="post"
                  action="<?= base_url('admin/pelanggaran/inputjenispelanggaran/edit/'.$jp['id']) ?>">
                <?= csrf_field() ?>

                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="bi bi-pencil-square me-1"></i>Edit Pelanggaran
                    </h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Nama Pelanggaran</label>
                        <input type="text" name="nama"
                               value="<?= $jp['nama'] ?>"
                               class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Poin</label>
                        <input type="number" name="poin"
                               value="<?= $jp['poin'] ?>"
                               class="form-control" required>
                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary"
                            data-bs-dismiss="modal">Batal</button>
                    <button class="btn btn-warning">
                        <i class="bi bi-save me-1"></i>Update
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>
<?php endforeach ?>

<!-- ================== SEARCH SCRIPT ================== -->
<script>
document.getElementById('searchInput').addEventListener('keyup', function () {
    const keyword = this.value.toLowerCase();
    const items = document.querySelectorAll('.data-item');

    items.forEach(item => {
        const nama = item.dataset.nama;
        const poin = item.dataset.poin;

        if (nama.includes(keyword) || poin.includes(keyword)) {
            item.style.display = '';
        } else {
            item.style.display = 'none';
        }
    });
});
</script>

<?= $this->endSection() ?>
