<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">

    <!-- HEADER CARD -->
    <div class="card shadow-sm mb-3">
        <div class="card-header text-white" style="background: linear-gradient(135deg, #ca097a, #d014c4);">
            <h4 class="card-title mb-1" style="color: #000000;">
                <i class="material-icons">assessment</i>
                Rekap Poin Pelanggaran Siswa
            </h4>
            <p class="card-category mb-0" style="color: #000000;">
                Akumulasi total poin pelanggaran per siswa
            </p>
        </div>

        <div class="card-body">

            <!-- FILTER KELAS & BACK BUTTON -->
            <form method="get" class="row mb-3">
                <div class="col-12 col-md-4 mb-2 mb-md-0">
                    <select name="id_kelas" class="form-select" onchange="this.form.submit()">
                        <option value="">-- Semua Kelas --</option>
                        <?php foreach ($kelas as $k): ?>
                            <option value="<?= $k['id_kelas'] ?>"
                                <?= ($id_kelas == $k['id_kelas']) ? 'selected' : '' ?>>
                                <?= esc($k['kelas']) ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>
                <div class="col-12 col-md-8 text-md-end">
                    <a href="<?= base_url('admin/pelanggaran') ?>"
                       class="btn btn-sm"
                       style="background-color: #9844ff;border-color: #b144ff;color: #fff;">
                        <i class="material-icons">arrow_back</i>
                        Kembali
                    </a>
                </div>
            </form>

            <!-- TABLE DESKTOP -->
            <div class="table-responsive d-none d-md-block">
                <table class="table table-bordered table-striped align-middle text-center">
                    <thead class="table-dark">
                        <tr>
                            <th width="5%">No</th>
                            <th>NIS</th>
                            <th class="text-start">Nama Siswa</th>
                            <th>Kelas</th>
                            <th>Total Poin</th>
                            <th>Status</th>
                            <!-- <th width="10%">Aksi</th> -->
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($rekap)): ?>
                            <?php foreach ($rekap as $i => $d): ?>
                                <?php
                                    $total = (int)$d['total_poin'];
                                    if($total >= 50) $statusClass = 'bg-danger';
                                    elseif($total >= 25) $statusClass = 'bg-warning text-dark';
                                    else $statusClass = 'bg-success';
                                ?>
                                <tr>
                                    <td><?= $i + 1 ?></td>
                                    <td><?= esc($d['nis']) ?></td>
                                    <td class="text-start"><?= esc($d['nama_siswa']) ?></td>
                                    <td><?= esc($d['kelas']) ?></td>
                                    <td class="fw-bold text-danger"><?= $total ?></td>
                                    <td><span class="badge <?= $statusClass ?>"><?= $total >= 50 ? 'Berat' : ($total >= 25 ? 'Waspada' : 'Aman') ?></span></td>
                                    <!-- <td>
                                        <a href="<?= base_url('admin/piket/rekap/detail/' . $d['id_siswa']) ?>"
                                           class="btn btn-sm btn-info">
                                            <i class="material-icons">visibility</i>
                                        </a>
                                    </td> -->
                                </tr>
                            <?php endforeach ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted">Tidak ada data</td>
                            </tr>
                        <?php endif ?>
                    </tbody>
                </table>
            </div>

            <!-- CARD MOBILE -->
            <div class="d-block d-md-none">
                <?php if(!empty($rekap)): ?>
                    <?php foreach($rekap as $i => $d): ?>
                        <?php
                            $total = (int)$d['total_poin'];
                            if($total >= 50) $statusClass = 'bg-danger';
                            elseif($total >= 25) $statusClass = 'bg-warning text-dark';
                            else $statusClass = 'bg-success';
                        ?>
                        <div class="mobile-card shadow-sm p-3 mb-3 rounded-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <div>
                                    <h6 class="fw-bold mb-0"><?= esc($d['nama_siswa']) ?></h6>
                                    <small class="text-muted"><?= esc($d['kelas']) ?> | NIS: <?= esc($d['nis']) ?></small>
                                </div>
                                <span class="badge <?= $statusClass ?> px-2 py-1">
                                    <?= $total >= 50 ? 'Berat' : ($total >= 25 ? 'Waspada' : 'Aman') ?>
                                </span>
                            </div>
                            <div class="mt-2 fw-semibold">Total Poin: <span class="text-danger"><?= $total ?></span></div>
                            <div class="mt-2 text-end">
                                <!-- <a href="<?= base_url('admin/piket/rekap/detail/' . $d['id_siswa']) ?>"
                                   class="btn btn-sm btn-info">
                                    <i class="material-icons">visibility</i> Detail
                                </a> -->
                            </div>
                        </div>
                    <?php endforeach ?>
                <?php else: ?>
                    <div class="text-center text-muted">Tidak ada data</div>
                <?php endif ?>
            </div>

        </div>
    </div>

</div>
</div>

<!-- STYLE MOBILE CARD -->
<style>
.mobile-card {
    border-radius: 0.75rem;
    padding: 0.75rem 1rem;
    margin-bottom: 1rem;
    background-color: #691f8c66;
    transition: transform 0.2s, box-shadow 0.2s;
}
.mobile-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.12);
}
.badge {
    font-weight: 600;
}
</style>

<?= $this->endSection() ?>
