<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">


<?php
// ===============================
// SORT KELAS AGAR URUT (NATURAL)
// ===============================
usort($kelas, function ($a, $b) {
    return strnatcmp($a['kelas'], $b['kelas']);
});
?>


<div class="container-fluid">

    <!-- CARD FORM -->
    <div class="card shadow-sm">
        <div class="card-header text-white" style="background: linear-gradient(135deg,#28a745,#218838);">
            <h4 class="card-title mb-0">
                ➕ Tambah Pelanggaran
            </h4>
        </div>

        <div class="card-body">

  <!-- FORM -->
<form method="post" action="<?= base_url('admin/pelanggaran/simpan') ?>">
    <?= csrf_field() ?>

    <!-- KELAS -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Kelas</label>
        <select id="kelas" class="form-select" required>
            <option value="">-- Pilih Kelas --</option>
            <?php foreach ($kelas as $k): ?>
                <option value="<?= $k['id_kelas'] ?>">
                    <?= esc($k['kelas']) ?>
                </option>
            <?php endforeach ?>
        </select>
    </div>

    <!-- SISWA -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Siswa</label>
        <select name="id_siswa" id="siswa" class="form-select" required disabled>
            <option value="">-- Pilih kelas dulu --</option>
        </select>
    </div>

    <!-- JENIS PELANGGARAN -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Jenis Pelanggaran</label>
        <select name="id_jenis" id="jenis" class="form-select" required>
            <option value="">-- Pilih --</option>
            <?php foreach ($jenis as $j): ?>
                <option value="<?= $j['id'] ?>" data-poin="<?= $j['poin'] ?>">
                    <?= esc($j['nama']) ?>
                </option>
            <?php endforeach ?>
        </select>
    </div>

    <!-- POIN -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Poin</label>
        <input type="number" id="poin" class="form-control" readonly>
    </div>

    <!-- KETERANGAN -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Keterangan</label>
        <textarea name="keterangan" class="form-control" rows="3" placeholder="Opsional"></textarea>
    </div>

<!-- TOMBOL SIMPAN -->
<div class="d-grid gap-2 mb-3">
    <button type="submit"
            class="btn btn-lg w-100 d-flex justify-content-center align-items-center gap-2 text-white"
            style="background-color: #28a745; border-color: #218838;">
        💾 Simpan
    </button>
</div>

<!-- TOMBOL KEMBALI -->
<div class="d-grid gap-2 mb-3">
    <a href="<?= base_url('admin/pelanggaran') ?>"
       class="btn btn-lg w-100 d-flex justify-content-center align-items-center gap-2 text-white"
       style="background-color: #9844ff; border-color: #b144ff;">
        <i class="material-icons">arrow_back</i>
        Kembali
    </a>
</div>


</form>

<!-- SCRIPT DINAMIS -->
<script>
const kelas = document.getElementById('kelas');
const siswa = document.getElementById('siswa');
const jenis = document.getElementById('jenis');
const poin  = document.getElementById('poin');

kelas.addEventListener('change', function () {
    if (!this.value) {
        siswa.innerHTML = '<option>-- Pilih kelas dulu --</option>';
        siswa.disabled = true;
        return;
    }

    fetch("<?= base_url('admin/pelanggaran/ajax/siswa') ?>/" + this.value)
        .then(res => res.json())
        .then(data => {
            let opt = '<option value="">-- Pilih Siswa --</option>';
            data.forEach(s => {
                opt += `<option value="${s.id_siswa}">${s.nama_siswa}</option>`;
            });
            siswa.innerHTML = opt;
            siswa.disabled = false;
        });
});

jenis.addEventListener('change', function () {
    poin.value = this.options[this.selectedIndex]?.dataset.poin || 0;
});
</script>


<!-- STYLE TAMBAH PELANGGARAN -->
<style>
.card-header h4 {
    font-weight: 700;
}
.btn-lg {
    font-weight: 600;
}
.form-label {
    font-size: 0.95rem;
}
</style>

<?= $this->endSection() ?>
