<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

    <!-- ================= CARD UTAMA ================= -->
    <div class="card">

        <!-- ================= HEADER ================= -->
        <div class="card-header card-header-primary">
            <h4 class="card-title">
                <i class="material-icons">analytics</i>
                <b>Persentase Kehadiran Siswa</b>
            </h4>
            <p class="card-category">
                Rekap kehadiran harian, mingguan, dan bulanan
            </p>
        </div>


                    <!-- ================= BACK TO MENU================= -->
                    <!-- Jarak Space -->
                    <div class="card-body"> </div> 
                    <!-- --------------------------------------------- -->
                        <div class="col-md-3 col-12 mb-3 d-flex align-items-end">
                            <a href="<?= base_url('admin/menu-persentasi'); ?>" 
                            class="btn w-100 d-flex align-items-center justify-content-center"
                            style="background: #ff5e31; color: #ffffff;">
                                <i class="material-icons me-2">dashboard</i>
                                Menu
                            </a>
                        </div>
                    <!-- --------------------------------------------- -->


        <!-- ================= BODY ================= -->
        <div class="card-body">
            
                                                            <!-- Jarak Space -->
                                                            <div class="card-body"> </div> 

            <!-- ================= FILTER ================= -->
            <form method="get" class="mb-4">
                <div class="row">

                    <div class="col-md-4 col-12 mb-3">
                        <div class="form-group">
                            <label>Tanggal</label>
                            <input type="date"
                                   name="tanggal"
                                   value="<?= esc($tanggal ?? date('Y-m-d')) ?>"
                                   class="form-control">
                        </div>
                    </div>

                    <div class="col-md-5 col-12 mb-3">
                        <div class="form-group">
                            <label>Kelas</label>
                            <select name="kelas" class="form-control" required>
                                <option value="">-- Pilih Kelas --</option>
                                <?php if (!empty($kelas)): ?>
                                    <?php foreach ($kelas as $k): ?>
                                        <option value="<?= $k['id_kelas'] ?>"
                                            <?= ($selectedKelas ?? '') == $k['id_kelas'] ? 'selected' : '' ?>>
                                            <?= esc($k['kelas']) ?>
                                        </option>
                                    <?php endforeach ?>
                                <?php endif ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 col-12 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="material-icons">search</i>
                            Tampilkan
                        </button>
                    </div>



                </div>
            </form>

            <!-- ================= HASIL ================= -->
            <?php if (!empty($stat)): ?>
            <div class="row">

                <!-- ================= HARIAN ================= -->
                <div class="col-md-4 col-12 mb-3">
                    <div class="card text-center">
                        <div class="card-body">
                            <i class="material-icons text-success" style="font-size:48px">today</i>
                            <h6 class="mt-2">Harian</h6>
                            <h3 class="font-weight-bold text-success">
                                <?= $stat['harian'] ?>%
                            </h3>
                        </div>
                    </div>
                </div>

                <!-- ================= MINGGUAN ================= -->
                <div class="col-md-4 col-12 mb-3">
                    <div class="card text-center">
                        <div class="card-body">
                            <i class="material-icons text-warning" style="font-size:48px">date_range</i>
                            <h6 class="mt-2">Mingguan</h6>
                            <h3 class="font-weight-bold text-warning">
                                <?= $stat['mingguan'] ?>%
                            </h3>
                        </div>
                    </div>
                </div>

                <!-- ================= BULANAN ================= -->
                <div class="col-md-4 col-12 mb-3">
                    <div class="card text-center">
                        <div class="card-body">
                            <i class="material-icons text-primary" style="font-size:48px">calendar_month</i>
                            <h6 class="mt-2">Bulanan</h6>
                            <h3 class="font-weight-bold text-primary">
                                <?= $stat['bulanan'] ?>%
                            </h3>
                        </div>
                    </div>
                </div>

            </div>

            <!-- ================= GRAFIK ================= -->
            <div class="card mt-4">
                <div class="card-body">
                    <h6 class="mb-3 d-flex align-items-center gap-2">
                        <i class="material-icons text-primary">bar_chart</i>
                        Grafik Perbandingan Kehadiran (%)
                    </h6>
                    <canvas id="kehadiranChart" height="120"></canvas>
                </div>
            </div>

            <!-- ================= SCRIPT Chart.js ================= -->
            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
            <script>
            const ctx = document.getElementById('kehadiranChart');

            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: <?= json_encode($chartData['labels']) ?>,
                    datasets: [{
                        label: 'Persentase Kehadiran (%)',
                        data: <?= json_encode($chartData['values']) ?>,
                        backgroundColor: [
                            '#198754', // Harian
                            '#ffc107', // Mingguan
                            '#0d6efd'  // Bulanan
                        ],
                        borderRadius: 8
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return context.raw + '%';
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 100,
                            ticks: {
                                callback: function(value) {
                                    return value + '%';
                                }
                            }
                        }
                    }
                }
            });
            </script>

            <?php endif; ?>

        </div>
    </div>

</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
