<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

    <!-- ================= CARD UTAMA ================= -->
    <div class="card">

        <div class="card-header card-header-primary">
            <h4 class="card-title">
                <i class="material-icons">compare_arrows</i>
                <b>Perbandingan Antar Kelas</b>
            </h4>
            <p class="card-category">
                Melihat kelas dengan kehadiran terendah hingga tertinggi
            </p>
        </div>
                    <!-- ================= BACK TO MENU================= -->
                    <!-- Jarak Space -->
                    <div class="card-body"> </div> 
                    <!-- --------------------------------------------- -->
                        <div class="col-md-3 col-12 mb-3 d-flex align-items-end">
                            <a href="<?= base_url('admin/menu-persentasi'); ?>" 
                            class="btn w-100 d-flex align-items-center justify-content-center"
                            style="background: #ff5e31; color: #ffffff;">
                                <i class="material-icons me-2">dashboard</i>
                                Menu
                            </a>
                        </div>
                    <!-- --------------------------------------------- -->
        <div class="card-body">

            <!-- ================= FILTER TANGGAL ================= -->
            <form method="get" class="mb-4">
                <div class="row">
                    <div class="col-md-4 col-12 mb-3">
                        <div class="form-group">
                            <label>Tanggal</label>
                            <input type="date" name="tanggal" class="form-control" value="<?= esc($tanggal) ?>">
                        </div>
                    </div>
                    <div class="col-md-2 col-12 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="material-icons">search</i>
                            Tampilkan
                        </button>
                    </div>
                </div>
            </form>

            <!-- ================= GRAFIK ================= -->
            <div class="card mb-4">
                <div class="card-body">
                    <h6 class="mb-3 d-flex align-items-center gap-2">
                        <i class="material-icons text-primary">bar_chart</i>
                        Persentase Kehadiran Per Kelas (%)
                    </h6>
                    <canvas id="perbandinganKelasChart" height="100"></canvas>
                </div>
            </div>

            <!-- ================= LIST KELAS TERBURUK ================= -->
            <div class="card">
                <div class="card-body">
                    <h6 class="mb-3 d-flex align-items-center gap-2">
                        <i class="material-icons text-danger">warning</i>
                        Kelas dengan Kehadiran Terendah
                    </h6>
                    <ul class="list-group">
                        <?php foreach($persenKelas as $pk): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?= esc($pk['kelas']) ?>
                                <span class="badge bg-primary"><?= $pk['persen'] ?>%</span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>

        </div>
    </div>

</div>
</div>
</div>
</div>

<!-- ================= SCRIPT CHART.JS ================= -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('perbandinganKelasChart');

new Chart(ctx, {
    type: 'bar',
    data: {
        labels: <?= json_encode($chartLabels) ?>,
        datasets: [{
            label: 'Persentase Kehadiran (%)',
            data: <?= json_encode($chartValues) ?>,
            backgroundColor: '#0d6efd',
            borderRadius: 6
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false },
            tooltip: {
                callbacks: {
                    label: function(context){
                        return context.raw + '%';
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                max: 100,
                ticks: {
                    callback: function(value){ return value + '%'; }
                }
            }
        }
    }
});
</script>

<?= $this->endSection() ?>
