<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

    <div class="card">

        <div class="card-header card-header-primary">
            <h4 class="card-title">
                <i class="material-icons">calendar_view_day</i>
                <b>Perbandingan Kehadiran Sekolah</b>
            </h4>
            <p class="card-category">
                Persentase kehadiran seluruh siswa per hari
            </p>
        </div>
                    <!-- ================= BACK TO MENU================= -->
                    <!-- Jarak Space -->
                    <div class="card-body"> </div> 
                    <!-- --------------------------------------------- -->
                        <div class="col-md-3 col-12 mb-3 d-flex align-items-end">
                            <a href="<?= base_url('admin/menu-persentasi'); ?>" 
                            class="btn w-100 d-flex align-items-center justify-content-center"
                            style="background: #ff5e31; color: #ffffff;">
                                <i class="material-icons me-2">dashboard</i>
                                Menu
                            </a>
                        </div>
                    <!-- --------------------------------------------- -->
        <div class="card-body">

            <!-- ================= FILTER ================= -->
            <form method="get" class="mb-4">
                <div class="row">

                    <div class="col-md-4 col-12 mb-3">
                        <div class="form-group">
                            <label>Tanggal Mulai</label>
                            <input type="date" name="start" class="form-control" value="<?= esc($startDate) ?>">
                        </div>
                    </div>

                    <div class="col-md-4 col-12 mb-3">
                        <div class="form-group">
                            <label>Tanggal Akhir</label>
                            <input type="date" name="end" class="form-control" value="<?= esc($endDate) ?>">
                        </div>
                    </div>

                    <div class="col-md-4 col-12 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="material-icons">search</i>
                            Tampilkan
                        </button>
                    </div>

                </div>
            </form>

            <!-- ================= GRAFIK ================= -->
            <?php if(!empty($chartLabels)): ?>
            <div class="card">
                <div class="card-body">
                    <h6 class="mb-3 d-flex align-items-center gap-2">
                        <i class="material-icons text-primary">show_chart</i>
                        Kehadiran Sekolah Hari ke Hari (%)
                    </h6>
                    <canvas id="perbandinganSekolahChart" height="100"></canvas>
                </div>
            </div>

            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
            <script>
            const ctx = document.getElementById('perbandinganSekolahChart');

            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: <?= json_encode($chartLabels) ?>,
                    datasets: [{
                        label: 'Kehadiran (%)',
                        data: <?= json_encode($chartValues) ?>,
                        fill: false,
                        borderColor: '#198754',
                        backgroundColor: '#198754',
                        tension: 0.2,
                        pointRadius: 4
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false },
                        tooltip: {
                            callbacks: {
                                label: function(context){
                                    return context.raw + '%';
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 100,
                            ticks: {
                                callback: function(value){ return value + '%'; }
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Tanggal'
                            }
                        }
                    }
                }
            });
            </script>
            <?php endif; ?>

        </div>
    </div>

</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
