<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

    <!-- ================= CARD UTAMA ================= -->
    <div class="card">

        <!-- ================= HEADER ================= -->
        <div class="card-header card-header-primary">
            <h4 class="card-title">
                <i class="material-icons">show_chart</i>
                <b>Tren Kehadiran Harian</b>
            </h4>
            <p class="card-category">
                Persentase kehadiran siswa per tanggal selama 1 bulan
            </p>
        </div>


                            <!-- ================= BACK TO MENU================= -->
                    <!-- Jarak Space -->
                    <div class="card-body"> </div> 
                    <!-- --------------------------------------------- -->
                        <div class="col-md-3 col-12 mb-3 d-flex align-items-end">
                            <a href="<?= base_url('admin/menu-persentasi'); ?>" 
                            class="btn w-100 d-flex align-items-center justify-content-center"
                            style="background: #f4208a; color: #ffffff;">
                                <i class="material-icons me-2">dashboard</i>
                                Menu
                            </a>
                        </div>
                    <!-- --------------------------------------------- -->



        <!-- ================= BODY ================= -->
        <div class="card-body">

            <!-- ================= FILTER ================= -->
            <form method="get" class="mb-4">
                <div class="row">

                    <div class="col-md-3 col-12 mb-3">
                        <div class="form-group">
                            <label>Bulan</label>
                            <select name="bulan" class="form-control">
                                <?php for($m=1;$m<=12;$m++): ?>
                                    <option value="<?= $m ?>" <?= ($bulan == $m ? 'selected' : '') ?>>
                                        <?= date('F', mktime(0,0,0,$m,1)) ?>
                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 col-12 mb-3">
                        <div class="form-group">
                            <label>Tahun</label>
                            <select name="tahun" class="form-control">
                                <?php for($y = date('Y')-5; $y <= date('Y'); $y++): ?>
                                    <option value="<?= $y ?>" <?= ($tahun == $y ? 'selected' : '') ?>><?= $y ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-4 col-12 mb-3">
                        <div class="form-group">
                            <label>Kelas</label>
                            <select name="kelas" class="form-control" required>
                                <option value="">-- Pilih Kelas --</option>
                                <?php if(!empty($kelas)): ?>
                                    <?php foreach($kelas as $k): ?>
                                        <option value="<?= $k['id_kelas'] ?>"
                                            <?= ($selectedKelas ?? '') == $k['id_kelas'] ? 'selected' : '' ?>>
                                            <?= esc($k['kelas']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2 col-12 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="material-icons">search</i>
                            Tampilkan
                        </button>
                    </div>

                </div>
            </form>

            <!-- ================= GRAFIK ================= -->
            <?php if(!empty($chartData)): ?>
            <div class="card">
                <div class="card-body">
                    <h6 class="mb-3 d-flex align-items-center gap-2">
                        <i class="material-icons text-primary">show_chart</i>
                        Tren Kehadiran Bulanan (%)
                    </h6>
                    <canvas id="trenHarianChart" height="100"></canvas>
                </div>
            </div>

            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
            <script>
            const ctx = document.getElementById('trenHarianChart');

            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: <?= json_encode($chartData['labels']) ?>,
                    datasets: [{
                        label: 'Kehadiran (%)',
                        data: <?= json_encode($chartData['values']) ?>,
                        fill: false,
                        borderColor: '#0d6efd',
                        backgroundColor: '#0d6efd',
                        tension: 0.2,
                        pointRadius: 5
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false },
                        tooltip: {
                            callbacks: {
                                label: function(context){
                                    return context.raw + '%';
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 100,
                            ticks: {
                                callback: function(value){ return value + '%'; }
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Tanggal'
                            }
                        }
                    }
                }
            });
            </script>
            <?php endif; ?>

        </div>
    </div>

</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
