<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header card-header-info mb-48">
                        <h4 class="card-title">Buat Akun Petugas</h4>
                        <p class="card-category">Isi data petugas baru</p>
                    </div>
                    <div class="card-body mx-5 my-3">

                        <?= view('Myth\Auth\Views\_message_block') ?>

                        <form action="<?= base_url('admin/petugas/save') ?>" method="post">
                            <?= csrf_field() ?>

                            <div class="form-group mt-4">
                                <label for="email">Email</label>
                                <input type="email" id="email" class="form-control <?php if (session('errors.email')) : ?>is-invalid<?php endif ?>" name="email" placeholder="example@email.com" value="<?= old('email') ?>">
                                <?php if (session('errors.email')) : ?>
                                    <div class="invalid-feedback"><?= session('errors.email') ?></div>
                                <?php endif ?>
                            </div>

                            <div class="form-group mt-4">
                                <label for="username">Username</label>
                                <input type="text" id="username" class="form-control <?php if (session('errors.username')) : ?>is-invalid<?php endif ?>" name="username" placeholder="yourusername" value="<?= old('username') ?>">
                                <?php if (session('errors.username')) : ?>
                                    <div class="invalid-feedback"><?= session('errors.username') ?></div>
                                <?php endif ?>
                            </div>

                            <div class="form-group mt-4">
                                <label for="password">Password</label>
                                <input type="password" id="password" name="password" class="form-control <?php if (session('errors.password')) : ?>is-invalid<?php endif ?>" autocomplete="off">
                                <?php if (session('errors.password')) : ?>
                                    <div class="invalid-feedback"><?= session('errors.password') ?></div>
                                <?php endif ?>
                            </div>

                            <div class="form-group mt-4">
                                <label for="pass_confirm">Ulangi Password</label>
                                <input type="password" id="pass_confirm" name="pass_confirm" class="form-control <?php if (session('errors.pass_confirm')) : ?>is-invalid<?php endif ?>" autocomplete="off">
                                <?php if (session('errors.pass_confirm')) : ?>
                                    <div class="invalid-feedback"><?= session('errors.pass_confirm') ?></div>
                                <?php endif ?>
                            </div>

                            <!-- Dropdown Role -->
                            <div class="form-group mt-4">
                                <label for="role">Role</label>
                                <select id="role" name="role" class="form-control <?php if (session('errors.role')) : ?>is-invalid<?php endif ?>">
                                    <option value="">--Pilih Role--</option>
                                    <option value="0" <?= old('role') == '0' ? 'selected' : '' ?>>Petugas</option>
                                    <option value="1" <?= old('role') == '1' ? 'selected' : '' ?>>Super Admin</option>
                                    <option value="2" <?= old('role') == '2' ? 'selected' : '' ?>>Admin</option>
                                    <option value="3" <?= old('role') == '3' ? 'selected' : '' ?>>Guru</option>
                                    <option value="4" <?= old('role') == '4' ? 'selected' : '' ?>>Siswa</option>
                                    <option value="5" <?= old('role') == '5' ? 'selected' : '' ?>>Orang Tua</option>
                                </select>
                                <?php if (session('errors.role')) : ?>
                                    <div class="invalid-feedback"><?= session('errors.role') ?></div>
                                <?php endif ?>
                            </div>

                            <button type="submit" class="btn btn-info btn-block mt-4">Simpan Petugas</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
