<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Surat Izin Siswa</title>

    <style>
        /* =====================================================
           PILIH UKURAN KERTAS (AKTIFKAN SALAH SATU SAJA)
        ===================================================== */

        /* 🔹 THERMAL 58mm */
        @page { size: 58mm auto; margin: 5mm; }

        /* 🔹 THERMAL 80mm */
        /* @page { size: 80mm auto; margin: 6mm; } */

        /* 🔹 A6 */
        /* @page { size: A6; margin: 10mm; } */

        /* 🔹 DEFAULT A4 */
        /* @page { size: A4; margin: 20mm; } */

        /* ===================================================== */

        body {
            font-family: "Times New Roman", serif;
            font-size: 14px;
            color: #000;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 100%;
            max-width: 700px;
            margin: auto;
        }

        /* ================= KOP ================= */
        .kop {
            text-align: center;
            border-bottom: 3px solid #000;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        .kop h2, .kop h3 {
            margin: 0;
        }

        .kop p {
            margin: 3px 0;
            font-size: 12px;
        }

        /* ================= JUDUL ================= */
        .judul {
            text-align: center;
            margin: 25px 0;
            text-decoration: underline;
            font-weight: bold;
            font-size: 16px;
        }

        /* ================= TABEL ================= */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table td {
            padding: 6px;
            vertical-align: top;
        }

        /* ================= TTD ================= */
        .ttd {
            width: 100%;
            margin-top: 40px;
        }

        .ttd .kanan {
            float: right;
            text-align: center;
        }

        /* ================= PRINT ================= */
        @media print {
            button {
                display: none;
            }
        }
    </style>
</head>

<body onload="window.print()">

<div class="container">

    <!-- ================= KOP SURAT ================= -->
    <div class="kop">
        <h2>PEMERINTAH PROVINSI JAWA BARAT</h2>
        <h3>SMA NEGERI 1 CIKATOMAS</h3>
        <p>Alamat : Jalan raya cikatomas No 109</p>
        <p>Telp : 085223222xxx</p>
    </div>

    <!-- ================= JUDUL ================= -->
    <div class="judul">
        SURAT IZIN KELUAR SISWA
    </div>

    <!-- ================= ISI ================= -->
    <p>Yang bertanda tangan di bawah ini menerangkan bahwa:</p>

    <table>
        <tr>
            <td width="30%">Nama</td>
            <td width="5%">:</td>
            <td><?= esc($izin['nama_siswa']) ?></td>
        </tr>
        <tr>
            <td>NIS</td>
            <td>:</td>
            <td><?= esc($izin['nis']) ?></td>
        </tr>
        <tr>
            <td>Kelas</td>
            <td>:</td>
            <td><?= esc($izin['kelas']) ?></td>
        </tr>
        <tr>
            <td>Jenis Izin</td>
            <td>:</td>
            <td><?= ucfirst($izin['jenis']) ?></td>
        </tr>
        <tr>
            <td>Tanggal</td>
            <td>:</td>
            <td><?= date('d-m-Y', strtotime($izin['tanggal'])) ?></td>
        </tr>
        <tr>
            <td>Jam</td>
            <td>:</td>
            <td><?= esc($izin['jam']) ?></td>
        </tr>
        <tr>
            <td>Keterangan</td>
            <td>:</td>
            <td><?= esc($izin['keterangan']) ?></td>
        </tr>
    </table>

    <p>
        Dengan ini diberikan izin kepada siswa tersebut untuk meninggalkan sekolah
        sesuai dengan keterangan di atas.
    </p>

    <!-- ================= TTD ================= -->
    <div class="ttd">
        <div class="kanan">
            <p><?= date('d F Y') ?></p>
            <p>Guru Piket</p>
            <br><br><br>
            <p><strong>( Ade irpan Nugraha, S.Pd )</strong></p>
            <!-- <p><strong>( ___________________ )</strong></p> -->
        </div>
    </div>

    <div style="clear: both;"></div>

    <button onclick="window.print()">🖨 Cetak</button>

</div>

</body>
</html>
