<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
.form-select{
    border-radius:1rem;
    padding:.5rem 1rem;
}
.card-custom{
    border-radius:1rem;
    box-shadow:0 6px 10px rgba(0,0,0,.08);
    background:#fff;
}

/* TABLE */
.table th{
    background:#0d6efd;
    color:#fff;
    text-align:center;
    font-weight:700;
    white-space:nowrap;
}
.table td{
    vertical-align:middle;
    font-size:.9rem;
    white-space:nowrap;
}

/* CENTER COLUMN */
.td-center{
    text-align:center;
}

/* DETAIL IZIN ICON LIST */
.detail-izin{
    list-style:none;
    padding-left:0;
    margin:0;
}
.detail-izin li{
    display:flex;
    align-items:flex-start;
    gap:6px;
    margin-bottom:4px;
    font-size:.85rem;
}
.detail-izin i{
    font-size:18px;
    color:#0d6efd;
}

/* MOBILE CARD MODE */
@media (max-width:768px){
    .table-responsive{
        display:none;
    }

    .izin-card{
        border-radius:1rem;
        box-shadow:0 6px 12px rgba(0,0,0,.1);
        margin-bottom:1rem;
        overflow:hidden;
        background:#fff;
    }

    .izin-card-header{
        background:#0d6efd;
        color:#fff;
        padding:.75rem 1rem;
        font-weight:700;
        display:flex;
        align-items:center;
        gap:8px;
    }

    .izin-card-body{
        padding:1rem;
        font-size:.9rem;
    }

    .izin-row{
        display:flex;
        justify-content:space-between;
        margin-bottom:.4rem;
    }

    .izin-row span:first-child{
        font-weight:600;
        color:#555;
    }
}

/* DESKTOP ONLY */
@media (min-width:769px){
    .izin-card-wrapper{
        display:none;
    }
}
</style>

<div class="content py-4" style="background:#f8f9fa;min-height:100vh">
<div class="container-fluid">

<div class="card card-custom p-4">

    <!-- ================= BARIS 1 : HEADER ================= -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-center align-items-center text-white p-3"
                 style="background:#0d6efd;border-radius:.75rem;">
                <i class="material-icons mr-2">assignment</i>
                <b>Rekap Izin Siswa</b>
            </div>
        </div>
    </div>

    <!-- ================= BARIS 2 : FILTER & TOMBOL ================= -->
    <div class="row mb-4 align-items-end">

        <!-- KOLOM KIRI -->
        <div class="col-md-6 mb-2">
            <form method="get">
                <label class="font-weight-bold mb-1">
                    <i class="material-icons" style="font-size:18px">school</i> Pilih Kelas
                </label>
                <select name="kelas" class="form-select" onchange="this.form.submit()">
                    <option value="">-- Pilih Kelas --</option>
                    <?php foreach($kelasList as $kelas): ?>
                        <option value="<?= $kelas['id_kelas'] ?>"
                            <?= ($selectedKelas == $kelas['id_kelas']) ? 'selected' : '' ?>>
                            <?= $kelas['kelas'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </form>
        </div>

        <!-- KOLOM KANAN -->
        <div class="col-md-6 mb-2 text-md-right">
            <div class="d-flex justify-content-md-end gap-2 flex-wrap">

                <a href="<?= base_url('admin/piket/rekapizinsiswa?kelas='.$selectedKelas) ?>"
                   class="btn btn-primary">
                    <i class="material-icons">filter_list</i> Filter
                </a>

                <a href="<?= base_url('admin/piket/rekapizinsiswa/exportCSV?kelas='.$selectedKelas) ?>"
                   class="btn btn-success">
                    <i class="material-icons">download</i> Export
                </a>

                <a href="<?= base_url('admin/piket/suratizin') ?>"
                   class="btn btn-secondary">
                    <i class="material-icons">arrow_back</i> Kembali
                </a>

            </div>
        </div>

    </div>

    <!-- ================= BARIS 3 : TABEL DESKTOP ================= -->
    <div class="row">
        <div class="col-12">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Siswa</th>
                            <th>Kelas</th>
                            <th>Total Izin</th>
                            <th>Detail Izin</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no=1; foreach($rekap as $r): ?>
                        <tr>
                            <td class="td-center"><?= $no++ ?></td>
                            <td><?= $r['nama_siswa'] ?></td>
                            <td class="td-center"><?= $r['kelas'] ?></td>
                            <td class="td-center">
                                <span class="badge badge-primary">
                                    <?= $r['total_izin'] ?>
                                </span>
                            </td>
                            <td>
                                <ul class="detail-izin">
                                    <?php foreach($r['detail'] as $d): ?>
                                        <li>
                                            <i class="material-icons">event_note</i>
                                            <?= $d['tanggal'] ?> —
                                            <b><?= ucfirst($d['jenis']) ?></b>
                                            (<?= $d['keterangan'] ?>)
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- ================= MOBILE CARD MODE ================= -->
    <div class="izin-card-wrapper">
    <?php foreach($rekap as $r): ?>
        <div class="izin-card">
            <div class="izin-card-header">
                <i class="material-icons">person</i>
                <?= $r['nama_siswa'] ?>
            </div>

            <div class="izin-card-body">
                <div class="izin-row">
                    <span>Kelas</span>
                    <span><?= $r['kelas'] ?></span>
                </div>
                <div class="izin-row">
                    <span>Total Izin</span>
                    <span><b><?= $r['total_izin'] ?></b></span>
                </div>

                <hr>

                <b><i class="material-icons">assignment</i> Detail Izin</b>
                <ul class="detail-izin mt-2">
                    <?php foreach($r['detail'] as $d): ?>
                        <li>
                            <i class="material-icons">event</i>
                            <?= $d['tanggal'] ?> —
                            <?= ucfirst($d['jenis']) ?>
                            (<?= $d['keterangan'] ?>)
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    <?php endforeach; ?>
    </div>

</div>

</div>
</div>

<?= $this->endSection() ?>
