<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
.form-select { border-radius: 1rem; padding:.5rem 1rem; }
.card-custom { border-radius:1rem; box-shadow:0 6px 10px rgba(0,0,0,.08); background:#fff; }
.badge-status { border-radius:20px; padding:4px 12px; font-size:.8rem; font-weight:600; }
.badge-menunggu { background:#fff3cd; color:#856404; }
.badge-setujui { background:#d1e7dd; color:#0f5132; }
.table th, .table td { vertical-align:middle; font-size:.9rem; white-space:nowrap; }

/* === DESKTOP TABEL WARNA BARIS === */
tr.row-menunggu { background:#fff8e1; }

/* === MOBILE CARD === */
@media (max-width:768px){
    .table-responsive{ display:none; }

    .izin-card{
        border-radius:1rem;
        box-shadow:0 6px 12px rgba(0,0,0,.1);
        margin-bottom:1rem;
        overflow:hidden;
        background:#fff;
    }
    .izin-card.menunggu{ border-left:6px solid #ffc107; }
    .izin-card.setujui{ border-left:6px solid #198754; }

    .izin-card-header{
        padding:.75rem 1rem;
        font-weight:700;
        display:flex;
        justify-content:space-between;
        align-items:center;
        background:#f1f3f5;
    }
    .izin-card-body{
        padding:1rem;
        font-size:.9rem;
    }
    .izin-row{
        display:flex;
        justify-content:space-between;
        margin-bottom:.4rem;
    }
}
@media (min-width:769px){
    .izin-card-wrapper{ display:none; }
}
</style>

<div class="content py-4" style="background:#f8f9fa">
<div class="container-fluid">

<!-- ================= FORM (TIDAK DIUBAH) ================= -->
<div class="card card-custom p-4 mb-4">
    <div class="text-center fs-5 fw-bold text-white p-3 mb-3" style="background:#0d6efd;border-radius:.75rem;">
        📝 Form Input Izin / Sakit Siswa
    </div>

    <form id="formIzin" method="post" action="<?= base_url('admin/piket/suratizin/simpan') ?>">
    <?= csrf_field() ?>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Kelas</label>
            <select id="kelasInput" name="id_kelas" class="form-select" required>
                <option value="">-- Pilih Kelas --</option>
                <?php foreach($kelas as $k): ?>
                <option value="<?= $k['id_kelas'] ?>"><?= $k['kelas'] ?></option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="col-md-6 mb-3">
            <label>Siswa</label>
            <select id="siswaInput" name="id_siswa" class="form-select" required>
                <option value="">-- Pilih Siswa --</option>
                <?php foreach($siswa as $s): ?>
                <option value="<?= $s['id_siswa'] ?>" data-kelas="<?= $s['id_kelas'] ?>">
                    <?= $s['nama_siswa'] ?>
                </option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="col-md-6 mb-3">
            <label>Tanggal</label>
            <input type="date" name="tanggal" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>

        <div class="col-md-6 mb-3">
            <label>Jenis</label>
            <select name="jenis" class="form-select" required>
                <option value="">-- Pilih Jenis --</option>
                <option value="izin">Izin</option>
                <option value="sakit">Sakit</option>
            </select>
        </div>

        <div class="col-12 mb-3">
            <label>Keterangan</label>
            <textarea name="keterangan" class="form-control"></textarea>
        </div>

        <div class="col-md-6 mb-2">
            <button class="btn btn-primary w-100">💾 Simpan</button>
        </div>
        <div class="col-md-6 mb-2">
            <a href="<?= base_url('admin/menupiket') ?>" class="btn w-100" style="background:#ff44b7;color:#fff;">
                🔙 Kembali
            </a>
        </div>
        
        <div class="col-md-6 mb-2">
                   <div class="row mb-12">
                    <div class="col-md-12">
                        <a href="<?= base_url('admin/piket/rekapizinsiswa') ?>"
                        class="btn w-100 d-flex align-items-center justify-content-center"
                        style="background-color: #f3690d;color:#fff;">
                            <i class="material-icons mr-2">assignment</i>
                            Rekap Izin
                        </a>
                    </div>
                </div>
        </div>
 

    </div>
    </form>
</div>

<!-- ================= DATA IZIN ================= -->
<div class="card card-custom p-3">
    <div class="text-center fs-5 fw-bold text-white p-3 mb-3" style="background:#26bad4;border-radius:.75rem;">
        📝 Data Siswa Izin + Sakit
    </div>

    <!-- ===== DESKTOP TABLE ===== -->
    <div class="table-responsive">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>No</th><th>Siswa</th><th>Kelas</th><th>Jam</th>
                    <th>Jenis</th><th>Tanggal</th><th>Status</th><th>Aksi</th>
                </tr>
            </thead>
            <tbody>
            <?php $no=1; foreach($data as $i):
                $status = $i['status'] ?? 'menunggu';
            ?>
            <tr class="<?= $status=='menunggu'?'row-menunggu':'' ?>">
                <td><?= $no++ ?></td>
                <td><?= $i['nama_siswa'] ?></td>
                <td><?= $i['kelas'] ?></td>
                <td><?= $i['jam'] ?></td>
                <td><span class="badge bg-info"><?= ucfirst($i['jenis']) ?></span></td>
                <td><?= $i['tanggal'] ?></td>
                <td>
                    <span class="badge-status <?= $status=='menunggu'?'badge-menunggu':'badge-setujui' ?>">
                        <?= ucfirst($status) ?>
                    </span>
                </td>
                <td>
                <?php if($status=='menunggu'): ?>
                    <a href="<?= base_url('admin/piket/suratizin/setujui/'.$i['id_izin']) ?>" class="btn btn-success btn-sm">
                        ✔ Setujui
                    </a>
                <?php else: ?>
                    <a href="<?= base_url('admin/piket/suratizin/cetak/'.$i['id_izin']) ?>" target="_blank" class="btn btn-primary btn-sm">
                        🖨 Cetak
                    </a>
                <?php endif ?>
                </td>
            </tr>
            <?php endforeach ?>
            </tbody>
        </table>
    </div>

    <!-- ===== MOBILE CARD ===== -->
    <div class="izin-card-wrapper">
    <?php foreach($data as $i):
        $status = $i['status'] ?? 'menunggu';
    ?>
    <div class="izin-card <?= $status=='menunggu'?'menunggu':'setujui' ?>">
        <div class="izin-card-header">
            <span><?= $i['nama_siswa'] ?></span>
            <span class="badge-status <?= $status=='menunggu'?'badge-menunggu':'badge-setujui' ?>">
                <?= ucfirst($status) ?>
            </span>
        </div>

        <div class="izin-card-body">
            <div class="izin-row"><span>Kelas</span><span><?= $i['kelas'] ?></span></div>
            <div class="izin-row"><span>Jam</span><span><?= $i['jam'] ?></span></div>
            <div class="izin-row"><span>Jenis</span><span><?= ucfirst($i['jenis']) ?></span></div>
            <div class="izin-row"><span>Tanggal</span><span><?= $i['tanggal'] ?></span></div>
            <hr>
            <?php if($status=='menunggu'): ?>
                <a href="<?= base_url('admin/piket/suratizin/setujui/'.$i['id_izin']) ?>"
                   class="btn btn-success w-100 btn-sm">✔ Setujui</a>
            <?php else: ?>
                <a href="<?= base_url('admin/piket/suratizin/cetak/'.$i['id_izin']) ?>"
                   target="_blank"
                   class="btn btn-primary w-100 btn-sm">🖨 Cetak</a>
            <?php endif ?>
        </div>
    </div>
    <?php endforeach ?>
    </div>

</div>

</div>
</div>

<script>
const kelasInput=document.getElementById('kelasInput');
const siswaInput=document.getElementById('siswaInput');
kelasInput.addEventListener('change',()=>{
    const k=kelasInput.value;
    for(let o of siswaInput.options){
        const dk=o.getAttribute('data-kelas');
        o.style.display=(!dk||dk===k)?'block':'none';
    }
    siswaInput.value='';
});
</script>

<?= $this->endSection() ?>
