<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
    .progress-siswa{
        height:5px;
        background: #ba7cde;
    }
    .progress-guru{
        height:5px;
        background: #3ac055;
    }
    .my-progress-bar{
        height:5px;
        background: #f80c2f;
    }
</style>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12">

        <?php if(session()->getFlashdata('msg')): ?>
        <div class="pb-2 px-3">
            <div class="alert alert-<?= session()->getFlashdata('error') ? 'danger':'success' ?>">
                <button type="button" class="close" data-dismiss="alert">
                    <i class="material-icons">close</i>
                </button>
                <?= session()->getFlashdata('msg') ?>
            </div>
        </div>
        <?php endif; ?>

<div class="card">
<div class="card-header card-header-danger">
    <h4 class="card-title"><b>Generate QR Code</b></h4>
    <!-- <p class="card-category">Download Kode Unik untuk Proses Scanning</p> -->
</div>

<div class="card-body">
<div class="row">

<!-- ================= PETUNJUK DOWNLOAD QR CODE ================= -->
<div class="col-md-6">
  <div class="card">
    <div class="card-body">

      <h4 class="text-success mb-3"><b><i class="material-icons">info</i> PETUNJUK DOWNLOAD SEMUA QR CODE</b></h4>

      <ul class="list-group list-group-flush">
        <li class="list-group-item">
          <i class="material-icons text-primary" style="vertical-align:middle;">qr_code</i>
          <span class="ml-2">Klik tombol <b>"Generate All"</b> untuk membuat QR Code semua siswa.</span>
        </li>
        <li class="list-group-item">
          <i class="material-icons text-warning" style="vertical-align:middle;">cloud_download</i>
          <span class="ml-2">Klik tombol <b>"Download All"</b> untuk men-download semua QR siswa.</span>
        </li>

        <!-- <li class="list-group-item">
          <i class="material-icons text-danger" style="vertical-align:middle;">warning</i>
          <span class="ml-2">File QR tersimpan di <code>/public/uploads</code>. Pastikan folder dapat diakses dan writable.</span>
        </li> -->
      </ul>


      <div class="mt-3"></div>



<h4 class="text-success mb-3"><b><i class="material-icons">info</i> PETUNJUK DOWNLOAD QR CODE PER KELAS</b></h4>

      <ul class="list-group list-group-flush">
        <li class="list-group-item">
          <i class="material-icons text-primary" style="vertical-align:middle;">qr_code</i>
          <span class="ml-2">Untuk QR per kelas, pilih kelas terlebih dahulu, lalu klik <b>"Generate"</b>.</span>
        </li>
        <li class="list-group-item">
          <i class="material-icons text-warning" style="vertical-align:middle;">cloud_download</i>
          <span class="ml-2">Klik tombol <b>"Download"</b> untuk men-download Kode QR Per Kelas.</span>
        </li>
        
        <!-- <li class="list-group-item">
          <i class="material-icons text-danger" style="vertical-align:middle;">warning</i>
          <span class="ml-2">File QR tersimpan di <code>/public/uploads</code>. Pastikan folder dapat diakses dan writable.</span>
        </li> -->
        <!-- <li class="list-group-item">
          <i class="material-icons text-info" style="vertical-align:middle;">people</i>
          <span class="ml-2">Untuk QR guru, klik tombol <b>"Download QR Guru"</b> di bawah.</span>
        </li> -->
      </ul>










      <div class="mt-3">
        <a href="<?= base_url('admin/menudata') ?>" class="btn btn-success w-100">
          <i class="material-icons">qr_code</i> Kembali Ke Menu
        </a>
      </div>

    </div>
  </div>
</div>
<!-- ==================================================================================================== -->
<!-- ================= SISWA ================= -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">

            <h4 style="color: #4d1463;" class="mb-3"><b><i class="material-icons">people</i> DATA QR CODE SEMUA SISWA</b></h4>
            <!-- <h4 class="text-success mb-3"><b><i class="material-icons">people</i> DATA QR CODE SEMUA SISWA</b></h4> -->
            <!-- <h4 class="text-primary"><b>Data Siswa</b></h4> -->
            <p>
            Total jumlah siswa : <b><?= count($siswa) ?></b><br>
            <a href="<?= base_url('admin/siswa') ?>">Lihat data</a>
            </p>

            <div class="row px-2">
            <div class="col-xl-6 px-1">
            <button class="btn btn-primary w-100" onclick="generateAllQrSiswa()">
            <i class="material-icons">qr_code</i> Generate All
            <div id="progressSiswa" class="d-none mt-2">
            <span id="progressTextSiswa"></span>
            <div class="progress progress-siswa">
            <div id="progressBarSiswa" class="progress-bar my-progress-bar bg-white" style="width:0%"></div>
            </div>
            </div>
            </button>
            </div>

            <div class="col-xl-6 px-1">
            <a href="<?= base_url('admin/qr/siswa/download') ?>" class="btn btn-primary w-100">
            <i class="material-icons">cloud_download</i> Download All
            </a>
            </div>
            </div>
            <div></div>

            <hr>

            <!-- <h4 class="text-primary"><b>Generate per Kelas</b></h4> -->
            <h4 style="color: #4d1463;" class="mb-3"><b><i class="material-icons">people</i> Generate QR CODE Per Kelas</b></h4>
            <form action="<?= base_url('admin/qr/siswa/download') ?>" method="get">
            <select id="kelasSelect" name="id_kelas" class="custom-select mb-2" required>
            <option value="">-- Pilih kelas --</option>
            <?php foreach($kelas as $k): ?>
            <option value="<?= $k['id_kelas'] ?>">
            <?= $k['kelas'].' '.$k['jurusan'] ?>
            </option>
            <?php endforeach ?>
            </select>

            <b class="text-danger" id="textErrorKelas"></b>

            <div class="row px-2 mt-2">
            <div class="col-xl-6 px-1">
            <button type="button" class="btn btn-primary w-100" onclick="generateQrSiswaByKelas()">
            <i class="material-icons">qr_code</i> Generate
            <div id="progressKelas" class="d-none mt-2">
            <span id="progressTextKelas"></span>
            <div class="progress progress-siswa">
            <div id="progressBarKelas" class="progress-bar my-progress-bar bg-white" style="width:0%"></div>
            </div>
            </div>
            </button>
            </div>

            <div class="col-xl-6 px-1">
            <button class="btn btn-primary w-100">
            <i class="material-icons">cloud_download</i> Download
            </button>
            </div>                  
            </div>
                <div class="mt-3">
                    <a href="<?= base_url('admin/menudata') ?>" class="btn btn-success w-100">
                    <i class="material-icons">qr_code</i> Kembali Ke Menu
                    </a>
                </div>
            </form>
            </div>
        </div>
    </div>
  <!-- ==================================================================================================== -->







</div>
</div>

</div>
</div>
</div>
</div>

<script>
const dataSiswa = <?= json_encode($siswa) ?>;
const dataGuru  = <?= json_encode($guru) ?>;
let dataSiswaPerKelas = [];

function generateAllQrSiswa(){
let i=1;
$('#progressSiswa').removeClass('d-none');
dataSiswa.forEach(el=>{
$.post("<?= base_url('admin/generate/siswa') ?>",{
nama:el.nama_siswa,
unique_code:el.unique_code,
id_kelas:el.id_kelas,
nomor:el.nis
},()=>{
$('#progressTextSiswa').text(`Progres ${i}/${dataSiswa.length}`);
$('#progressBarSiswa').css('width',(i/dataSiswa.length*100)+'%');
i++;
});
});
}

function generateQrSiswaByKelas(){
let idKelas=$('#kelasSelect').val();
if(!idKelas){$('#textErrorKelas').text('Pilih kelas');return;}

$.post("<?= base_url('admin/generate/siswa-by-kelas') ?>",{idKelas},res=>{
dataSiswaPerKelas=res;
let i=1;
$('#progressKelas').removeClass('d-none');

res.forEach(el=>{
$.post("<?= base_url('admin/generate/siswa') ?>",{
nama:el.nama_siswa,
unique_code:el.unique_code,
id_kelas:el.id_kelas,
nomor:el.nis
},()=>{
$('#progressTextKelas').text(`Progres ${i}/${res.length}`);
$('#progressBarKelas').css('width',(i/res.length*100)+'%');
i++;
});
});
});
}

function generateAllQrGuru(){
let i=1;
$('#progressGuru').removeClass('d-none');
dataGuru.forEach(el=>{
$.post("<?= base_url('admin/generate/guru') ?>",{
nama:el.nama_guru,
unique_code:el.unique_code,
nomor:el.nuptk
},()=>{
$('#progressTextGuru').text(`Progres ${i}/${dataGuru.length}`);
$('#progressBarGuru').css('width',(i/dataGuru.length*100)+'%');
i++;
});
});
}
</script>

<?= $this->endSection() ?>
