<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content py-4">
    <div class="container">
        <h2 class="mb-4"><?= esc($title) ?></h2>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
        <?php endif; ?>

        <form action="<?= base_url('admin/restore/run') ?>" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="sql_file" class="form-label">Pilih file SQL untuk restore:</label>
                <input type="file" name="sql_file" id="sql_file" class="form-control" required>
            </div>

            <button type="submit" class="btn btn-gradient-primary d-flex align-items-center">
                <i class="material-icons me-2">restore</i> Restore Database
            </button>

            <a href="<?= base_url('admin/backup') ?>" class="btn btn-secondary ms-2">Kembali</a>
        </form>
    </div>
</div>

<style>
.btn-gradient-primary {
    background: linear-gradient(90deg, #6a11cb, #2575fc);
    color: #fff;
    font-weight: 500;
    transition: all 0.3s ease;
}
.btn-gradient-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(37, 117, 252, 0.5);
}
</style>

<?= $this->endSection() ?>
